/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codepipeline.model;

import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.protocol.StructuredPojo;
import software.amazon.awssdk.services.codepipeline.model.ApprovalStatus;
import software.amazon.awssdk.services.codepipeline.transform.ApprovalResultMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class ApprovalResult
implements StructuredPojo,
ToCopyableBuilder<Builder, ApprovalResult> {
    private final String summary;
    private final String status;

    private ApprovalResult(BuilderImpl builder) {
        this.summary = builder.summary;
        this.status = builder.status;
    }

    public String summary() {
        return this.summary;
    }

    public String status() {
        return this.status;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.summary() == null ? 0 : this.summary().hashCode());
        hashCode = 31 * hashCode + (this.status() == null ? 0 : this.status().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ApprovalResult)) {
            return false;
        }
        ApprovalResult other = (ApprovalResult)obj;
        if (other.summary() == null ^ this.summary() == null) {
            return false;
        }
        if (other.summary() != null && !other.summary().equals(this.summary())) {
            return false;
        }
        if (other.status() == null ^ this.status() == null) {
            return false;
        }
        return other.status() == null || other.status().equals(this.status());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.summary() != null) {
            sb.append("Summary: ").append(this.summary()).append(",");
        }
        if (this.status() != null) {
            sb.append("Status: ").append(this.status()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        ApprovalResultMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    private static final class BuilderImpl
    implements Builder {
        private String summary;
        private String status;

        private BuilderImpl() {
        }

        private BuilderImpl(ApprovalResult model) {
            this.setSummary(model.summary);
            this.setStatus(model.status);
        }

        public final String getSummary() {
            return this.summary;
        }

        @Override
        public final Builder summary(String summary) {
            this.summary = summary;
            return this;
        }

        public final void setSummary(String summary) {
            this.summary = summary;
        }

        public final String getStatus() {
            return this.status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(ApprovalStatus status) {
            this.status(status.toString());
            return this;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        public final void setStatus(ApprovalStatus status) {
            this.status(status.toString());
        }

        public ApprovalResult build() {
            return new ApprovalResult(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, ApprovalResult> {
        public Builder summary(String var1);

        public Builder status(String var1);

        public Builder status(ApprovalStatus var1);
    }
}

