/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.codegurusecurity.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetMetricsSummaryResponse extends CodeGuruSecurityResponse implements
        ToCopyableBuilder<GetMetricsSummaryResponse.Builder, GetMetricsSummaryResponse> {
    private static final SdkField<MetricsSummary> METRICS_SUMMARY_FIELD = SdkField
            .<MetricsSummary> builder(MarshallingType.SDK_POJO).memberName("metricsSummary")
            .getter(getter(GetMetricsSummaryResponse::metricsSummary)).setter(setter(Builder::metricsSummary))
            .constructor(MetricsSummary::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("metricsSummary").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(METRICS_SUMMARY_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final MetricsSummary metricsSummary;

    private GetMetricsSummaryResponse(BuilderImpl builder) {
        super(builder);
        this.metricsSummary = builder.metricsSummary;
    }

    /**
     * <p>
     * The summary metrics from the specified date.
     * </p>
     * 
     * @return The summary metrics from the specified date.
     */
    public final MetricsSummary metricsSummary() {
        return metricsSummary;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(metricsSummary());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetMetricsSummaryResponse)) {
            return false;
        }
        GetMetricsSummaryResponse other = (GetMetricsSummaryResponse) obj;
        return Objects.equals(metricsSummary(), other.metricsSummary());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetMetricsSummaryResponse").add("MetricsSummary", metricsSummary()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "metricsSummary":
            return Optional.ofNullable(clazz.cast(metricsSummary()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("metricsSummary", METRICS_SUMMARY_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetMetricsSummaryResponse, T> g) {
        return obj -> g.apply((GetMetricsSummaryResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends CodeGuruSecurityResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, GetMetricsSummaryResponse> {
        /**
         * <p>
         * The summary metrics from the specified date.
         * </p>
         * 
         * @param metricsSummary
         *        The summary metrics from the specified date.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder metricsSummary(MetricsSummary metricsSummary);

        /**
         * <p>
         * The summary metrics from the specified date.
         * </p>
         * This is a convenience method that creates an instance of the {@link MetricsSummary.Builder} avoiding the need
         * to create one manually via {@link MetricsSummary#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link MetricsSummary.Builder#build()} is called immediately and its
         * result is passed to {@link #metricsSummary(MetricsSummary)}.
         * 
         * @param metricsSummary
         *        a consumer that will call methods on {@link MetricsSummary.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #metricsSummary(MetricsSummary)
         */
        default Builder metricsSummary(Consumer<MetricsSummary.Builder> metricsSummary) {
            return metricsSummary(MetricsSummary.builder().applyMutation(metricsSummary).build());
        }
    }

    static final class BuilderImpl extends CodeGuruSecurityResponse.BuilderImpl implements Builder {
        private MetricsSummary metricsSummary;

        private BuilderImpl() {
        }

        private BuilderImpl(GetMetricsSummaryResponse model) {
            super(model);
            metricsSummary(model.metricsSummary);
        }

        public final MetricsSummary.Builder getMetricsSummary() {
            return metricsSummary != null ? metricsSummary.toBuilder() : null;
        }

        public final void setMetricsSummary(MetricsSummary.BuilderImpl metricsSummary) {
            this.metricsSummary = metricsSummary != null ? metricsSummary.build() : null;
        }

        @Override
        public final Builder metricsSummary(MetricsSummary metricsSummary) {
            this.metricsSummary = metricsSummary;
            return this;
        }

        @Override
        public GetMetricsSummaryResponse build() {
            return new GetMetricsSummaryResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
