/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codegurusecurity.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.codegurusecurity.model.FindingMetricsValuePerSeverity;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AccountFindingsMetric
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, AccountFindingsMetric> {
    private static final SdkField<Instant> DATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("date").getter(AccountFindingsMetric.getter(AccountFindingsMetric::date)).setter(AccountFindingsMetric.setter(Builder::date)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("date").build()}).build();
    private static final SdkField<FindingMetricsValuePerSeverity> NEW_FINDINGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("newFindings").getter(AccountFindingsMetric.getter(AccountFindingsMetric::newFindings)).setter(AccountFindingsMetric.setter(Builder::newFindings)).constructor(FindingMetricsValuePerSeverity::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("newFindings").build()}).build();
    private static final SdkField<FindingMetricsValuePerSeverity> CLOSED_FINDINGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("closedFindings").getter(AccountFindingsMetric.getter(AccountFindingsMetric::closedFindings)).setter(AccountFindingsMetric.setter(Builder::closedFindings)).constructor(FindingMetricsValuePerSeverity::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("closedFindings").build()}).build();
    private static final SdkField<FindingMetricsValuePerSeverity> OPEN_FINDINGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("openFindings").getter(AccountFindingsMetric.getter(AccountFindingsMetric::openFindings)).setter(AccountFindingsMetric.setter(Builder::openFindings)).constructor(FindingMetricsValuePerSeverity::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("openFindings").build()}).build();
    private static final SdkField<FindingMetricsValuePerSeverity> MEAN_TIME_TO_CLOSE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("meanTimeToClose").getter(AccountFindingsMetric.getter(AccountFindingsMetric::meanTimeToClose)).setter(AccountFindingsMetric.setter(Builder::meanTimeToClose)).constructor(FindingMetricsValuePerSeverity::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("meanTimeToClose").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DATE_FIELD, NEW_FINDINGS_FIELD, CLOSED_FINDINGS_FIELD, OPEN_FINDINGS_FIELD, MEAN_TIME_TO_CLOSE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = AccountFindingsMetric.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final Instant date;
    private final FindingMetricsValuePerSeverity newFindings;
    private final FindingMetricsValuePerSeverity closedFindings;
    private final FindingMetricsValuePerSeverity openFindings;
    private final FindingMetricsValuePerSeverity meanTimeToClose;

    private AccountFindingsMetric(BuilderImpl builder) {
        this.date = builder.date;
        this.newFindings = builder.newFindings;
        this.closedFindings = builder.closedFindings;
        this.openFindings = builder.openFindings;
        this.meanTimeToClose = builder.meanTimeToClose;
    }

    public final Instant date() {
        return this.date;
    }

    public final FindingMetricsValuePerSeverity newFindings() {
        return this.newFindings;
    }

    public final FindingMetricsValuePerSeverity closedFindings() {
        return this.closedFindings;
    }

    public final FindingMetricsValuePerSeverity openFindings() {
        return this.openFindings;
    }

    public final FindingMetricsValuePerSeverity meanTimeToClose() {
        return this.meanTimeToClose;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.date());
        hashCode = 31 * hashCode + Objects.hashCode(this.newFindings());
        hashCode = 31 * hashCode + Objects.hashCode(this.closedFindings());
        hashCode = 31 * hashCode + Objects.hashCode(this.openFindings());
        hashCode = 31 * hashCode + Objects.hashCode(this.meanTimeToClose());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AccountFindingsMetric)) {
            return false;
        }
        AccountFindingsMetric other = (AccountFindingsMetric)obj;
        return Objects.equals(this.date(), other.date()) && Objects.equals(this.newFindings(), other.newFindings()) && Objects.equals(this.closedFindings(), other.closedFindings()) && Objects.equals(this.openFindings(), other.openFindings()) && Objects.equals(this.meanTimeToClose(), other.meanTimeToClose());
    }

    public final String toString() {
        return ToString.builder((String)"AccountFindingsMetric").add("Date", (Object)this.date()).add("NewFindings", (Object)this.newFindings()).add("ClosedFindings", (Object)this.closedFindings()).add("OpenFindings", (Object)this.openFindings()).add("MeanTimeToClose", (Object)this.meanTimeToClose()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "date": {
                return Optional.ofNullable(clazz.cast(this.date()));
            }
            case "newFindings": {
                return Optional.ofNullable(clazz.cast(this.newFindings()));
            }
            case "closedFindings": {
                return Optional.ofNullable(clazz.cast(this.closedFindings()));
            }
            case "openFindings": {
                return Optional.ofNullable(clazz.cast(this.openFindings()));
            }
            case "meanTimeToClose": {
                return Optional.ofNullable(clazz.cast(this.meanTimeToClose()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("date", DATE_FIELD);
        map.put("newFindings", NEW_FINDINGS_FIELD);
        map.put("closedFindings", CLOSED_FINDINGS_FIELD);
        map.put("openFindings", OPEN_FINDINGS_FIELD);
        map.put("meanTimeToClose", MEAN_TIME_TO_CLOSE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<AccountFindingsMetric, T> g) {
        return obj -> g.apply((AccountFindingsMetric)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Instant date;
        private FindingMetricsValuePerSeverity newFindings;
        private FindingMetricsValuePerSeverity closedFindings;
        private FindingMetricsValuePerSeverity openFindings;
        private FindingMetricsValuePerSeverity meanTimeToClose;

        private BuilderImpl() {
        }

        private BuilderImpl(AccountFindingsMetric model) {
            this.date(model.date);
            this.newFindings(model.newFindings);
            this.closedFindings(model.closedFindings);
            this.openFindings(model.openFindings);
            this.meanTimeToClose(model.meanTimeToClose);
        }

        public final Instant getDate() {
            return this.date;
        }

        public final void setDate(Instant date) {
            this.date = date;
        }

        @Override
        public final Builder date(Instant date) {
            this.date = date;
            return this;
        }

        public final FindingMetricsValuePerSeverity.Builder getNewFindings() {
            return this.newFindings != null ? this.newFindings.toBuilder() : null;
        }

        public final void setNewFindings(FindingMetricsValuePerSeverity.BuilderImpl newFindings) {
            this.newFindings = newFindings != null ? newFindings.build() : null;
        }

        @Override
        public final Builder newFindings(FindingMetricsValuePerSeverity newFindings) {
            this.newFindings = newFindings;
            return this;
        }

        public final FindingMetricsValuePerSeverity.Builder getClosedFindings() {
            return this.closedFindings != null ? this.closedFindings.toBuilder() : null;
        }

        public final void setClosedFindings(FindingMetricsValuePerSeverity.BuilderImpl closedFindings) {
            this.closedFindings = closedFindings != null ? closedFindings.build() : null;
        }

        @Override
        public final Builder closedFindings(FindingMetricsValuePerSeverity closedFindings) {
            this.closedFindings = closedFindings;
            return this;
        }

        public final FindingMetricsValuePerSeverity.Builder getOpenFindings() {
            return this.openFindings != null ? this.openFindings.toBuilder() : null;
        }

        public final void setOpenFindings(FindingMetricsValuePerSeverity.BuilderImpl openFindings) {
            this.openFindings = openFindings != null ? openFindings.build() : null;
        }

        @Override
        public final Builder openFindings(FindingMetricsValuePerSeverity openFindings) {
            this.openFindings = openFindings;
            return this;
        }

        public final FindingMetricsValuePerSeverity.Builder getMeanTimeToClose() {
            return this.meanTimeToClose != null ? this.meanTimeToClose.toBuilder() : null;
        }

        public final void setMeanTimeToClose(FindingMetricsValuePerSeverity.BuilderImpl meanTimeToClose) {
            this.meanTimeToClose = meanTimeToClose != null ? meanTimeToClose.build() : null;
        }

        @Override
        public final Builder meanTimeToClose(FindingMetricsValuePerSeverity meanTimeToClose) {
            this.meanTimeToClose = meanTimeToClose;
            return this;
        }

        public AccountFindingsMetric build() {
            return new AccountFindingsMetric(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, AccountFindingsMetric> {
        public Builder date(Instant var1);

        public Builder newFindings(FindingMetricsValuePerSeverity var1);

        default public Builder newFindings(Consumer<FindingMetricsValuePerSeverity.Builder> newFindings) {
            return this.newFindings((FindingMetricsValuePerSeverity)((FindingMetricsValuePerSeverity.Builder)FindingMetricsValuePerSeverity.builder().applyMutation(newFindings)).build());
        }

        public Builder closedFindings(FindingMetricsValuePerSeverity var1);

        default public Builder closedFindings(Consumer<FindingMetricsValuePerSeverity.Builder> closedFindings) {
            return this.closedFindings((FindingMetricsValuePerSeverity)((FindingMetricsValuePerSeverity.Builder)FindingMetricsValuePerSeverity.builder().applyMutation(closedFindings)).build());
        }

        public Builder openFindings(FindingMetricsValuePerSeverity var1);

        default public Builder openFindings(Consumer<FindingMetricsValuePerSeverity.Builder> openFindings) {
            return this.openFindings((FindingMetricsValuePerSeverity)((FindingMetricsValuePerSeverity.Builder)FindingMetricsValuePerSeverity.builder().applyMutation(openFindings)).build());
        }

        public Builder meanTimeToClose(FindingMetricsValuePerSeverity var1);

        default public Builder meanTimeToClose(Consumer<FindingMetricsValuePerSeverity.Builder> meanTimeToClose) {
            return this.meanTimeToClose((FindingMetricsValuePerSeverity)((FindingMetricsValuePerSeverity.Builder)FindingMetricsValuePerSeverity.builder().applyMutation(meanTimeToClose)).build());
        }
    }
}

