/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codegurusecurity.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.codegurusecurity.model.FilePath;
import software.amazon.awssdk.services.codegurusecurity.model.ReferenceUrlsCopier;
import software.amazon.awssdk.services.codegurusecurity.model.RelatedVulnerabilitiesCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Vulnerability
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Vulnerability> {
    private static final SdkField<FilePath> FILE_PATH_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("filePath").getter(Vulnerability.getter(Vulnerability::filePath)).setter(Vulnerability.setter(Builder::filePath)).constructor(FilePath::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("filePath").build()}).build();
    private static final SdkField<String> ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("id").getter(Vulnerability.getter(Vulnerability::id)).setter(Vulnerability.setter(Builder::id)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("id").build()}).build();
    private static final SdkField<Integer> ITEM_COUNT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("itemCount").getter(Vulnerability.getter(Vulnerability::itemCount)).setter(Vulnerability.setter(Builder::itemCount)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("itemCount").build()}).build();
    private static final SdkField<List<String>> REFERENCE_URLS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("referenceUrls").getter(Vulnerability.getter(Vulnerability::referenceUrls)).setter(Vulnerability.setter(Builder::referenceUrls)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("referenceUrls").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> RELATED_VULNERABILITIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("relatedVulnerabilities").getter(Vulnerability.getter(Vulnerability::relatedVulnerabilities)).setter(Vulnerability.setter(Builder::relatedVulnerabilities)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("relatedVulnerabilities").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FILE_PATH_FIELD, ID_FIELD, ITEM_COUNT_FIELD, REFERENCE_URLS_FIELD, RELATED_VULNERABILITIES_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Vulnerability.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final FilePath filePath;
    private final String id;
    private final Integer itemCount;
    private final List<String> referenceUrls;
    private final List<String> relatedVulnerabilities;

    private Vulnerability(BuilderImpl builder) {
        this.filePath = builder.filePath;
        this.id = builder.id;
        this.itemCount = builder.itemCount;
        this.referenceUrls = builder.referenceUrls;
        this.relatedVulnerabilities = builder.relatedVulnerabilities;
    }

    public final FilePath filePath() {
        return this.filePath;
    }

    public final String id() {
        return this.id;
    }

    @Deprecated
    public final Integer itemCount() {
        return this.itemCount;
    }

    public final boolean hasReferenceUrls() {
        return this.referenceUrls != null && !(this.referenceUrls instanceof SdkAutoConstructList);
    }

    public final List<String> referenceUrls() {
        return this.referenceUrls;
    }

    public final boolean hasRelatedVulnerabilities() {
        return this.relatedVulnerabilities != null && !(this.relatedVulnerabilities instanceof SdkAutoConstructList);
    }

    public final List<String> relatedVulnerabilities() {
        return this.relatedVulnerabilities;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.filePath());
        hashCode = 31 * hashCode + Objects.hashCode(this.id());
        hashCode = 31 * hashCode + Objects.hashCode(this.itemCount());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasReferenceUrls() ? this.referenceUrls() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasRelatedVulnerabilities() ? this.relatedVulnerabilities() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Vulnerability)) {
            return false;
        }
        Vulnerability other = (Vulnerability)obj;
        return Objects.equals(this.filePath(), other.filePath()) && Objects.equals(this.id(), other.id()) && Objects.equals(this.itemCount(), other.itemCount()) && this.hasReferenceUrls() == other.hasReferenceUrls() && Objects.equals(this.referenceUrls(), other.referenceUrls()) && this.hasRelatedVulnerabilities() == other.hasRelatedVulnerabilities() && Objects.equals(this.relatedVulnerabilities(), other.relatedVulnerabilities());
    }

    public final String toString() {
        return ToString.builder((String)"Vulnerability").add("FilePath", (Object)this.filePath()).add("Id", (Object)this.id()).add("ItemCount", (Object)this.itemCount()).add("ReferenceUrls", this.hasReferenceUrls() ? this.referenceUrls() : null).add("RelatedVulnerabilities", this.hasRelatedVulnerabilities() ? this.relatedVulnerabilities() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "filePath": {
                return Optional.ofNullable(clazz.cast(this.filePath()));
            }
            case "id": {
                return Optional.ofNullable(clazz.cast(this.id()));
            }
            case "itemCount": {
                return Optional.ofNullable(clazz.cast(this.itemCount()));
            }
            case "referenceUrls": {
                return Optional.ofNullable(clazz.cast(this.referenceUrls()));
            }
            case "relatedVulnerabilities": {
                return Optional.ofNullable(clazz.cast(this.relatedVulnerabilities()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("filePath", FILE_PATH_FIELD);
        map.put("id", ID_FIELD);
        map.put("itemCount", ITEM_COUNT_FIELD);
        map.put("referenceUrls", REFERENCE_URLS_FIELD);
        map.put("relatedVulnerabilities", RELATED_VULNERABILITIES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<Vulnerability, T> g) {
        return obj -> g.apply((Vulnerability)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private FilePath filePath;
        private String id;
        private Integer itemCount;
        private List<String> referenceUrls = DefaultSdkAutoConstructList.getInstance();
        private List<String> relatedVulnerabilities = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(Vulnerability model) {
            this.filePath(model.filePath);
            this.id(model.id);
            this.itemCount(model.itemCount);
            this.referenceUrls(model.referenceUrls);
            this.relatedVulnerabilities(model.relatedVulnerabilities);
        }

        public final FilePath.Builder getFilePath() {
            return this.filePath != null ? this.filePath.toBuilder() : null;
        }

        public final void setFilePath(FilePath.BuilderImpl filePath) {
            this.filePath = filePath != null ? filePath.build() : null;
        }

        @Override
        public final Builder filePath(FilePath filePath) {
            this.filePath = filePath;
            return this;
        }

        public final String getId() {
            return this.id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        @Deprecated
        public final Integer getItemCount() {
            return this.itemCount;
        }

        @Deprecated
        public final void setItemCount(Integer itemCount) {
            this.itemCount = itemCount;
        }

        @Override
        @Deprecated
        public final Builder itemCount(Integer itemCount) {
            this.itemCount = itemCount;
            return this;
        }

        public final Collection<String> getReferenceUrls() {
            if (this.referenceUrls instanceof SdkAutoConstructList) {
                return null;
            }
            return this.referenceUrls;
        }

        public final void setReferenceUrls(Collection<String> referenceUrls) {
            this.referenceUrls = ReferenceUrlsCopier.copy(referenceUrls);
        }

        @Override
        public final Builder referenceUrls(Collection<String> referenceUrls) {
            this.referenceUrls = ReferenceUrlsCopier.copy(referenceUrls);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder referenceUrls(String ... referenceUrls) {
            this.referenceUrls(Arrays.asList(referenceUrls));
            return this;
        }

        public final Collection<String> getRelatedVulnerabilities() {
            if (this.relatedVulnerabilities instanceof SdkAutoConstructList) {
                return null;
            }
            return this.relatedVulnerabilities;
        }

        public final void setRelatedVulnerabilities(Collection<String> relatedVulnerabilities) {
            this.relatedVulnerabilities = RelatedVulnerabilitiesCopier.copy(relatedVulnerabilities);
        }

        @Override
        public final Builder relatedVulnerabilities(Collection<String> relatedVulnerabilities) {
            this.relatedVulnerabilities = RelatedVulnerabilitiesCopier.copy(relatedVulnerabilities);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder relatedVulnerabilities(String ... relatedVulnerabilities) {
            this.relatedVulnerabilities(Arrays.asList(relatedVulnerabilities));
            return this;
        }

        public Vulnerability build() {
            return new Vulnerability(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Vulnerability> {
        public Builder filePath(FilePath var1);

        default public Builder filePath(Consumer<FilePath.Builder> filePath) {
            return this.filePath((FilePath)((FilePath.Builder)FilePath.builder().applyMutation(filePath)).build());
        }

        public Builder id(String var1);

        @Deprecated
        public Builder itemCount(Integer var1);

        public Builder referenceUrls(Collection<String> var1);

        public Builder referenceUrls(String ... var1);

        public Builder relatedVulnerabilities(Collection<String> var1);

        public Builder relatedVulnerabilities(String ... var1);
    }
}

