/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codegurusecurity.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.codegurusecurity.model.FindingMetricsValuePerSeverity;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AccountFindingsMetric
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, AccountFindingsMetric> {
    private static final SdkField<FindingMetricsValuePerSeverity> CLOSED_FINDINGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("closedFindings").getter(AccountFindingsMetric.getter(AccountFindingsMetric::closedFindings)).setter(AccountFindingsMetric.setter(Builder::closedFindings)).constructor(FindingMetricsValuePerSeverity::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("closedFindings").build()}).build();
    private static final SdkField<Instant> DATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("date").getter(AccountFindingsMetric.getter(AccountFindingsMetric::date)).setter(AccountFindingsMetric.setter(Builder::date)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("date").build()}).build();
    private static final SdkField<FindingMetricsValuePerSeverity> MEAN_TIME_TO_CLOSE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("meanTimeToClose").getter(AccountFindingsMetric.getter(AccountFindingsMetric::meanTimeToClose)).setter(AccountFindingsMetric.setter(Builder::meanTimeToClose)).constructor(FindingMetricsValuePerSeverity::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("meanTimeToClose").build()}).build();
    private static final SdkField<FindingMetricsValuePerSeverity> NEW_FINDINGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("newFindings").getter(AccountFindingsMetric.getter(AccountFindingsMetric::newFindings)).setter(AccountFindingsMetric.setter(Builder::newFindings)).constructor(FindingMetricsValuePerSeverity::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("newFindings").build()}).build();
    private static final SdkField<FindingMetricsValuePerSeverity> OPEN_FINDINGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("openFindings").getter(AccountFindingsMetric.getter(AccountFindingsMetric::openFindings)).setter(AccountFindingsMetric.setter(Builder::openFindings)).constructor(FindingMetricsValuePerSeverity::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("openFindings").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CLOSED_FINDINGS_FIELD, DATE_FIELD, MEAN_TIME_TO_CLOSE_FIELD, NEW_FINDINGS_FIELD, OPEN_FINDINGS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = AccountFindingsMetric.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final FindingMetricsValuePerSeverity closedFindings;
    private final Instant date;
    private final FindingMetricsValuePerSeverity meanTimeToClose;
    private final FindingMetricsValuePerSeverity newFindings;
    private final FindingMetricsValuePerSeverity openFindings;

    private AccountFindingsMetric(BuilderImpl builder) {
        this.closedFindings = builder.closedFindings;
        this.date = builder.date;
        this.meanTimeToClose = builder.meanTimeToClose;
        this.newFindings = builder.newFindings;
        this.openFindings = builder.openFindings;
    }

    public final FindingMetricsValuePerSeverity closedFindings() {
        return this.closedFindings;
    }

    public final Instant date() {
        return this.date;
    }

    public final FindingMetricsValuePerSeverity meanTimeToClose() {
        return this.meanTimeToClose;
    }

    public final FindingMetricsValuePerSeverity newFindings() {
        return this.newFindings;
    }

    public final FindingMetricsValuePerSeverity openFindings() {
        return this.openFindings;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.closedFindings());
        hashCode = 31 * hashCode + Objects.hashCode(this.date());
        hashCode = 31 * hashCode + Objects.hashCode(this.meanTimeToClose());
        hashCode = 31 * hashCode + Objects.hashCode(this.newFindings());
        hashCode = 31 * hashCode + Objects.hashCode(this.openFindings());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AccountFindingsMetric)) {
            return false;
        }
        AccountFindingsMetric other = (AccountFindingsMetric)obj;
        return Objects.equals(this.closedFindings(), other.closedFindings()) && Objects.equals(this.date(), other.date()) && Objects.equals(this.meanTimeToClose(), other.meanTimeToClose()) && Objects.equals(this.newFindings(), other.newFindings()) && Objects.equals(this.openFindings(), other.openFindings());
    }

    public final String toString() {
        return ToString.builder((String)"AccountFindingsMetric").add("ClosedFindings", (Object)this.closedFindings()).add("Date", (Object)this.date()).add("MeanTimeToClose", (Object)this.meanTimeToClose()).add("NewFindings", (Object)this.newFindings()).add("OpenFindings", (Object)this.openFindings()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "closedFindings": {
                return Optional.ofNullable(clazz.cast(this.closedFindings()));
            }
            case "date": {
                return Optional.ofNullable(clazz.cast(this.date()));
            }
            case "meanTimeToClose": {
                return Optional.ofNullable(clazz.cast(this.meanTimeToClose()));
            }
            case "newFindings": {
                return Optional.ofNullable(clazz.cast(this.newFindings()));
            }
            case "openFindings": {
                return Optional.ofNullable(clazz.cast(this.openFindings()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("closedFindings", CLOSED_FINDINGS_FIELD);
        map.put("date", DATE_FIELD);
        map.put("meanTimeToClose", MEAN_TIME_TO_CLOSE_FIELD);
        map.put("newFindings", NEW_FINDINGS_FIELD);
        map.put("openFindings", OPEN_FINDINGS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<AccountFindingsMetric, T> g) {
        return obj -> g.apply((AccountFindingsMetric)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private FindingMetricsValuePerSeverity closedFindings;
        private Instant date;
        private FindingMetricsValuePerSeverity meanTimeToClose;
        private FindingMetricsValuePerSeverity newFindings;
        private FindingMetricsValuePerSeverity openFindings;

        private BuilderImpl() {
        }

        private BuilderImpl(AccountFindingsMetric model) {
            this.closedFindings(model.closedFindings);
            this.date(model.date);
            this.meanTimeToClose(model.meanTimeToClose);
            this.newFindings(model.newFindings);
            this.openFindings(model.openFindings);
        }

        public final FindingMetricsValuePerSeverity.Builder getClosedFindings() {
            return this.closedFindings != null ? this.closedFindings.toBuilder() : null;
        }

        public final void setClosedFindings(FindingMetricsValuePerSeverity.BuilderImpl closedFindings) {
            this.closedFindings = closedFindings != null ? closedFindings.build() : null;
        }

        @Override
        public final Builder closedFindings(FindingMetricsValuePerSeverity closedFindings) {
            this.closedFindings = closedFindings;
            return this;
        }

        public final Instant getDate() {
            return this.date;
        }

        public final void setDate(Instant date) {
            this.date = date;
        }

        @Override
        public final Builder date(Instant date) {
            this.date = date;
            return this;
        }

        public final FindingMetricsValuePerSeverity.Builder getMeanTimeToClose() {
            return this.meanTimeToClose != null ? this.meanTimeToClose.toBuilder() : null;
        }

        public final void setMeanTimeToClose(FindingMetricsValuePerSeverity.BuilderImpl meanTimeToClose) {
            this.meanTimeToClose = meanTimeToClose != null ? meanTimeToClose.build() : null;
        }

        @Override
        public final Builder meanTimeToClose(FindingMetricsValuePerSeverity meanTimeToClose) {
            this.meanTimeToClose = meanTimeToClose;
            return this;
        }

        public final FindingMetricsValuePerSeverity.Builder getNewFindings() {
            return this.newFindings != null ? this.newFindings.toBuilder() : null;
        }

        public final void setNewFindings(FindingMetricsValuePerSeverity.BuilderImpl newFindings) {
            this.newFindings = newFindings != null ? newFindings.build() : null;
        }

        @Override
        public final Builder newFindings(FindingMetricsValuePerSeverity newFindings) {
            this.newFindings = newFindings;
            return this;
        }

        public final FindingMetricsValuePerSeverity.Builder getOpenFindings() {
            return this.openFindings != null ? this.openFindings.toBuilder() : null;
        }

        public final void setOpenFindings(FindingMetricsValuePerSeverity.BuilderImpl openFindings) {
            this.openFindings = openFindings != null ? openFindings.build() : null;
        }

        @Override
        public final Builder openFindings(FindingMetricsValuePerSeverity openFindings) {
            this.openFindings = openFindings;
            return this;
        }

        public AccountFindingsMetric build() {
            return new AccountFindingsMetric(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, AccountFindingsMetric> {
        public Builder closedFindings(FindingMetricsValuePerSeverity var1);

        default public Builder closedFindings(Consumer<FindingMetricsValuePerSeverity.Builder> closedFindings) {
            return this.closedFindings((FindingMetricsValuePerSeverity)((FindingMetricsValuePerSeverity.Builder)FindingMetricsValuePerSeverity.builder().applyMutation(closedFindings)).build());
        }

        public Builder date(Instant var1);

        public Builder meanTimeToClose(FindingMetricsValuePerSeverity var1);

        default public Builder meanTimeToClose(Consumer<FindingMetricsValuePerSeverity.Builder> meanTimeToClose) {
            return this.meanTimeToClose((FindingMetricsValuePerSeverity)((FindingMetricsValuePerSeverity.Builder)FindingMetricsValuePerSeverity.builder().applyMutation(meanTimeToClose)).build());
        }

        public Builder newFindings(FindingMetricsValuePerSeverity var1);

        default public Builder newFindings(Consumer<FindingMetricsValuePerSeverity.Builder> newFindings) {
            return this.newFindings((FindingMetricsValuePerSeverity)((FindingMetricsValuePerSeverity.Builder)FindingMetricsValuePerSeverity.builder().applyMutation(newFindings)).build());
        }

        public Builder openFindings(FindingMetricsValuePerSeverity var1);

        default public Builder openFindings(Consumer<FindingMetricsValuePerSeverity.Builder> openFindings) {
            return this.openFindings((FindingMetricsValuePerSeverity)((FindingMetricsValuePerSeverity.Builder)FindingMetricsValuePerSeverity.builder().applyMutation(openFindings)).build());
        }
    }
}

