/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codegurusecurity.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.codegurusecurity.model.CodeGuruSecurityRequest;
import software.amazon.awssdk.services.codegurusecurity.model.FindingIdentifier;
import software.amazon.awssdk.services.codegurusecurity.model.FindingIdentifiersCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class BatchGetFindingsRequest
extends CodeGuruSecurityRequest
implements ToCopyableBuilder<Builder, BatchGetFindingsRequest> {
    private static final SdkField<List<FindingIdentifier>> FINDING_IDENTIFIERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("findingIdentifiers").getter(BatchGetFindingsRequest.getter(BatchGetFindingsRequest::findingIdentifiers)).setter(BatchGetFindingsRequest.setter(Builder::findingIdentifiers)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("findingIdentifiers").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(FindingIdentifier::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FINDING_IDENTIFIERS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = BatchGetFindingsRequest.memberNameToFieldInitializer();
    private final List<FindingIdentifier> findingIdentifiers;

    private BatchGetFindingsRequest(BuilderImpl builder) {
        super(builder);
        this.findingIdentifiers = builder.findingIdentifiers;
    }

    public final boolean hasFindingIdentifiers() {
        return this.findingIdentifiers != null && !(this.findingIdentifiers instanceof SdkAutoConstructList);
    }

    public final List<FindingIdentifier> findingIdentifiers() {
        return this.findingIdentifiers;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasFindingIdentifiers() ? this.findingIdentifiers() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BatchGetFindingsRequest)) {
            return false;
        }
        BatchGetFindingsRequest other = (BatchGetFindingsRequest)((Object)obj);
        return this.hasFindingIdentifiers() == other.hasFindingIdentifiers() && Objects.equals(this.findingIdentifiers(), other.findingIdentifiers());
    }

    public final String toString() {
        return ToString.builder((String)"BatchGetFindingsRequest").add("FindingIdentifiers", this.hasFindingIdentifiers() ? this.findingIdentifiers() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "findingIdentifiers": {
                return Optional.ofNullable(clazz.cast(this.findingIdentifiers()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<List<FindingIdentifier>>> map = new HashMap<String, SdkField<List<FindingIdentifier>>>();
        map.put("findingIdentifiers", FINDING_IDENTIFIERS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<BatchGetFindingsRequest, T> g) {
        return obj -> g.apply((BatchGetFindingsRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends CodeGuruSecurityRequest.BuilderImpl
    implements Builder {
        private List<FindingIdentifier> findingIdentifiers = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(BatchGetFindingsRequest model) {
            super(model);
            this.findingIdentifiers(model.findingIdentifiers);
        }

        public final List<FindingIdentifier.Builder> getFindingIdentifiers() {
            List<FindingIdentifier.Builder> result = FindingIdentifiersCopier.copyToBuilder(this.findingIdentifiers);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setFindingIdentifiers(Collection<FindingIdentifier.BuilderImpl> findingIdentifiers) {
            this.findingIdentifiers = FindingIdentifiersCopier.copyFromBuilder(findingIdentifiers);
        }

        @Override
        public final Builder findingIdentifiers(Collection<FindingIdentifier> findingIdentifiers) {
            this.findingIdentifiers = FindingIdentifiersCopier.copy(findingIdentifiers);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder findingIdentifiers(FindingIdentifier ... findingIdentifiers) {
            this.findingIdentifiers(Arrays.asList(findingIdentifiers));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder findingIdentifiers(Consumer<FindingIdentifier.Builder> ... findingIdentifiers) {
            this.findingIdentifiers(Stream.of(findingIdentifiers).map(c -> (FindingIdentifier)((FindingIdentifier.Builder)FindingIdentifier.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public BatchGetFindingsRequest build() {
            return new BatchGetFindingsRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends CodeGuruSecurityRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, BatchGetFindingsRequest> {
        public Builder findingIdentifiers(Collection<FindingIdentifier> var1);

        public Builder findingIdentifiers(FindingIdentifier ... var1);

        public Builder findingIdentifiers(Consumer<FindingIdentifier.Builder> ... var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

