/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codegurusecurity;

import java.util.function.Consumer;
import software.amazon.awssdk.annotations.SdkPublicApi;
import software.amazon.awssdk.annotations.ThreadSafe;
import software.amazon.awssdk.awscore.AwsClient;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.regions.ServiceMetadata;
import software.amazon.awssdk.services.codegurusecurity.CodeGuruSecurityClientBuilder;
import software.amazon.awssdk.services.codegurusecurity.CodeGuruSecurityServiceClientConfiguration;
import software.amazon.awssdk.services.codegurusecurity.DefaultCodeGuruSecurityClientBuilder;
import software.amazon.awssdk.services.codegurusecurity.model.AccessDeniedException;
import software.amazon.awssdk.services.codegurusecurity.model.BatchGetFindingsRequest;
import software.amazon.awssdk.services.codegurusecurity.model.BatchGetFindingsResponse;
import software.amazon.awssdk.services.codegurusecurity.model.CodeGuruSecurityException;
import software.amazon.awssdk.services.codegurusecurity.model.ConflictException;
import software.amazon.awssdk.services.codegurusecurity.model.CreateScanRequest;
import software.amazon.awssdk.services.codegurusecurity.model.CreateScanResponse;
import software.amazon.awssdk.services.codegurusecurity.model.CreateUploadUrlRequest;
import software.amazon.awssdk.services.codegurusecurity.model.CreateUploadUrlResponse;
import software.amazon.awssdk.services.codegurusecurity.model.GetAccountConfigurationRequest;
import software.amazon.awssdk.services.codegurusecurity.model.GetAccountConfigurationResponse;
import software.amazon.awssdk.services.codegurusecurity.model.GetFindingsRequest;
import software.amazon.awssdk.services.codegurusecurity.model.GetFindingsResponse;
import software.amazon.awssdk.services.codegurusecurity.model.GetMetricsSummaryRequest;
import software.amazon.awssdk.services.codegurusecurity.model.GetMetricsSummaryResponse;
import software.amazon.awssdk.services.codegurusecurity.model.GetScanRequest;
import software.amazon.awssdk.services.codegurusecurity.model.GetScanResponse;
import software.amazon.awssdk.services.codegurusecurity.model.InternalServerException;
import software.amazon.awssdk.services.codegurusecurity.model.ListFindingsMetricsRequest;
import software.amazon.awssdk.services.codegurusecurity.model.ListFindingsMetricsResponse;
import software.amazon.awssdk.services.codegurusecurity.model.ListScansRequest;
import software.amazon.awssdk.services.codegurusecurity.model.ListScansResponse;
import software.amazon.awssdk.services.codegurusecurity.model.ListTagsForResourceRequest;
import software.amazon.awssdk.services.codegurusecurity.model.ListTagsForResourceResponse;
import software.amazon.awssdk.services.codegurusecurity.model.ResourceNotFoundException;
import software.amazon.awssdk.services.codegurusecurity.model.TagResourceRequest;
import software.amazon.awssdk.services.codegurusecurity.model.TagResourceResponse;
import software.amazon.awssdk.services.codegurusecurity.model.ThrottlingException;
import software.amazon.awssdk.services.codegurusecurity.model.UntagResourceRequest;
import software.amazon.awssdk.services.codegurusecurity.model.UntagResourceResponse;
import software.amazon.awssdk.services.codegurusecurity.model.UpdateAccountConfigurationRequest;
import software.amazon.awssdk.services.codegurusecurity.model.UpdateAccountConfigurationResponse;
import software.amazon.awssdk.services.codegurusecurity.model.ValidationException;
import software.amazon.awssdk.services.codegurusecurity.paginators.GetFindingsIterable;
import software.amazon.awssdk.services.codegurusecurity.paginators.ListFindingsMetricsIterable;
import software.amazon.awssdk.services.codegurusecurity.paginators.ListScansIterable;

@SdkPublicApi
@ThreadSafe
public interface CodeGuruSecurityClient
extends AwsClient {
    public static final String SERVICE_NAME = "codeguru-security";
    public static final String SERVICE_METADATA_ID = "codeguru-security";

    default public BatchGetFindingsResponse batchGetFindings(BatchGetFindingsRequest batchGetFindingsRequest) throws InternalServerException, ThrottlingException, ValidationException, AccessDeniedException, AwsServiceException, SdkClientException, CodeGuruSecurityException {
        throw new UnsupportedOperationException();
    }

    default public BatchGetFindingsResponse batchGetFindings(Consumer<BatchGetFindingsRequest.Builder> batchGetFindingsRequest) throws InternalServerException, ThrottlingException, ValidationException, AccessDeniedException, AwsServiceException, SdkClientException, CodeGuruSecurityException {
        return this.batchGetFindings((BatchGetFindingsRequest)((Object)((BatchGetFindingsRequest.Builder)BatchGetFindingsRequest.builder().applyMutation(batchGetFindingsRequest)).build()));
    }

    default public CreateScanResponse createScan(CreateScanRequest createScanRequest) throws InternalServerException, ConflictException, ResourceNotFoundException, ThrottlingException, ValidationException, AccessDeniedException, AwsServiceException, SdkClientException, CodeGuruSecurityException {
        throw new UnsupportedOperationException();
    }

    default public CreateScanResponse createScan(Consumer<CreateScanRequest.Builder> createScanRequest) throws InternalServerException, ConflictException, ResourceNotFoundException, ThrottlingException, ValidationException, AccessDeniedException, AwsServiceException, SdkClientException, CodeGuruSecurityException {
        return this.createScan((CreateScanRequest)((Object)((CreateScanRequest.Builder)CreateScanRequest.builder().applyMutation(createScanRequest)).build()));
    }

    default public CreateUploadUrlResponse createUploadUrl(CreateUploadUrlRequest createUploadUrlRequest) throws InternalServerException, ThrottlingException, ValidationException, AccessDeniedException, AwsServiceException, SdkClientException, CodeGuruSecurityException {
        throw new UnsupportedOperationException();
    }

    default public CreateUploadUrlResponse createUploadUrl(Consumer<CreateUploadUrlRequest.Builder> createUploadUrlRequest) throws InternalServerException, ThrottlingException, ValidationException, AccessDeniedException, AwsServiceException, SdkClientException, CodeGuruSecurityException {
        return this.createUploadUrl((CreateUploadUrlRequest)((Object)((CreateUploadUrlRequest.Builder)CreateUploadUrlRequest.builder().applyMutation(createUploadUrlRequest)).build()));
    }

    default public GetAccountConfigurationResponse getAccountConfiguration(GetAccountConfigurationRequest getAccountConfigurationRequest) throws InternalServerException, ThrottlingException, ValidationException, AccessDeniedException, AwsServiceException, SdkClientException, CodeGuruSecurityException {
        throw new UnsupportedOperationException();
    }

    default public GetAccountConfigurationResponse getAccountConfiguration(Consumer<GetAccountConfigurationRequest.Builder> getAccountConfigurationRequest) throws InternalServerException, ThrottlingException, ValidationException, AccessDeniedException, AwsServiceException, SdkClientException, CodeGuruSecurityException {
        return this.getAccountConfiguration((GetAccountConfigurationRequest)((Object)((GetAccountConfigurationRequest.Builder)GetAccountConfigurationRequest.builder().applyMutation(getAccountConfigurationRequest)).build()));
    }

    default public GetFindingsResponse getFindings(GetFindingsRequest getFindingsRequest) throws InternalServerException, ConflictException, ResourceNotFoundException, ThrottlingException, ValidationException, AccessDeniedException, AwsServiceException, SdkClientException, CodeGuruSecurityException {
        throw new UnsupportedOperationException();
    }

    default public GetFindingsResponse getFindings(Consumer<GetFindingsRequest.Builder> getFindingsRequest) throws InternalServerException, ConflictException, ResourceNotFoundException, ThrottlingException, ValidationException, AccessDeniedException, AwsServiceException, SdkClientException, CodeGuruSecurityException {
        return this.getFindings((GetFindingsRequest)((Object)((GetFindingsRequest.Builder)GetFindingsRequest.builder().applyMutation(getFindingsRequest)).build()));
    }

    default public GetFindingsIterable getFindingsPaginator(GetFindingsRequest getFindingsRequest) throws InternalServerException, ConflictException, ResourceNotFoundException, ThrottlingException, ValidationException, AccessDeniedException, AwsServiceException, SdkClientException, CodeGuruSecurityException {
        return new GetFindingsIterable(this, getFindingsRequest);
    }

    default public GetFindingsIterable getFindingsPaginator(Consumer<GetFindingsRequest.Builder> getFindingsRequest) throws InternalServerException, ConflictException, ResourceNotFoundException, ThrottlingException, ValidationException, AccessDeniedException, AwsServiceException, SdkClientException, CodeGuruSecurityException {
        return this.getFindingsPaginator((GetFindingsRequest)((Object)((GetFindingsRequest.Builder)GetFindingsRequest.builder().applyMutation(getFindingsRequest)).build()));
    }

    default public GetMetricsSummaryResponse getMetricsSummary(GetMetricsSummaryRequest getMetricsSummaryRequest) throws InternalServerException, ThrottlingException, ValidationException, AccessDeniedException, AwsServiceException, SdkClientException, CodeGuruSecurityException {
        throw new UnsupportedOperationException();
    }

    default public GetMetricsSummaryResponse getMetricsSummary(Consumer<GetMetricsSummaryRequest.Builder> getMetricsSummaryRequest) throws InternalServerException, ThrottlingException, ValidationException, AccessDeniedException, AwsServiceException, SdkClientException, CodeGuruSecurityException {
        return this.getMetricsSummary((GetMetricsSummaryRequest)((Object)((GetMetricsSummaryRequest.Builder)GetMetricsSummaryRequest.builder().applyMutation(getMetricsSummaryRequest)).build()));
    }

    default public GetScanResponse getScan(GetScanRequest getScanRequest) throws InternalServerException, ResourceNotFoundException, ThrottlingException, ValidationException, AccessDeniedException, AwsServiceException, SdkClientException, CodeGuruSecurityException {
        throw new UnsupportedOperationException();
    }

    default public GetScanResponse getScan(Consumer<GetScanRequest.Builder> getScanRequest) throws InternalServerException, ResourceNotFoundException, ThrottlingException, ValidationException, AccessDeniedException, AwsServiceException, SdkClientException, CodeGuruSecurityException {
        return this.getScan((GetScanRequest)((Object)((GetScanRequest.Builder)GetScanRequest.builder().applyMutation(getScanRequest)).build()));
    }

    default public ListFindingsMetricsResponse listFindingsMetrics(ListFindingsMetricsRequest listFindingsMetricsRequest) throws InternalServerException, ThrottlingException, ValidationException, AccessDeniedException, AwsServiceException, SdkClientException, CodeGuruSecurityException {
        throw new UnsupportedOperationException();
    }

    default public ListFindingsMetricsResponse listFindingsMetrics(Consumer<ListFindingsMetricsRequest.Builder> listFindingsMetricsRequest) throws InternalServerException, ThrottlingException, ValidationException, AccessDeniedException, AwsServiceException, SdkClientException, CodeGuruSecurityException {
        return this.listFindingsMetrics((ListFindingsMetricsRequest)((Object)((ListFindingsMetricsRequest.Builder)ListFindingsMetricsRequest.builder().applyMutation(listFindingsMetricsRequest)).build()));
    }

    default public ListFindingsMetricsIterable listFindingsMetricsPaginator(ListFindingsMetricsRequest listFindingsMetricsRequest) throws InternalServerException, ThrottlingException, ValidationException, AccessDeniedException, AwsServiceException, SdkClientException, CodeGuruSecurityException {
        return new ListFindingsMetricsIterable(this, listFindingsMetricsRequest);
    }

    default public ListFindingsMetricsIterable listFindingsMetricsPaginator(Consumer<ListFindingsMetricsRequest.Builder> listFindingsMetricsRequest) throws InternalServerException, ThrottlingException, ValidationException, AccessDeniedException, AwsServiceException, SdkClientException, CodeGuruSecurityException {
        return this.listFindingsMetricsPaginator((ListFindingsMetricsRequest)((Object)((ListFindingsMetricsRequest.Builder)ListFindingsMetricsRequest.builder().applyMutation(listFindingsMetricsRequest)).build()));
    }

    default public ListScansResponse listScans(ListScansRequest listScansRequest) throws InternalServerException, ThrottlingException, ValidationException, AccessDeniedException, AwsServiceException, SdkClientException, CodeGuruSecurityException {
        throw new UnsupportedOperationException();
    }

    default public ListScansResponse listScans(Consumer<ListScansRequest.Builder> listScansRequest) throws InternalServerException, ThrottlingException, ValidationException, AccessDeniedException, AwsServiceException, SdkClientException, CodeGuruSecurityException {
        return this.listScans((ListScansRequest)((Object)((ListScansRequest.Builder)ListScansRequest.builder().applyMutation(listScansRequest)).build()));
    }

    default public ListScansIterable listScansPaginator(ListScansRequest listScansRequest) throws InternalServerException, ThrottlingException, ValidationException, AccessDeniedException, AwsServiceException, SdkClientException, CodeGuruSecurityException {
        return new ListScansIterable(this, listScansRequest);
    }

    default public ListScansIterable listScansPaginator(Consumer<ListScansRequest.Builder> listScansRequest) throws InternalServerException, ThrottlingException, ValidationException, AccessDeniedException, AwsServiceException, SdkClientException, CodeGuruSecurityException {
        return this.listScansPaginator((ListScansRequest)((Object)((ListScansRequest.Builder)ListScansRequest.builder().applyMutation(listScansRequest)).build()));
    }

    default public ListTagsForResourceResponse listTagsForResource(ListTagsForResourceRequest listTagsForResourceRequest) throws InternalServerException, ConflictException, ResourceNotFoundException, ThrottlingException, ValidationException, AccessDeniedException, AwsServiceException, SdkClientException, CodeGuruSecurityException {
        throw new UnsupportedOperationException();
    }

    default public ListTagsForResourceResponse listTagsForResource(Consumer<ListTagsForResourceRequest.Builder> listTagsForResourceRequest) throws InternalServerException, ConflictException, ResourceNotFoundException, ThrottlingException, ValidationException, AccessDeniedException, AwsServiceException, SdkClientException, CodeGuruSecurityException {
        return this.listTagsForResource((ListTagsForResourceRequest)((Object)((ListTagsForResourceRequest.Builder)ListTagsForResourceRequest.builder().applyMutation(listTagsForResourceRequest)).build()));
    }

    default public TagResourceResponse tagResource(TagResourceRequest tagResourceRequest) throws InternalServerException, ConflictException, ResourceNotFoundException, ThrottlingException, ValidationException, AccessDeniedException, AwsServiceException, SdkClientException, CodeGuruSecurityException {
        throw new UnsupportedOperationException();
    }

    default public TagResourceResponse tagResource(Consumer<TagResourceRequest.Builder> tagResourceRequest) throws InternalServerException, ConflictException, ResourceNotFoundException, ThrottlingException, ValidationException, AccessDeniedException, AwsServiceException, SdkClientException, CodeGuruSecurityException {
        return this.tagResource((TagResourceRequest)((Object)((TagResourceRequest.Builder)TagResourceRequest.builder().applyMutation(tagResourceRequest)).build()));
    }

    default public UntagResourceResponse untagResource(UntagResourceRequest untagResourceRequest) throws InternalServerException, ConflictException, ResourceNotFoundException, ThrottlingException, ValidationException, AccessDeniedException, AwsServiceException, SdkClientException, CodeGuruSecurityException {
        throw new UnsupportedOperationException();
    }

    default public UntagResourceResponse untagResource(Consumer<UntagResourceRequest.Builder> untagResourceRequest) throws InternalServerException, ConflictException, ResourceNotFoundException, ThrottlingException, ValidationException, AccessDeniedException, AwsServiceException, SdkClientException, CodeGuruSecurityException {
        return this.untagResource((UntagResourceRequest)((Object)((UntagResourceRequest.Builder)UntagResourceRequest.builder().applyMutation(untagResourceRequest)).build()));
    }

    default public UpdateAccountConfigurationResponse updateAccountConfiguration(UpdateAccountConfigurationRequest updateAccountConfigurationRequest) throws InternalServerException, ResourceNotFoundException, ThrottlingException, ValidationException, AccessDeniedException, AwsServiceException, SdkClientException, CodeGuruSecurityException {
        throw new UnsupportedOperationException();
    }

    default public UpdateAccountConfigurationResponse updateAccountConfiguration(Consumer<UpdateAccountConfigurationRequest.Builder> updateAccountConfigurationRequest) throws InternalServerException, ResourceNotFoundException, ThrottlingException, ValidationException, AccessDeniedException, AwsServiceException, SdkClientException, CodeGuruSecurityException {
        return this.updateAccountConfiguration((UpdateAccountConfigurationRequest)((Object)((UpdateAccountConfigurationRequest.Builder)UpdateAccountConfigurationRequest.builder().applyMutation(updateAccountConfigurationRequest)).build()));
    }

    public static CodeGuruSecurityClient create() {
        return (CodeGuruSecurityClient)CodeGuruSecurityClient.builder().build();
    }

    public static CodeGuruSecurityClientBuilder builder() {
        return new DefaultCodeGuruSecurityClientBuilder();
    }

    public static ServiceMetadata serviceMetadata() {
        return ServiceMetadata.of((String)"codeguru-security");
    }

    default public CodeGuruSecurityServiceClientConfiguration serviceClientConfiguration() {
        throw new UnsupportedOperationException();
    }
}

