/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codegurusecurity.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.codegurusecurity.model.CodeGuruSecurityResponse;
import software.amazon.awssdk.services.codegurusecurity.model.ScanSummariesCopier;
import software.amazon.awssdk.services.codegurusecurity.model.ScanSummary;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListScansResponse
extends CodeGuruSecurityResponse
implements ToCopyableBuilder<Builder, ListScansResponse> {
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("nextToken").getter(ListScansResponse.getter(ListScansResponse::nextToken)).setter(ListScansResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()}).build();
    private static final SdkField<List<ScanSummary>> SUMMARIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("summaries").getter(ListScansResponse.getter(ListScansResponse::summaries)).setter(ListScansResponse.setter(Builder::summaries)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("summaries").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ScanSummary::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NEXT_TOKEN_FIELD, SUMMARIES_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ListScansResponse.memberNameToFieldInitializer();
    private final String nextToken;
    private final List<ScanSummary> summaries;

    private ListScansResponse(BuilderImpl builder) {
        super(builder);
        this.nextToken = builder.nextToken;
        this.summaries = builder.summaries;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public final boolean hasSummaries() {
        return this.summaries != null && !(this.summaries instanceof SdkAutoConstructList);
    }

    public final List<ScanSummary> summaries() {
        return this.summaries;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSummaries() ? this.summaries() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListScansResponse)) {
            return false;
        }
        ListScansResponse other = (ListScansResponse)((Object)obj);
        return Objects.equals(this.nextToken(), other.nextToken()) && this.hasSummaries() == other.hasSummaries() && Objects.equals(this.summaries(), other.summaries());
    }

    public final String toString() {
        return ToString.builder((String)"ListScansResponse").add("NextToken", (Object)this.nextToken()).add("Summaries", this.hasSummaries() ? this.summaries() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "summaries": {
                return Optional.ofNullable(clazz.cast(this.summaries()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("nextToken", NEXT_TOKEN_FIELD);
        map.put("summaries", SUMMARIES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListScansResponse, T> g) {
        return obj -> g.apply((ListScansResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends CodeGuruSecurityResponse.BuilderImpl
    implements Builder {
        private String nextToken;
        private List<ScanSummary> summaries = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ListScansResponse model) {
            super(model);
            this.nextToken(model.nextToken);
            this.summaries(model.summaries);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final List<ScanSummary.Builder> getSummaries() {
            List<ScanSummary.Builder> result = ScanSummariesCopier.copyToBuilder(this.summaries);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setSummaries(Collection<ScanSummary.BuilderImpl> summaries) {
            this.summaries = ScanSummariesCopier.copyFromBuilder(summaries);
        }

        @Override
        public final Builder summaries(Collection<ScanSummary> summaries) {
            this.summaries = ScanSummariesCopier.copy(summaries);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder summaries(ScanSummary ... summaries) {
            this.summaries(Arrays.asList(summaries));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder summaries(Consumer<ScanSummary.Builder> ... summaries) {
            this.summaries(Stream.of(summaries).map(c -> (ScanSummary)((ScanSummary.Builder)ScanSummary.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public ListScansResponse build() {
            return new ListScansResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends CodeGuruSecurityResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListScansResponse> {
        public Builder nextToken(String var1);

        public Builder summaries(Collection<ScanSummary> var1);

        public Builder summaries(ScanSummary ... var1);

        public Builder summaries(Consumer<ScanSummary.Builder> ... var1);
    }
}

