/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codegurusecurity.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.codegurusecurity.CodeGuruSecurityAsyncClient;
import software.amazon.awssdk.services.codegurusecurity.internal.UserAgentUtils;
import software.amazon.awssdk.services.codegurusecurity.model.Finding;
import software.amazon.awssdk.services.codegurusecurity.model.GetFindingsRequest;
import software.amazon.awssdk.services.codegurusecurity.model.GetFindingsResponse;

public class GetFindingsPublisher
implements SdkPublisher<GetFindingsResponse> {
    private final CodeGuruSecurityAsyncClient client;
    private final GetFindingsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public GetFindingsPublisher(CodeGuruSecurityAsyncClient client, GetFindingsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private GetFindingsPublisher(CodeGuruSecurityAsyncClient client, GetFindingsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new GetFindingsResponseFetcher();
    }

    public void subscribe(Subscriber<? super GetFindingsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<Finding> findings() {
        Function<GetFindingsResponse, Iterator> getIterator = response -> {
            if (response != null && response.findings() != null) {
                return response.findings().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new GetFindingsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class GetFindingsResponseFetcher
    implements AsyncPageFetcher<GetFindingsResponse> {
        private GetFindingsResponseFetcher() {
        }

        public boolean hasNextPage(GetFindingsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<GetFindingsResponse> nextPage(GetFindingsResponse previousPage) {
            if (previousPage == null) {
                return GetFindingsPublisher.this.client.getFindings(GetFindingsPublisher.this.firstRequest);
            }
            return GetFindingsPublisher.this.client.getFindings((GetFindingsRequest)((Object)GetFindingsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

