/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codegurureviewer.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.codegurureviewer.model.ProviderType;
import software.amazon.awssdk.services.codegurureviewer.model.RepositoryAssociationState;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class RepositoryAssociationSummary
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, RepositoryAssociationSummary> {
    private static final SdkField<String> ASSOCIATION_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AssociationArn").getter(RepositoryAssociationSummary.getter(RepositoryAssociationSummary::associationArn)).setter(RepositoryAssociationSummary.setter(Builder::associationArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AssociationArn").build()}).build();
    private static final SdkField<String> CONNECTION_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ConnectionArn").getter(RepositoryAssociationSummary.getter(RepositoryAssociationSummary::connectionArn)).setter(RepositoryAssociationSummary.setter(Builder::connectionArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConnectionArn").build()}).build();
    private static final SdkField<Instant> LAST_UPDATED_TIME_STAMP_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("LastUpdatedTimeStamp").getter(RepositoryAssociationSummary.getter(RepositoryAssociationSummary::lastUpdatedTimeStamp)).setter(RepositoryAssociationSummary.setter(Builder::lastUpdatedTimeStamp)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastUpdatedTimeStamp").build()}).build();
    private static final SdkField<String> ASSOCIATION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AssociationId").getter(RepositoryAssociationSummary.getter(RepositoryAssociationSummary::associationId)).setter(RepositoryAssociationSummary.setter(Builder::associationId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AssociationId").build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Name").getter(RepositoryAssociationSummary.getter(RepositoryAssociationSummary::name)).setter(RepositoryAssociationSummary.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()}).build();
    private static final SdkField<String> OWNER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Owner").getter(RepositoryAssociationSummary.getter(RepositoryAssociationSummary::owner)).setter(RepositoryAssociationSummary.setter(Builder::owner)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Owner").build()}).build();
    private static final SdkField<String> PROVIDER_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ProviderType").getter(RepositoryAssociationSummary.getter(RepositoryAssociationSummary::providerTypeAsString)).setter(RepositoryAssociationSummary.setter(Builder::providerType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProviderType").build()}).build();
    private static final SdkField<String> STATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("State").getter(RepositoryAssociationSummary.getter(RepositoryAssociationSummary::stateAsString)).setter(RepositoryAssociationSummary.setter(Builder::state)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("State").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ASSOCIATION_ARN_FIELD, CONNECTION_ARN_FIELD, LAST_UPDATED_TIME_STAMP_FIELD, ASSOCIATION_ID_FIELD, NAME_FIELD, OWNER_FIELD, PROVIDER_TYPE_FIELD, STATE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = RepositoryAssociationSummary.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String associationArn;
    private final String connectionArn;
    private final Instant lastUpdatedTimeStamp;
    private final String associationId;
    private final String name;
    private final String owner;
    private final String providerType;
    private final String state;

    private RepositoryAssociationSummary(BuilderImpl builder) {
        this.associationArn = builder.associationArn;
        this.connectionArn = builder.connectionArn;
        this.lastUpdatedTimeStamp = builder.lastUpdatedTimeStamp;
        this.associationId = builder.associationId;
        this.name = builder.name;
        this.owner = builder.owner;
        this.providerType = builder.providerType;
        this.state = builder.state;
    }

    public final String associationArn() {
        return this.associationArn;
    }

    public final String connectionArn() {
        return this.connectionArn;
    }

    public final Instant lastUpdatedTimeStamp() {
        return this.lastUpdatedTimeStamp;
    }

    public final String associationId() {
        return this.associationId;
    }

    public final String name() {
        return this.name;
    }

    public final String owner() {
        return this.owner;
    }

    public final ProviderType providerType() {
        return ProviderType.fromValue(this.providerType);
    }

    public final String providerTypeAsString() {
        return this.providerType;
    }

    public final RepositoryAssociationState state() {
        return RepositoryAssociationState.fromValue(this.state);
    }

    public final String stateAsString() {
        return this.state;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.associationArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.connectionArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastUpdatedTimeStamp());
        hashCode = 31 * hashCode + Objects.hashCode(this.associationId());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.owner());
        hashCode = 31 * hashCode + Objects.hashCode(this.providerTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.stateAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RepositoryAssociationSummary)) {
            return false;
        }
        RepositoryAssociationSummary other = (RepositoryAssociationSummary)obj;
        return Objects.equals(this.associationArn(), other.associationArn()) && Objects.equals(this.connectionArn(), other.connectionArn()) && Objects.equals(this.lastUpdatedTimeStamp(), other.lastUpdatedTimeStamp()) && Objects.equals(this.associationId(), other.associationId()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.owner(), other.owner()) && Objects.equals(this.providerTypeAsString(), other.providerTypeAsString()) && Objects.equals(this.stateAsString(), other.stateAsString());
    }

    public final String toString() {
        return ToString.builder((String)"RepositoryAssociationSummary").add("AssociationArn", (Object)this.associationArn()).add("ConnectionArn", (Object)this.connectionArn()).add("LastUpdatedTimeStamp", (Object)this.lastUpdatedTimeStamp()).add("AssociationId", (Object)this.associationId()).add("Name", (Object)this.name()).add("Owner", (Object)this.owner()).add("ProviderType", (Object)this.providerTypeAsString()).add("State", (Object)this.stateAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AssociationArn": {
                return Optional.ofNullable(clazz.cast(this.associationArn()));
            }
            case "ConnectionArn": {
                return Optional.ofNullable(clazz.cast(this.connectionArn()));
            }
            case "LastUpdatedTimeStamp": {
                return Optional.ofNullable(clazz.cast(this.lastUpdatedTimeStamp()));
            }
            case "AssociationId": {
                return Optional.ofNullable(clazz.cast(this.associationId()));
            }
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "Owner": {
                return Optional.ofNullable(clazz.cast(this.owner()));
            }
            case "ProviderType": {
                return Optional.ofNullable(clazz.cast(this.providerTypeAsString()));
            }
            case "State": {
                return Optional.ofNullable(clazz.cast(this.stateAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("AssociationArn", ASSOCIATION_ARN_FIELD);
        map.put("ConnectionArn", CONNECTION_ARN_FIELD);
        map.put("LastUpdatedTimeStamp", LAST_UPDATED_TIME_STAMP_FIELD);
        map.put("AssociationId", ASSOCIATION_ID_FIELD);
        map.put("Name", NAME_FIELD);
        map.put("Owner", OWNER_FIELD);
        map.put("ProviderType", PROVIDER_TYPE_FIELD);
        map.put("State", STATE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<RepositoryAssociationSummary, T> g) {
        return obj -> g.apply((RepositoryAssociationSummary)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String associationArn;
        private String connectionArn;
        private Instant lastUpdatedTimeStamp;
        private String associationId;
        private String name;
        private String owner;
        private String providerType;
        private String state;

        private BuilderImpl() {
        }

        private BuilderImpl(RepositoryAssociationSummary model) {
            this.associationArn(model.associationArn);
            this.connectionArn(model.connectionArn);
            this.lastUpdatedTimeStamp(model.lastUpdatedTimeStamp);
            this.associationId(model.associationId);
            this.name(model.name);
            this.owner(model.owner);
            this.providerType(model.providerType);
            this.state(model.state);
        }

        public final String getAssociationArn() {
            return this.associationArn;
        }

        public final void setAssociationArn(String associationArn) {
            this.associationArn = associationArn;
        }

        @Override
        public final Builder associationArn(String associationArn) {
            this.associationArn = associationArn;
            return this;
        }

        public final String getConnectionArn() {
            return this.connectionArn;
        }

        public final void setConnectionArn(String connectionArn) {
            this.connectionArn = connectionArn;
        }

        @Override
        public final Builder connectionArn(String connectionArn) {
            this.connectionArn = connectionArn;
            return this;
        }

        public final Instant getLastUpdatedTimeStamp() {
            return this.lastUpdatedTimeStamp;
        }

        public final void setLastUpdatedTimeStamp(Instant lastUpdatedTimeStamp) {
            this.lastUpdatedTimeStamp = lastUpdatedTimeStamp;
        }

        @Override
        public final Builder lastUpdatedTimeStamp(Instant lastUpdatedTimeStamp) {
            this.lastUpdatedTimeStamp = lastUpdatedTimeStamp;
            return this;
        }

        public final String getAssociationId() {
            return this.associationId;
        }

        public final void setAssociationId(String associationId) {
            this.associationId = associationId;
        }

        @Override
        public final Builder associationId(String associationId) {
            this.associationId = associationId;
            return this;
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getOwner() {
            return this.owner;
        }

        public final void setOwner(String owner) {
            this.owner = owner;
        }

        @Override
        public final Builder owner(String owner) {
            this.owner = owner;
            return this;
        }

        public final String getProviderType() {
            return this.providerType;
        }

        public final void setProviderType(String providerType) {
            this.providerType = providerType;
        }

        @Override
        public final Builder providerType(String providerType) {
            this.providerType = providerType;
            return this;
        }

        @Override
        public final Builder providerType(ProviderType providerType) {
            this.providerType(providerType == null ? null : providerType.toString());
            return this;
        }

        public final String getState() {
            return this.state;
        }

        public final void setState(String state) {
            this.state = state;
        }

        @Override
        public final Builder state(String state) {
            this.state = state;
            return this;
        }

        @Override
        public final Builder state(RepositoryAssociationState state) {
            this.state(state == null ? null : state.toString());
            return this;
        }

        public RepositoryAssociationSummary build() {
            return new RepositoryAssociationSummary(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, RepositoryAssociationSummary> {
        public Builder associationArn(String var1);

        public Builder connectionArn(String var1);

        public Builder lastUpdatedTimeStamp(Instant var1);

        public Builder associationId(String var1);

        public Builder name(String var1);

        public Builder owner(String var1);

        public Builder providerType(String var1);

        public Builder providerType(ProviderType var1);

        public Builder state(String var1);

        public Builder state(RepositoryAssociationState var1);
    }
}

