/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codegurureviewer.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.codegurureviewer.model.CodeGuruReviewerRequest;
import software.amazon.awssdk.services.codegurureviewer.model.Reaction;
import software.amazon.awssdk.services.codegurureviewer.model.ReactionsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class PutRecommendationFeedbackRequest
extends CodeGuruReviewerRequest
implements ToCopyableBuilder<Builder, PutRecommendationFeedbackRequest> {
    private static final SdkField<String> CODE_REVIEW_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("CodeReviewArn").getter(PutRecommendationFeedbackRequest.getter(PutRecommendationFeedbackRequest::codeReviewArn)).setter(PutRecommendationFeedbackRequest.setter(Builder::codeReviewArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CodeReviewArn").build()}).build();
    private static final SdkField<String> RECOMMENDATION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RecommendationId").getter(PutRecommendationFeedbackRequest.getter(PutRecommendationFeedbackRequest::recommendationId)).setter(PutRecommendationFeedbackRequest.setter(Builder::recommendationId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RecommendationId").build()}).build();
    private static final SdkField<List<String>> REACTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Reactions").getter(PutRecommendationFeedbackRequest.getter(PutRecommendationFeedbackRequest::reactionsAsStrings)).setter(PutRecommendationFeedbackRequest.setter(Builder::reactionsWithStrings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Reactions").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CODE_REVIEW_ARN_FIELD, RECOMMENDATION_ID_FIELD, REACTIONS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("CodeReviewArn", CODE_REVIEW_ARN_FIELD);
            this.put("RecommendationId", RECOMMENDATION_ID_FIELD);
            this.put("Reactions", REACTIONS_FIELD);
        }
    });
    private final String codeReviewArn;
    private final String recommendationId;
    private final List<String> reactions;

    private PutRecommendationFeedbackRequest(BuilderImpl builder) {
        super(builder);
        this.codeReviewArn = builder.codeReviewArn;
        this.recommendationId = builder.recommendationId;
        this.reactions = builder.reactions;
    }

    public final String codeReviewArn() {
        return this.codeReviewArn;
    }

    public final String recommendationId() {
        return this.recommendationId;
    }

    public final List<Reaction> reactions() {
        return ReactionsCopier.copyStringToEnum(this.reactions);
    }

    public final boolean hasReactions() {
        return this.reactions != null && !(this.reactions instanceof SdkAutoConstructList);
    }

    public final List<String> reactionsAsStrings() {
        return this.reactions;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.codeReviewArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.recommendationId());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasReactions() ? this.reactionsAsStrings() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PutRecommendationFeedbackRequest)) {
            return false;
        }
        PutRecommendationFeedbackRequest other = (PutRecommendationFeedbackRequest)((Object)obj);
        return Objects.equals(this.codeReviewArn(), other.codeReviewArn()) && Objects.equals(this.recommendationId(), other.recommendationId()) && this.hasReactions() == other.hasReactions() && Objects.equals(this.reactionsAsStrings(), other.reactionsAsStrings());
    }

    public final String toString() {
        return ToString.builder((String)"PutRecommendationFeedbackRequest").add("CodeReviewArn", (Object)this.codeReviewArn()).add("RecommendationId", (Object)this.recommendationId()).add("Reactions", this.hasReactions() ? this.reactionsAsStrings() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "CodeReviewArn": {
                return Optional.ofNullable(clazz.cast(this.codeReviewArn()));
            }
            case "RecommendationId": {
                return Optional.ofNullable(clazz.cast(this.recommendationId()));
            }
            case "Reactions": {
                return Optional.ofNullable(clazz.cast(this.reactionsAsStrings()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<PutRecommendationFeedbackRequest, T> g) {
        return obj -> g.apply((PutRecommendationFeedbackRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends CodeGuruReviewerRequest.BuilderImpl
    implements Builder {
        private String codeReviewArn;
        private String recommendationId;
        private List<String> reactions = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(PutRecommendationFeedbackRequest model) {
            super(model);
            this.codeReviewArn(model.codeReviewArn);
            this.recommendationId(model.recommendationId);
            this.reactionsWithStrings(model.reactions);
        }

        public final String getCodeReviewArn() {
            return this.codeReviewArn;
        }

        public final void setCodeReviewArn(String codeReviewArn) {
            this.codeReviewArn = codeReviewArn;
        }

        @Override
        public final Builder codeReviewArn(String codeReviewArn) {
            this.codeReviewArn = codeReviewArn;
            return this;
        }

        public final String getRecommendationId() {
            return this.recommendationId;
        }

        public final void setRecommendationId(String recommendationId) {
            this.recommendationId = recommendationId;
        }

        @Override
        public final Builder recommendationId(String recommendationId) {
            this.recommendationId = recommendationId;
            return this;
        }

        public final Collection<String> getReactions() {
            if (this.reactions instanceof SdkAutoConstructList) {
                return null;
            }
            return this.reactions;
        }

        public final void setReactions(Collection<String> reactions) {
            this.reactions = ReactionsCopier.copy(reactions);
        }

        @Override
        public final Builder reactionsWithStrings(Collection<String> reactions) {
            this.reactions = ReactionsCopier.copy(reactions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder reactionsWithStrings(String ... reactions) {
            this.reactionsWithStrings(Arrays.asList(reactions));
            return this;
        }

        @Override
        public final Builder reactions(Collection<Reaction> reactions) {
            this.reactions = ReactionsCopier.copyEnumToString(reactions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder reactions(Reaction ... reactions) {
            this.reactions(Arrays.asList(reactions));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public PutRecommendationFeedbackRequest build() {
            return new PutRecommendationFeedbackRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends CodeGuruReviewerRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, PutRecommendationFeedbackRequest> {
        public Builder codeReviewArn(String var1);

        public Builder recommendationId(String var1);

        public Builder reactionsWithStrings(Collection<String> var1);

        public Builder reactionsWithStrings(String ... var1);

        public Builder reactions(Collection<Reaction> var1);

        public Builder reactions(Reaction ... var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

