/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codegurureviewer.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.codegurureviewer.model.CodeGuruReviewerRequest;
import software.amazon.awssdk.services.codegurureviewer.model.NamesCopier;
import software.amazon.awssdk.services.codegurureviewer.model.OwnersCopier;
import software.amazon.awssdk.services.codegurureviewer.model.ProviderType;
import software.amazon.awssdk.services.codegurureviewer.model.ProviderTypesCopier;
import software.amazon.awssdk.services.codegurureviewer.model.RepositoryAssociationState;
import software.amazon.awssdk.services.codegurureviewer.model.RepositoryAssociationStatesCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListRepositoryAssociationsRequest
extends CodeGuruReviewerRequest
implements ToCopyableBuilder<Builder, ListRepositoryAssociationsRequest> {
    private static final SdkField<List<String>> PROVIDER_TYPES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ProviderTypes").getter(ListRepositoryAssociationsRequest.getter(ListRepositoryAssociationsRequest::providerTypesAsStrings)).setter(ListRepositoryAssociationsRequest.setter(Builder::providerTypesWithStrings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("ProviderType").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> STATES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("States").getter(ListRepositoryAssociationsRequest.getter(ListRepositoryAssociationsRequest::statesAsStrings)).setter(ListRepositoryAssociationsRequest.setter(Builder::statesWithStrings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("State").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> NAMES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Names").getter(ListRepositoryAssociationsRequest.getter(ListRepositoryAssociationsRequest::names)).setter(ListRepositoryAssociationsRequest.setter(Builder::names)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("Name").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> OWNERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Owners").getter(ListRepositoryAssociationsRequest.getter(ListRepositoryAssociationsRequest::owners)).setter(ListRepositoryAssociationsRequest.setter(Builder::owners)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("Owner").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("MaxResults").getter(ListRepositoryAssociationsRequest.getter(ListRepositoryAssociationsRequest::maxResults)).setter(ListRepositoryAssociationsRequest.setter(Builder::maxResults)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("MaxResults").build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(ListRepositoryAssociationsRequest.getter(ListRepositoryAssociationsRequest::nextToken)).setter(ListRepositoryAssociationsRequest.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("NextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PROVIDER_TYPES_FIELD, STATES_FIELD, NAMES_FIELD, OWNERS_FIELD, MAX_RESULTS_FIELD, NEXT_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("ProviderType", PROVIDER_TYPES_FIELD);
            this.put("State", STATES_FIELD);
            this.put("Name", NAMES_FIELD);
            this.put("Owner", OWNERS_FIELD);
            this.put("MaxResults", MAX_RESULTS_FIELD);
            this.put("NextToken", NEXT_TOKEN_FIELD);
        }
    });
    private final List<String> providerTypes;
    private final List<String> states;
    private final List<String> names;
    private final List<String> owners;
    private final Integer maxResults;
    private final String nextToken;

    private ListRepositoryAssociationsRequest(BuilderImpl builder) {
        super(builder);
        this.providerTypes = builder.providerTypes;
        this.states = builder.states;
        this.names = builder.names;
        this.owners = builder.owners;
        this.maxResults = builder.maxResults;
        this.nextToken = builder.nextToken;
    }

    public final List<ProviderType> providerTypes() {
        return ProviderTypesCopier.copyStringToEnum(this.providerTypes);
    }

    public final boolean hasProviderTypes() {
        return this.providerTypes != null && !(this.providerTypes instanceof SdkAutoConstructList);
    }

    public final List<String> providerTypesAsStrings() {
        return this.providerTypes;
    }

    public final List<RepositoryAssociationState> states() {
        return RepositoryAssociationStatesCopier.copyStringToEnum(this.states);
    }

    public final boolean hasStates() {
        return this.states != null && !(this.states instanceof SdkAutoConstructList);
    }

    public final List<String> statesAsStrings() {
        return this.states;
    }

    public final boolean hasNames() {
        return this.names != null && !(this.names instanceof SdkAutoConstructList);
    }

    public final List<String> names() {
        return this.names;
    }

    public final boolean hasOwners() {
        return this.owners != null && !(this.owners instanceof SdkAutoConstructList);
    }

    public final List<String> owners() {
        return this.owners;
    }

    public final Integer maxResults() {
        return this.maxResults;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasProviderTypes() ? this.providerTypesAsStrings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasStates() ? this.statesAsStrings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasNames() ? this.names() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasOwners() ? this.owners() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListRepositoryAssociationsRequest)) {
            return false;
        }
        ListRepositoryAssociationsRequest other = (ListRepositoryAssociationsRequest)((Object)obj);
        return this.hasProviderTypes() == other.hasProviderTypes() && Objects.equals(this.providerTypesAsStrings(), other.providerTypesAsStrings()) && this.hasStates() == other.hasStates() && Objects.equals(this.statesAsStrings(), other.statesAsStrings()) && this.hasNames() == other.hasNames() && Objects.equals(this.names(), other.names()) && this.hasOwners() == other.hasOwners() && Objects.equals(this.owners(), other.owners()) && Objects.equals(this.maxResults(), other.maxResults()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"ListRepositoryAssociationsRequest").add("ProviderTypes", this.hasProviderTypes() ? this.providerTypesAsStrings() : null).add("States", this.hasStates() ? this.statesAsStrings() : null).add("Names", this.hasNames() ? this.names() : null).add("Owners", this.hasOwners() ? this.owners() : null).add("MaxResults", (Object)this.maxResults()).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ProviderTypes": {
                return Optional.ofNullable(clazz.cast(this.providerTypesAsStrings()));
            }
            case "States": {
                return Optional.ofNullable(clazz.cast(this.statesAsStrings()));
            }
            case "Names": {
                return Optional.ofNullable(clazz.cast(this.names()));
            }
            case "Owners": {
                return Optional.ofNullable(clazz.cast(this.owners()));
            }
            case "MaxResults": {
                return Optional.ofNullable(clazz.cast(this.maxResults()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<ListRepositoryAssociationsRequest, T> g) {
        return obj -> g.apply((ListRepositoryAssociationsRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends CodeGuruReviewerRequest.BuilderImpl
    implements Builder {
        private List<String> providerTypes = DefaultSdkAutoConstructList.getInstance();
        private List<String> states = DefaultSdkAutoConstructList.getInstance();
        private List<String> names = DefaultSdkAutoConstructList.getInstance();
        private List<String> owners = DefaultSdkAutoConstructList.getInstance();
        private Integer maxResults;
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListRepositoryAssociationsRequest model) {
            super(model);
            this.providerTypesWithStrings(model.providerTypes);
            this.statesWithStrings(model.states);
            this.names(model.names);
            this.owners(model.owners);
            this.maxResults(model.maxResults);
            this.nextToken(model.nextToken);
        }

        public final Collection<String> getProviderTypes() {
            if (this.providerTypes instanceof SdkAutoConstructList) {
                return null;
            }
            return this.providerTypes;
        }

        public final void setProviderTypes(Collection<String> providerTypes) {
            this.providerTypes = ProviderTypesCopier.copy(providerTypes);
        }

        @Override
        public final Builder providerTypesWithStrings(Collection<String> providerTypes) {
            this.providerTypes = ProviderTypesCopier.copy(providerTypes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder providerTypesWithStrings(String ... providerTypes) {
            this.providerTypesWithStrings(Arrays.asList(providerTypes));
            return this;
        }

        @Override
        public final Builder providerTypes(Collection<ProviderType> providerTypes) {
            this.providerTypes = ProviderTypesCopier.copyEnumToString(providerTypes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder providerTypes(ProviderType ... providerTypes) {
            this.providerTypes(Arrays.asList(providerTypes));
            return this;
        }

        public final Collection<String> getStates() {
            if (this.states instanceof SdkAutoConstructList) {
                return null;
            }
            return this.states;
        }

        public final void setStates(Collection<String> states) {
            this.states = RepositoryAssociationStatesCopier.copy(states);
        }

        @Override
        public final Builder statesWithStrings(Collection<String> states) {
            this.states = RepositoryAssociationStatesCopier.copy(states);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder statesWithStrings(String ... states) {
            this.statesWithStrings(Arrays.asList(states));
            return this;
        }

        @Override
        public final Builder states(Collection<RepositoryAssociationState> states) {
            this.states = RepositoryAssociationStatesCopier.copyEnumToString(states);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder states(RepositoryAssociationState ... states) {
            this.states(Arrays.asList(states));
            return this;
        }

        public final Collection<String> getNames() {
            if (this.names instanceof SdkAutoConstructList) {
                return null;
            }
            return this.names;
        }

        public final void setNames(Collection<String> names) {
            this.names = NamesCopier.copy(names);
        }

        @Override
        public final Builder names(Collection<String> names) {
            this.names = NamesCopier.copy(names);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder names(String ... names) {
            this.names(Arrays.asList(names));
            return this;
        }

        public final Collection<String> getOwners() {
            if (this.owners instanceof SdkAutoConstructList) {
                return null;
            }
            return this.owners;
        }

        public final void setOwners(Collection<String> owners) {
            this.owners = OwnersCopier.copy(owners);
        }

        @Override
        public final Builder owners(Collection<String> owners) {
            this.owners = OwnersCopier.copy(owners);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder owners(String ... owners) {
            this.owners(Arrays.asList(owners));
            return this;
        }

        public final Integer getMaxResults() {
            return this.maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListRepositoryAssociationsRequest build() {
            return new ListRepositoryAssociationsRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends CodeGuruReviewerRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListRepositoryAssociationsRequest> {
        public Builder providerTypesWithStrings(Collection<String> var1);

        public Builder providerTypesWithStrings(String ... var1);

        public Builder providerTypes(Collection<ProviderType> var1);

        public Builder providerTypes(ProviderType ... var1);

        public Builder statesWithStrings(Collection<String> var1);

        public Builder statesWithStrings(String ... var1);

        public Builder states(Collection<RepositoryAssociationState> var1);

        public Builder states(RepositoryAssociationState ... var1);

        public Builder names(Collection<String> var1);

        public Builder names(String ... var1);

        public Builder owners(Collection<String> var1);

        public Builder owners(String ... var1);

        public Builder maxResults(Integer var1);

        public Builder nextToken(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

