/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codegurureviewer;

import java.net.URI;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.client.config.AwsClientOption;
import software.amazon.awssdk.core.client.config.ClientOption;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.codegurureviewer.CodeGuruReviewerClient;
import software.amazon.awssdk.services.codegurureviewer.CodeGuruReviewerClientBuilder;
import software.amazon.awssdk.services.codegurureviewer.CodeGuruReviewerServiceClientConfiguration;
import software.amazon.awssdk.services.codegurureviewer.DefaultCodeGuruReviewerBaseClientBuilder;
import software.amazon.awssdk.services.codegurureviewer.DefaultCodeGuruReviewerClient;
import software.amazon.awssdk.services.codegurureviewer.endpoints.CodeGuruReviewerEndpointProvider;

@SdkInternalApi
final class DefaultCodeGuruReviewerClientBuilder
extends DefaultCodeGuruReviewerBaseClientBuilder<CodeGuruReviewerClientBuilder, CodeGuruReviewerClient>
implements CodeGuruReviewerClientBuilder {
    DefaultCodeGuruReviewerClientBuilder() {
    }

    @Override
    public DefaultCodeGuruReviewerClientBuilder endpointProvider(CodeGuruReviewerEndpointProvider endpointProvider) {
        this.clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_PROVIDER, (Object)endpointProvider);
        return this;
    }

    protected final CodeGuruReviewerClient buildClient() {
        SdkClientConfiguration clientConfiguration = super.syncClientConfiguration();
        DefaultCodeGuruReviewerClientBuilder.validateClientOptions(clientConfiguration);
        URI endpointOverride = null;
        if (clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_OVERRIDDEN) != null && Boolean.TRUE.equals(clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_OVERRIDDEN))) {
            endpointOverride = (URI)clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT);
        }
        CodeGuruReviewerServiceClientConfiguration serviceClientConfiguration = CodeGuruReviewerServiceClientConfiguration.builder().overrideConfiguration(this.overrideConfiguration()).region((Region)clientConfiguration.option((ClientOption)AwsClientOption.AWS_REGION)).endpointOverride(endpointOverride).build();
        return new DefaultCodeGuruReviewerClient(serviceClientConfiguration, clientConfiguration);
    }
}

