/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codegurureviewer.model;

import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public enum Reaction {
    THUMBS_UP("ThumbsUp"),
    THUMBS_DOWN("ThumbsDown"),
    UNKNOWN_TO_SDK_VERSION(null);

    private final String value;

    private Reaction(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static Reaction fromValue(String value) {
        if (value == null) {
            return null;
        }
        return Stream.of(Reaction.values()).filter(e -> e.toString().equals(value)).findFirst().orElse(UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<Reaction> knownValues() {
        return Stream.of(Reaction.values()).filter(v -> v != UNKNOWN_TO_SDK_VERSION).collect(Collectors.toSet());
    }
}

