/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codegurureviewer.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Metrics
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Metrics> {
    private static final SdkField<Long> METERED_LINES_OF_CODE_COUNT_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("MeteredLinesOfCodeCount").getter(Metrics.getter(Metrics::meteredLinesOfCodeCount)).setter(Metrics.setter(Builder::meteredLinesOfCodeCount)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MeteredLinesOfCodeCount").build()}).build();
    private static final SdkField<Long> SUPPRESSED_LINES_OF_CODE_COUNT_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("SuppressedLinesOfCodeCount").getter(Metrics.getter(Metrics::suppressedLinesOfCodeCount)).setter(Metrics.setter(Builder::suppressedLinesOfCodeCount)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SuppressedLinesOfCodeCount").build()}).build();
    private static final SdkField<Long> FINDINGS_COUNT_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("FindingsCount").getter(Metrics.getter(Metrics::findingsCount)).setter(Metrics.setter(Builder::findingsCount)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FindingsCount").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(METERED_LINES_OF_CODE_COUNT_FIELD, SUPPRESSED_LINES_OF_CODE_COUNT_FIELD, FINDINGS_COUNT_FIELD));
    private static final long serialVersionUID = 1L;
    private final Long meteredLinesOfCodeCount;
    private final Long suppressedLinesOfCodeCount;
    private final Long findingsCount;

    private Metrics(BuilderImpl builder) {
        this.meteredLinesOfCodeCount = builder.meteredLinesOfCodeCount;
        this.suppressedLinesOfCodeCount = builder.suppressedLinesOfCodeCount;
        this.findingsCount = builder.findingsCount;
    }

    public final Long meteredLinesOfCodeCount() {
        return this.meteredLinesOfCodeCount;
    }

    public final Long suppressedLinesOfCodeCount() {
        return this.suppressedLinesOfCodeCount;
    }

    public final Long findingsCount() {
        return this.findingsCount;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.meteredLinesOfCodeCount());
        hashCode = 31 * hashCode + Objects.hashCode(this.suppressedLinesOfCodeCount());
        hashCode = 31 * hashCode + Objects.hashCode(this.findingsCount());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Metrics)) {
            return false;
        }
        Metrics other = (Metrics)obj;
        return Objects.equals(this.meteredLinesOfCodeCount(), other.meteredLinesOfCodeCount()) && Objects.equals(this.suppressedLinesOfCodeCount(), other.suppressedLinesOfCodeCount()) && Objects.equals(this.findingsCount(), other.findingsCount());
    }

    public final String toString() {
        return ToString.builder((String)"Metrics").add("MeteredLinesOfCodeCount", (Object)this.meteredLinesOfCodeCount()).add("SuppressedLinesOfCodeCount", (Object)this.suppressedLinesOfCodeCount()).add("FindingsCount", (Object)this.findingsCount()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "MeteredLinesOfCodeCount": {
                return Optional.ofNullable(clazz.cast(this.meteredLinesOfCodeCount()));
            }
            case "SuppressedLinesOfCodeCount": {
                return Optional.ofNullable(clazz.cast(this.suppressedLinesOfCodeCount()));
            }
            case "FindingsCount": {
                return Optional.ofNullable(clazz.cast(this.findingsCount()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Metrics, T> g) {
        return obj -> g.apply((Metrics)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Long meteredLinesOfCodeCount;
        private Long suppressedLinesOfCodeCount;
        private Long findingsCount;

        private BuilderImpl() {
        }

        private BuilderImpl(Metrics model) {
            this.meteredLinesOfCodeCount(model.meteredLinesOfCodeCount);
            this.suppressedLinesOfCodeCount(model.suppressedLinesOfCodeCount);
            this.findingsCount(model.findingsCount);
        }

        public final Long getMeteredLinesOfCodeCount() {
            return this.meteredLinesOfCodeCount;
        }

        public final void setMeteredLinesOfCodeCount(Long meteredLinesOfCodeCount) {
            this.meteredLinesOfCodeCount = meteredLinesOfCodeCount;
        }

        @Override
        public final Builder meteredLinesOfCodeCount(Long meteredLinesOfCodeCount) {
            this.meteredLinesOfCodeCount = meteredLinesOfCodeCount;
            return this;
        }

        public final Long getSuppressedLinesOfCodeCount() {
            return this.suppressedLinesOfCodeCount;
        }

        public final void setSuppressedLinesOfCodeCount(Long suppressedLinesOfCodeCount) {
            this.suppressedLinesOfCodeCount = suppressedLinesOfCodeCount;
        }

        @Override
        public final Builder suppressedLinesOfCodeCount(Long suppressedLinesOfCodeCount) {
            this.suppressedLinesOfCodeCount = suppressedLinesOfCodeCount;
            return this;
        }

        public final Long getFindingsCount() {
            return this.findingsCount;
        }

        public final void setFindingsCount(Long findingsCount) {
            this.findingsCount = findingsCount;
        }

        @Override
        public final Builder findingsCount(Long findingsCount) {
            this.findingsCount = findingsCount;
            return this;
        }

        public Metrics build() {
            return new Metrics(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Metrics> {
        public Builder meteredLinesOfCodeCount(Long var1);

        public Builder suppressedLinesOfCodeCount(Long var1);

        public Builder findingsCount(Long var1);
    }
}

