/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codegurureviewer.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.codegurureviewer.model.JobState;
import software.amazon.awssdk.services.codegurureviewer.model.MetricsSummary;
import software.amazon.awssdk.services.codegurureviewer.model.ProviderType;
import software.amazon.awssdk.services.codegurureviewer.model.Type;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CodeReviewSummary
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, CodeReviewSummary> {
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Name").getter(CodeReviewSummary.getter(CodeReviewSummary::name)).setter(CodeReviewSummary.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()}).build();
    private static final SdkField<String> CODE_REVIEW_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("CodeReviewArn").getter(CodeReviewSummary.getter(CodeReviewSummary::codeReviewArn)).setter(CodeReviewSummary.setter(Builder::codeReviewArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CodeReviewArn").build()}).build();
    private static final SdkField<String> REPOSITORY_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RepositoryName").getter(CodeReviewSummary.getter(CodeReviewSummary::repositoryName)).setter(CodeReviewSummary.setter(Builder::repositoryName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RepositoryName").build()}).build();
    private static final SdkField<String> OWNER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Owner").getter(CodeReviewSummary.getter(CodeReviewSummary::owner)).setter(CodeReviewSummary.setter(Builder::owner)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Owner").build()}).build();
    private static final SdkField<String> PROVIDER_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ProviderType").getter(CodeReviewSummary.getter(CodeReviewSummary::providerTypeAsString)).setter(CodeReviewSummary.setter(Builder::providerType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProviderType").build()}).build();
    private static final SdkField<String> STATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("State").getter(CodeReviewSummary.getter(CodeReviewSummary::stateAsString)).setter(CodeReviewSummary.setter(Builder::state)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("State").build()}).build();
    private static final SdkField<Instant> CREATED_TIME_STAMP_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("CreatedTimeStamp").getter(CodeReviewSummary.getter(CodeReviewSummary::createdTimeStamp)).setter(CodeReviewSummary.setter(Builder::createdTimeStamp)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreatedTimeStamp").build()}).build();
    private static final SdkField<Instant> LAST_UPDATED_TIME_STAMP_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("LastUpdatedTimeStamp").getter(CodeReviewSummary.getter(CodeReviewSummary::lastUpdatedTimeStamp)).setter(CodeReviewSummary.setter(Builder::lastUpdatedTimeStamp)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastUpdatedTimeStamp").build()}).build();
    private static final SdkField<String> TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Type").getter(CodeReviewSummary.getter(CodeReviewSummary::typeAsString)).setter(CodeReviewSummary.setter(Builder::type)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Type").build()}).build();
    private static final SdkField<String> PULL_REQUEST_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PullRequestId").getter(CodeReviewSummary.getter(CodeReviewSummary::pullRequestId)).setter(CodeReviewSummary.setter(Builder::pullRequestId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PullRequestId").build()}).build();
    private static final SdkField<MetricsSummary> METRICS_SUMMARY_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("MetricsSummary").getter(CodeReviewSummary.getter(CodeReviewSummary::metricsSummary)).setter(CodeReviewSummary.setter(Builder::metricsSummary)).constructor(MetricsSummary::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MetricsSummary").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, CODE_REVIEW_ARN_FIELD, REPOSITORY_NAME_FIELD, OWNER_FIELD, PROVIDER_TYPE_FIELD, STATE_FIELD, CREATED_TIME_STAMP_FIELD, LAST_UPDATED_TIME_STAMP_FIELD, TYPE_FIELD, PULL_REQUEST_ID_FIELD, METRICS_SUMMARY_FIELD));
    private static final long serialVersionUID = 1L;
    private final String name;
    private final String codeReviewArn;
    private final String repositoryName;
    private final String owner;
    private final String providerType;
    private final String state;
    private final Instant createdTimeStamp;
    private final Instant lastUpdatedTimeStamp;
    private final String type;
    private final String pullRequestId;
    private final MetricsSummary metricsSummary;

    private CodeReviewSummary(BuilderImpl builder) {
        this.name = builder.name;
        this.codeReviewArn = builder.codeReviewArn;
        this.repositoryName = builder.repositoryName;
        this.owner = builder.owner;
        this.providerType = builder.providerType;
        this.state = builder.state;
        this.createdTimeStamp = builder.createdTimeStamp;
        this.lastUpdatedTimeStamp = builder.lastUpdatedTimeStamp;
        this.type = builder.type;
        this.pullRequestId = builder.pullRequestId;
        this.metricsSummary = builder.metricsSummary;
    }

    public String name() {
        return this.name;
    }

    public String codeReviewArn() {
        return this.codeReviewArn;
    }

    public String repositoryName() {
        return this.repositoryName;
    }

    public String owner() {
        return this.owner;
    }

    public ProviderType providerType() {
        return ProviderType.fromValue(this.providerType);
    }

    public String providerTypeAsString() {
        return this.providerType;
    }

    public JobState state() {
        return JobState.fromValue(this.state);
    }

    public String stateAsString() {
        return this.state;
    }

    public Instant createdTimeStamp() {
        return this.createdTimeStamp;
    }

    public Instant lastUpdatedTimeStamp() {
        return this.lastUpdatedTimeStamp;
    }

    public Type type() {
        return Type.fromValue(this.type);
    }

    public String typeAsString() {
        return this.type;
    }

    public String pullRequestId() {
        return this.pullRequestId;
    }

    public MetricsSummary metricsSummary() {
        return this.metricsSummary;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.codeReviewArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.repositoryName());
        hashCode = 31 * hashCode + Objects.hashCode(this.owner());
        hashCode = 31 * hashCode + Objects.hashCode(this.providerTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.stateAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.createdTimeStamp());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastUpdatedTimeStamp());
        hashCode = 31 * hashCode + Objects.hashCode(this.typeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.pullRequestId());
        hashCode = 31 * hashCode + Objects.hashCode(this.metricsSummary());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CodeReviewSummary)) {
            return false;
        }
        CodeReviewSummary other = (CodeReviewSummary)obj;
        return Objects.equals(this.name(), other.name()) && Objects.equals(this.codeReviewArn(), other.codeReviewArn()) && Objects.equals(this.repositoryName(), other.repositoryName()) && Objects.equals(this.owner(), other.owner()) && Objects.equals(this.providerTypeAsString(), other.providerTypeAsString()) && Objects.equals(this.stateAsString(), other.stateAsString()) && Objects.equals(this.createdTimeStamp(), other.createdTimeStamp()) && Objects.equals(this.lastUpdatedTimeStamp(), other.lastUpdatedTimeStamp()) && Objects.equals(this.typeAsString(), other.typeAsString()) && Objects.equals(this.pullRequestId(), other.pullRequestId()) && Objects.equals(this.metricsSummary(), other.metricsSummary());
    }

    public String toString() {
        return ToString.builder((String)"CodeReviewSummary").add("Name", (Object)this.name()).add("CodeReviewArn", (Object)this.codeReviewArn()).add("RepositoryName", (Object)this.repositoryName()).add("Owner", (Object)this.owner()).add("ProviderType", (Object)this.providerTypeAsString()).add("State", (Object)this.stateAsString()).add("CreatedTimeStamp", (Object)this.createdTimeStamp()).add("LastUpdatedTimeStamp", (Object)this.lastUpdatedTimeStamp()).add("Type", (Object)this.typeAsString()).add("PullRequestId", (Object)this.pullRequestId()).add("MetricsSummary", (Object)this.metricsSummary()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "CodeReviewArn": {
                return Optional.ofNullable(clazz.cast(this.codeReviewArn()));
            }
            case "RepositoryName": {
                return Optional.ofNullable(clazz.cast(this.repositoryName()));
            }
            case "Owner": {
                return Optional.ofNullable(clazz.cast(this.owner()));
            }
            case "ProviderType": {
                return Optional.ofNullable(clazz.cast(this.providerTypeAsString()));
            }
            case "State": {
                return Optional.ofNullable(clazz.cast(this.stateAsString()));
            }
            case "CreatedTimeStamp": {
                return Optional.ofNullable(clazz.cast(this.createdTimeStamp()));
            }
            case "LastUpdatedTimeStamp": {
                return Optional.ofNullable(clazz.cast(this.lastUpdatedTimeStamp()));
            }
            case "Type": {
                return Optional.ofNullable(clazz.cast(this.typeAsString()));
            }
            case "PullRequestId": {
                return Optional.ofNullable(clazz.cast(this.pullRequestId()));
            }
            case "MetricsSummary": {
                return Optional.ofNullable(clazz.cast(this.metricsSummary()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CodeReviewSummary, T> g) {
        return obj -> g.apply((CodeReviewSummary)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String name;
        private String codeReviewArn;
        private String repositoryName;
        private String owner;
        private String providerType;
        private String state;
        private Instant createdTimeStamp;
        private Instant lastUpdatedTimeStamp;
        private String type;
        private String pullRequestId;
        private MetricsSummary metricsSummary;

        private BuilderImpl() {
        }

        private BuilderImpl(CodeReviewSummary model) {
            this.name(model.name);
            this.codeReviewArn(model.codeReviewArn);
            this.repositoryName(model.repositoryName);
            this.owner(model.owner);
            this.providerType(model.providerType);
            this.state(model.state);
            this.createdTimeStamp(model.createdTimeStamp);
            this.lastUpdatedTimeStamp(model.lastUpdatedTimeStamp);
            this.type(model.type);
            this.pullRequestId(model.pullRequestId);
            this.metricsSummary(model.metricsSummary);
        }

        public final String getName() {
            return this.name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getCodeReviewArn() {
            return this.codeReviewArn;
        }

        @Override
        public final Builder codeReviewArn(String codeReviewArn) {
            this.codeReviewArn = codeReviewArn;
            return this;
        }

        public final void setCodeReviewArn(String codeReviewArn) {
            this.codeReviewArn = codeReviewArn;
        }

        public final String getRepositoryName() {
            return this.repositoryName;
        }

        @Override
        public final Builder repositoryName(String repositoryName) {
            this.repositoryName = repositoryName;
            return this;
        }

        public final void setRepositoryName(String repositoryName) {
            this.repositoryName = repositoryName;
        }

        public final String getOwner() {
            return this.owner;
        }

        @Override
        public final Builder owner(String owner) {
            this.owner = owner;
            return this;
        }

        public final void setOwner(String owner) {
            this.owner = owner;
        }

        public final String getProviderType() {
            return this.providerType;
        }

        @Override
        public final Builder providerType(String providerType) {
            this.providerType = providerType;
            return this;
        }

        @Override
        public final Builder providerType(ProviderType providerType) {
            this.providerType(providerType == null ? null : providerType.toString());
            return this;
        }

        public final void setProviderType(String providerType) {
            this.providerType = providerType;
        }

        public final String getState() {
            return this.state;
        }

        @Override
        public final Builder state(String state) {
            this.state = state;
            return this;
        }

        @Override
        public final Builder state(JobState state) {
            this.state(state == null ? null : state.toString());
            return this;
        }

        public final void setState(String state) {
            this.state = state;
        }

        public final Instant getCreatedTimeStamp() {
            return this.createdTimeStamp;
        }

        @Override
        public final Builder createdTimeStamp(Instant createdTimeStamp) {
            this.createdTimeStamp = createdTimeStamp;
            return this;
        }

        public final void setCreatedTimeStamp(Instant createdTimeStamp) {
            this.createdTimeStamp = createdTimeStamp;
        }

        public final Instant getLastUpdatedTimeStamp() {
            return this.lastUpdatedTimeStamp;
        }

        @Override
        public final Builder lastUpdatedTimeStamp(Instant lastUpdatedTimeStamp) {
            this.lastUpdatedTimeStamp = lastUpdatedTimeStamp;
            return this;
        }

        public final void setLastUpdatedTimeStamp(Instant lastUpdatedTimeStamp) {
            this.lastUpdatedTimeStamp = lastUpdatedTimeStamp;
        }

        public final String getType() {
            return this.type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(Type type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        public final void setType(String type) {
            this.type = type;
        }

        public final String getPullRequestId() {
            return this.pullRequestId;
        }

        @Override
        public final Builder pullRequestId(String pullRequestId) {
            this.pullRequestId = pullRequestId;
            return this;
        }

        public final void setPullRequestId(String pullRequestId) {
            this.pullRequestId = pullRequestId;
        }

        public final MetricsSummary.Builder getMetricsSummary() {
            return this.metricsSummary != null ? this.metricsSummary.toBuilder() : null;
        }

        @Override
        public final Builder metricsSummary(MetricsSummary metricsSummary) {
            this.metricsSummary = metricsSummary;
            return this;
        }

        public final void setMetricsSummary(MetricsSummary.BuilderImpl metricsSummary) {
            this.metricsSummary = metricsSummary != null ? metricsSummary.build() : null;
        }

        public CodeReviewSummary build() {
            return new CodeReviewSummary(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, CodeReviewSummary> {
        public Builder name(String var1);

        public Builder codeReviewArn(String var1);

        public Builder repositoryName(String var1);

        public Builder owner(String var1);

        public Builder providerType(String var1);

        public Builder providerType(ProviderType var1);

        public Builder state(String var1);

        public Builder state(JobState var1);

        public Builder createdTimeStamp(Instant var1);

        public Builder lastUpdatedTimeStamp(Instant var1);

        public Builder type(String var1);

        public Builder type(Type var1);

        public Builder pullRequestId(String var1);

        public Builder metricsSummary(MetricsSummary var1);

        default public Builder metricsSummary(Consumer<MetricsSummary.Builder> metricsSummary) {
            return this.metricsSummary((MetricsSummary)((MetricsSummary.Builder)MetricsSummary.builder().applyMutation(metricsSummary)).build());
        }
    }
}

