/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codegurureviewer.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class RecommendationSummary
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, RecommendationSummary> {
    private static final SdkField<String> FILE_PATH_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("FilePath").getter(RecommendationSummary.getter(RecommendationSummary::filePath)).setter(RecommendationSummary.setter(Builder::filePath)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FilePath").build()}).build();
    private static final SdkField<String> RECOMMENDATION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RecommendationId").getter(RecommendationSummary.getter(RecommendationSummary::recommendationId)).setter(RecommendationSummary.setter(Builder::recommendationId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RecommendationId").build()}).build();
    private static final SdkField<Integer> START_LINE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("StartLine").getter(RecommendationSummary.getter(RecommendationSummary::startLine)).setter(RecommendationSummary.setter(Builder::startLine)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StartLine").build()}).build();
    private static final SdkField<Integer> END_LINE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("EndLine").getter(RecommendationSummary.getter(RecommendationSummary::endLine)).setter(RecommendationSummary.setter(Builder::endLine)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EndLine").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Description").getter(RecommendationSummary.getter(RecommendationSummary::description)).setter(RecommendationSummary.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FILE_PATH_FIELD, RECOMMENDATION_ID_FIELD, START_LINE_FIELD, END_LINE_FIELD, DESCRIPTION_FIELD));
    private static final long serialVersionUID = 1L;
    private final String filePath;
    private final String recommendationId;
    private final Integer startLine;
    private final Integer endLine;
    private final String description;

    private RecommendationSummary(BuilderImpl builder) {
        this.filePath = builder.filePath;
        this.recommendationId = builder.recommendationId;
        this.startLine = builder.startLine;
        this.endLine = builder.endLine;
        this.description = builder.description;
    }

    public String filePath() {
        return this.filePath;
    }

    public String recommendationId() {
        return this.recommendationId;
    }

    public Integer startLine() {
        return this.startLine;
    }

    public Integer endLine() {
        return this.endLine;
    }

    public String description() {
        return this.description;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.filePath());
        hashCode = 31 * hashCode + Objects.hashCode(this.recommendationId());
        hashCode = 31 * hashCode + Objects.hashCode(this.startLine());
        hashCode = 31 * hashCode + Objects.hashCode(this.endLine());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RecommendationSummary)) {
            return false;
        }
        RecommendationSummary other = (RecommendationSummary)obj;
        return Objects.equals(this.filePath(), other.filePath()) && Objects.equals(this.recommendationId(), other.recommendationId()) && Objects.equals(this.startLine(), other.startLine()) && Objects.equals(this.endLine(), other.endLine()) && Objects.equals(this.description(), other.description());
    }

    public String toString() {
        return ToString.builder((String)"RecommendationSummary").add("FilePath", (Object)this.filePath()).add("RecommendationId", (Object)this.recommendationId()).add("StartLine", (Object)this.startLine()).add("EndLine", (Object)this.endLine()).add("Description", (Object)this.description()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "FilePath": {
                return Optional.ofNullable(clazz.cast(this.filePath()));
            }
            case "RecommendationId": {
                return Optional.ofNullable(clazz.cast(this.recommendationId()));
            }
            case "StartLine": {
                return Optional.ofNullable(clazz.cast(this.startLine()));
            }
            case "EndLine": {
                return Optional.ofNullable(clazz.cast(this.endLine()));
            }
            case "Description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<RecommendationSummary, T> g) {
        return obj -> g.apply((RecommendationSummary)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String filePath;
        private String recommendationId;
        private Integer startLine;
        private Integer endLine;
        private String description;

        private BuilderImpl() {
        }

        private BuilderImpl(RecommendationSummary model) {
            this.filePath(model.filePath);
            this.recommendationId(model.recommendationId);
            this.startLine(model.startLine);
            this.endLine(model.endLine);
            this.description(model.description);
        }

        public final String getFilePath() {
            return this.filePath;
        }

        @Override
        public final Builder filePath(String filePath) {
            this.filePath = filePath;
            return this;
        }

        public final void setFilePath(String filePath) {
            this.filePath = filePath;
        }

        public final String getRecommendationId() {
            return this.recommendationId;
        }

        @Override
        public final Builder recommendationId(String recommendationId) {
            this.recommendationId = recommendationId;
            return this;
        }

        public final void setRecommendationId(String recommendationId) {
            this.recommendationId = recommendationId;
        }

        public final Integer getStartLine() {
            return this.startLine;
        }

        @Override
        public final Builder startLine(Integer startLine) {
            this.startLine = startLine;
            return this;
        }

        public final void setStartLine(Integer startLine) {
            this.startLine = startLine;
        }

        public final Integer getEndLine() {
            return this.endLine;
        }

        @Override
        public final Builder endLine(Integer endLine) {
            this.endLine = endLine;
            return this;
        }

        public final void setEndLine(Integer endLine) {
            this.endLine = endLine;
        }

        public final String getDescription() {
            return this.description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public RecommendationSummary build() {
            return new RecommendationSummary(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, RecommendationSummary> {
        public Builder filePath(String var1);

        public Builder recommendationId(String var1);

        public Builder startLine(Integer var1);

        public Builder endLine(Integer var1);

        public Builder description(String var1);
    }
}

