/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codegurureviewer.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class MetricsSummary
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, MetricsSummary> {
    private static final SdkField<Long> METERED_LINES_OF_CODE_COUNT_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("MeteredLinesOfCodeCount").getter(MetricsSummary.getter(MetricsSummary::meteredLinesOfCodeCount)).setter(MetricsSummary.setter(Builder::meteredLinesOfCodeCount)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MeteredLinesOfCodeCount").build()}).build();
    private static final SdkField<Long> FINDINGS_COUNT_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("FindingsCount").getter(MetricsSummary.getter(MetricsSummary::findingsCount)).setter(MetricsSummary.setter(Builder::findingsCount)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FindingsCount").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(METERED_LINES_OF_CODE_COUNT_FIELD, FINDINGS_COUNT_FIELD));
    private static final long serialVersionUID = 1L;
    private final Long meteredLinesOfCodeCount;
    private final Long findingsCount;

    private MetricsSummary(BuilderImpl builder) {
        this.meteredLinesOfCodeCount = builder.meteredLinesOfCodeCount;
        this.findingsCount = builder.findingsCount;
    }

    public Long meteredLinesOfCodeCount() {
        return this.meteredLinesOfCodeCount;
    }

    public Long findingsCount() {
        return this.findingsCount;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.meteredLinesOfCodeCount());
        hashCode = 31 * hashCode + Objects.hashCode(this.findingsCount());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MetricsSummary)) {
            return false;
        }
        MetricsSummary other = (MetricsSummary)obj;
        return Objects.equals(this.meteredLinesOfCodeCount(), other.meteredLinesOfCodeCount()) && Objects.equals(this.findingsCount(), other.findingsCount());
    }

    public String toString() {
        return ToString.builder((String)"MetricsSummary").add("MeteredLinesOfCodeCount", (Object)this.meteredLinesOfCodeCount()).add("FindingsCount", (Object)this.findingsCount()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "MeteredLinesOfCodeCount": {
                return Optional.ofNullable(clazz.cast(this.meteredLinesOfCodeCount()));
            }
            case "FindingsCount": {
                return Optional.ofNullable(clazz.cast(this.findingsCount()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<MetricsSummary, T> g) {
        return obj -> g.apply((MetricsSummary)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Long meteredLinesOfCodeCount;
        private Long findingsCount;

        private BuilderImpl() {
        }

        private BuilderImpl(MetricsSummary model) {
            this.meteredLinesOfCodeCount(model.meteredLinesOfCodeCount);
            this.findingsCount(model.findingsCount);
        }

        public final Long getMeteredLinesOfCodeCount() {
            return this.meteredLinesOfCodeCount;
        }

        @Override
        public final Builder meteredLinesOfCodeCount(Long meteredLinesOfCodeCount) {
            this.meteredLinesOfCodeCount = meteredLinesOfCodeCount;
            return this;
        }

        public final void setMeteredLinesOfCodeCount(Long meteredLinesOfCodeCount) {
            this.meteredLinesOfCodeCount = meteredLinesOfCodeCount;
        }

        public final Long getFindingsCount() {
            return this.findingsCount;
        }

        @Override
        public final Builder findingsCount(Long findingsCount) {
            this.findingsCount = findingsCount;
            return this;
        }

        public final void setFindingsCount(Long findingsCount) {
            this.findingsCount = findingsCount;
        }

        public MetricsSummary build() {
            return new MetricsSummary(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, MetricsSummary> {
        public Builder meteredLinesOfCodeCount(Long var1);

        public Builder findingsCount(Long var1);
    }
}

