/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codegurureviewer.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.codegurureviewer.model.CodeGuruReviewerResponse;
import software.amazon.awssdk.services.codegurureviewer.model.RecommendationFeedbackSummariesCopier;
import software.amazon.awssdk.services.codegurureviewer.model.RecommendationFeedbackSummary;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListRecommendationFeedbackResponse
extends CodeGuruReviewerResponse
implements ToCopyableBuilder<Builder, ListRecommendationFeedbackResponse> {
    private static final SdkField<List<RecommendationFeedbackSummary>> RECOMMENDATION_FEEDBACK_SUMMARIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("RecommendationFeedbackSummaries").getter(ListRecommendationFeedbackResponse.getter(ListRecommendationFeedbackResponse::recommendationFeedbackSummaries)).setter(ListRecommendationFeedbackResponse.setter(Builder::recommendationFeedbackSummaries)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RecommendationFeedbackSummaries").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(RecommendationFeedbackSummary::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(ListRecommendationFeedbackResponse.getter(ListRecommendationFeedbackResponse::nextToken)).setter(ListRecommendationFeedbackResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RECOMMENDATION_FEEDBACK_SUMMARIES_FIELD, NEXT_TOKEN_FIELD));
    private final List<RecommendationFeedbackSummary> recommendationFeedbackSummaries;
    private final String nextToken;

    private ListRecommendationFeedbackResponse(BuilderImpl builder) {
        super(builder);
        this.recommendationFeedbackSummaries = builder.recommendationFeedbackSummaries;
        this.nextToken = builder.nextToken;
    }

    public boolean hasRecommendationFeedbackSummaries() {
        return this.recommendationFeedbackSummaries != null && !(this.recommendationFeedbackSummaries instanceof SdkAutoConstructList);
    }

    public List<RecommendationFeedbackSummary> recommendationFeedbackSummaries() {
        return this.recommendationFeedbackSummaries;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.recommendationFeedbackSummaries());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListRecommendationFeedbackResponse)) {
            return false;
        }
        ListRecommendationFeedbackResponse other = (ListRecommendationFeedbackResponse)((Object)obj);
        return Objects.equals(this.recommendationFeedbackSummaries(), other.recommendationFeedbackSummaries()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public String toString() {
        return ToString.builder((String)"ListRecommendationFeedbackResponse").add("RecommendationFeedbackSummaries", this.recommendationFeedbackSummaries()).add("NextToken", (Object)this.nextToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "RecommendationFeedbackSummaries": {
                return Optional.ofNullable(clazz.cast(this.recommendationFeedbackSummaries()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListRecommendationFeedbackResponse, T> g) {
        return obj -> g.apply((ListRecommendationFeedbackResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends CodeGuruReviewerResponse.BuilderImpl
    implements Builder {
        private List<RecommendationFeedbackSummary> recommendationFeedbackSummaries = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListRecommendationFeedbackResponse model) {
            super(model);
            this.recommendationFeedbackSummaries(model.recommendationFeedbackSummaries);
            this.nextToken(model.nextToken);
        }

        public final Collection<RecommendationFeedbackSummary.Builder> getRecommendationFeedbackSummaries() {
            return this.recommendationFeedbackSummaries != null ? (Collection)this.recommendationFeedbackSummaries.stream().map(RecommendationFeedbackSummary::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder recommendationFeedbackSummaries(Collection<RecommendationFeedbackSummary> recommendationFeedbackSummaries) {
            this.recommendationFeedbackSummaries = RecommendationFeedbackSummariesCopier.copy(recommendationFeedbackSummaries);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder recommendationFeedbackSummaries(RecommendationFeedbackSummary ... recommendationFeedbackSummaries) {
            this.recommendationFeedbackSummaries(Arrays.asList(recommendationFeedbackSummaries));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder recommendationFeedbackSummaries(Consumer<RecommendationFeedbackSummary.Builder> ... recommendationFeedbackSummaries) {
            this.recommendationFeedbackSummaries(Stream.of(recommendationFeedbackSummaries).map(c -> (RecommendationFeedbackSummary)((RecommendationFeedbackSummary.Builder)RecommendationFeedbackSummary.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setRecommendationFeedbackSummaries(Collection<RecommendationFeedbackSummary.BuilderImpl> recommendationFeedbackSummaries) {
            this.recommendationFeedbackSummaries = RecommendationFeedbackSummariesCopier.copyFromBuilder(recommendationFeedbackSummaries);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public ListRecommendationFeedbackResponse build() {
            return new ListRecommendationFeedbackResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends CodeGuruReviewerResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListRecommendationFeedbackResponse> {
        public Builder recommendationFeedbackSummaries(Collection<RecommendationFeedbackSummary> var1);

        public Builder recommendationFeedbackSummaries(RecommendationFeedbackSummary ... var1);

        public Builder recommendationFeedbackSummaries(Consumer<RecommendationFeedbackSummary.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

