/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codegurureviewer.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.codegurureviewer.model.CodeGuruReviewerRequest;
import software.amazon.awssdk.services.codegurureviewer.model.JobState;
import software.amazon.awssdk.services.codegurureviewer.model.JobStatesCopier;
import software.amazon.awssdk.services.codegurureviewer.model.ProviderType;
import software.amazon.awssdk.services.codegurureviewer.model.ProviderTypesCopier;
import software.amazon.awssdk.services.codegurureviewer.model.RepositoryNamesCopier;
import software.amazon.awssdk.services.codegurureviewer.model.Type;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListCodeReviewsRequest
extends CodeGuruReviewerRequest
implements ToCopyableBuilder<Builder, ListCodeReviewsRequest> {
    private static final SdkField<List<String>> PROVIDER_TYPES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(ListCodeReviewsRequest.getter(ListCodeReviewsRequest::providerTypesAsStrings)).setter(ListCodeReviewsRequest.setter(Builder::providerTypesWithStrings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("ProviderTypes").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> STATES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(ListCodeReviewsRequest.getter(ListCodeReviewsRequest::statesAsStrings)).setter(ListCodeReviewsRequest.setter(Builder::statesWithStrings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("States").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> REPOSITORY_NAMES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(ListCodeReviewsRequest.getter(ListCodeReviewsRequest::repositoryNames)).setter(ListCodeReviewsRequest.setter(Builder::repositoryNames)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("RepositoryNames").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ListCodeReviewsRequest.getter(ListCodeReviewsRequest::typeAsString)).setter(ListCodeReviewsRequest.setter(Builder::type)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("Type").build()}).build();
    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).getter(ListCodeReviewsRequest.getter(ListCodeReviewsRequest::maxResults)).setter(ListCodeReviewsRequest.setter(Builder::maxResults)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("MaxResults").build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ListCodeReviewsRequest.getter(ListCodeReviewsRequest::nextToken)).setter(ListCodeReviewsRequest.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("NextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PROVIDER_TYPES_FIELD, STATES_FIELD, REPOSITORY_NAMES_FIELD, TYPE_FIELD, MAX_RESULTS_FIELD, NEXT_TOKEN_FIELD));
    private final List<String> providerTypes;
    private final List<String> states;
    private final List<String> repositoryNames;
    private final String type;
    private final Integer maxResults;
    private final String nextToken;

    private ListCodeReviewsRequest(BuilderImpl builder) {
        super(builder);
        this.providerTypes = builder.providerTypes;
        this.states = builder.states;
        this.repositoryNames = builder.repositoryNames;
        this.type = builder.type;
        this.maxResults = builder.maxResults;
        this.nextToken = builder.nextToken;
    }

    public List<ProviderType> providerTypes() {
        return ProviderTypesCopier.copyStringToEnum(this.providerTypes);
    }

    public boolean hasProviderTypes() {
        return this.providerTypes != null && !(this.providerTypes instanceof SdkAutoConstructList);
    }

    public List<String> providerTypesAsStrings() {
        return this.providerTypes;
    }

    public List<JobState> states() {
        return JobStatesCopier.copyStringToEnum(this.states);
    }

    public boolean hasStates() {
        return this.states != null && !(this.states instanceof SdkAutoConstructList);
    }

    public List<String> statesAsStrings() {
        return this.states;
    }

    public boolean hasRepositoryNames() {
        return this.repositoryNames != null && !(this.repositoryNames instanceof SdkAutoConstructList);
    }

    public List<String> repositoryNames() {
        return this.repositoryNames;
    }

    public Type type() {
        return Type.fromValue(this.type);
    }

    public String typeAsString() {
        return this.type;
    }

    public Integer maxResults() {
        return this.maxResults;
    }

    public String nextToken() {
        return this.nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.providerTypesAsStrings());
        hashCode = 31 * hashCode + Objects.hashCode(this.statesAsStrings());
        hashCode = 31 * hashCode + Objects.hashCode(this.repositoryNames());
        hashCode = 31 * hashCode + Objects.hashCode(this.typeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListCodeReviewsRequest)) {
            return false;
        }
        ListCodeReviewsRequest other = (ListCodeReviewsRequest)((Object)obj);
        return Objects.equals(this.providerTypesAsStrings(), other.providerTypesAsStrings()) && Objects.equals(this.statesAsStrings(), other.statesAsStrings()) && Objects.equals(this.repositoryNames(), other.repositoryNames()) && Objects.equals(this.typeAsString(), other.typeAsString()) && Objects.equals(this.maxResults(), other.maxResults()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public String toString() {
        return ToString.builder((String)"ListCodeReviewsRequest").add("ProviderTypes", this.providerTypesAsStrings()).add("States", this.statesAsStrings()).add("RepositoryNames", this.repositoryNames()).add("Type", (Object)this.typeAsString()).add("MaxResults", (Object)this.maxResults()).add("NextToken", (Object)this.nextToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ProviderTypes": {
                return Optional.ofNullable(clazz.cast(this.providerTypesAsStrings()));
            }
            case "States": {
                return Optional.ofNullable(clazz.cast(this.statesAsStrings()));
            }
            case "RepositoryNames": {
                return Optional.ofNullable(clazz.cast(this.repositoryNames()));
            }
            case "Type": {
                return Optional.ofNullable(clazz.cast(this.typeAsString()));
            }
            case "MaxResults": {
                return Optional.ofNullable(clazz.cast(this.maxResults()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListCodeReviewsRequest, T> g) {
        return obj -> g.apply((ListCodeReviewsRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends CodeGuruReviewerRequest.BuilderImpl
    implements Builder {
        private List<String> providerTypes = DefaultSdkAutoConstructList.getInstance();
        private List<String> states = DefaultSdkAutoConstructList.getInstance();
        private List<String> repositoryNames = DefaultSdkAutoConstructList.getInstance();
        private String type;
        private Integer maxResults;
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListCodeReviewsRequest model) {
            super(model);
            this.providerTypesWithStrings(model.providerTypes);
            this.statesWithStrings(model.states);
            this.repositoryNames(model.repositoryNames);
            this.type(model.type);
            this.maxResults(model.maxResults);
            this.nextToken(model.nextToken);
        }

        public final Collection<String> getProviderTypes() {
            return this.providerTypes;
        }

        @Override
        public final Builder providerTypesWithStrings(Collection<String> providerTypes) {
            this.providerTypes = ProviderTypesCopier.copy(providerTypes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder providerTypesWithStrings(String ... providerTypes) {
            this.providerTypesWithStrings(Arrays.asList(providerTypes));
            return this;
        }

        @Override
        public final Builder providerTypes(Collection<ProviderType> providerTypes) {
            this.providerTypes = ProviderTypesCopier.copyEnumToString(providerTypes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder providerTypes(ProviderType ... providerTypes) {
            this.providerTypes(Arrays.asList(providerTypes));
            return this;
        }

        public final void setProviderTypes(Collection<String> providerTypes) {
            this.providerTypes = ProviderTypesCopier.copy(providerTypes);
        }

        public final Collection<String> getStates() {
            return this.states;
        }

        @Override
        public final Builder statesWithStrings(Collection<String> states) {
            this.states = JobStatesCopier.copy(states);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder statesWithStrings(String ... states) {
            this.statesWithStrings(Arrays.asList(states));
            return this;
        }

        @Override
        public final Builder states(Collection<JobState> states) {
            this.states = JobStatesCopier.copyEnumToString(states);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder states(JobState ... states) {
            this.states(Arrays.asList(states));
            return this;
        }

        public final void setStates(Collection<String> states) {
            this.states = JobStatesCopier.copy(states);
        }

        public final Collection<String> getRepositoryNames() {
            return this.repositoryNames;
        }

        @Override
        public final Builder repositoryNames(Collection<String> repositoryNames) {
            this.repositoryNames = RepositoryNamesCopier.copy(repositoryNames);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder repositoryNames(String ... repositoryNames) {
            this.repositoryNames(Arrays.asList(repositoryNames));
            return this;
        }

        public final void setRepositoryNames(Collection<String> repositoryNames) {
            this.repositoryNames = RepositoryNamesCopier.copy(repositoryNames);
        }

        public final String getType() {
            return this.type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(Type type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        public final void setType(String type) {
            this.type = type;
        }

        public final Integer getMaxResults() {
            return this.maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListCodeReviewsRequest build() {
            return new ListCodeReviewsRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends CodeGuruReviewerRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListCodeReviewsRequest> {
        public Builder providerTypesWithStrings(Collection<String> var1);

        public Builder providerTypesWithStrings(String ... var1);

        public Builder providerTypes(Collection<ProviderType> var1);

        public Builder providerTypes(ProviderType ... var1);

        public Builder statesWithStrings(Collection<String> var1);

        public Builder statesWithStrings(String ... var1);

        public Builder states(Collection<JobState> var1);

        public Builder states(JobState ... var1);

        public Builder repositoryNames(Collection<String> var1);

        public Builder repositoryNames(String ... var1);

        public Builder type(String var1);

        public Builder type(Type var1);

        public Builder maxResults(Integer var1);

        public Builder nextToken(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

