/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.codegurureviewer.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Information about a third party source repository connected through CodeStar Connections.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ThirdPartySourceRepository implements SdkPojo, Serializable,
        ToCopyableBuilder<ThirdPartySourceRepository.Builder, ThirdPartySourceRepository> {
    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ThirdPartySourceRepository::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()).build();

    private static final SdkField<String> CONNECTION_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ThirdPartySourceRepository::connectionArn)).setter(setter(Builder::connectionArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConnectionArn").build()).build();

    private static final SdkField<String> OWNER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ThirdPartySourceRepository::owner)).setter(setter(Builder::owner))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Owner").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD,
            CONNECTION_ARN_FIELD, OWNER_FIELD));

    private static final long serialVersionUID = 1L;

    private final String name;

    private final String connectionArn;

    private final String owner;

    private ThirdPartySourceRepository(BuilderImpl builder) {
        this.name = builder.name;
        this.connectionArn = builder.connectionArn;
        this.owner = builder.owner;
    }

    /**
     * <p>
     * The name of the third party source repository.
     * </p>
     * 
     * @return The name of the third party source repository.
     */
    public String name() {
        return name;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) identifying the repository connection.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) identifying the repository connection.
     */
    public String connectionArn() {
        return connectionArn;
    }

    /**
     * <p>
     * The username of the owner of the repository.
     * </p>
     * 
     * @return The username of the owner of the repository.
     */
    public String owner() {
        return owner;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(connectionArn());
        hashCode = 31 * hashCode + Objects.hashCode(owner());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ThirdPartySourceRepository)) {
            return false;
        }
        ThirdPartySourceRepository other = (ThirdPartySourceRepository) obj;
        return Objects.equals(name(), other.name()) && Objects.equals(connectionArn(), other.connectionArn())
                && Objects.equals(owner(), other.owner());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("ThirdPartySourceRepository").add("Name", name()).add("ConnectionArn", connectionArn())
                .add("Owner", owner()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "ConnectionArn":
            return Optional.ofNullable(clazz.cast(connectionArn()));
        case "Owner":
            return Optional.ofNullable(clazz.cast(owner()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ThirdPartySourceRepository, T> g) {
        return obj -> g.apply((ThirdPartySourceRepository) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ThirdPartySourceRepository> {
        /**
         * <p>
         * The name of the third party source repository.
         * </p>
         * 
         * @param name
         *        The name of the third party source repository.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The Amazon Resource Name (ARN) identifying the repository connection.
         * </p>
         * 
         * @param connectionArn
         *        The Amazon Resource Name (ARN) identifying the repository connection.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder connectionArn(String connectionArn);

        /**
         * <p>
         * The username of the owner of the repository.
         * </p>
         * 
         * @param owner
         *        The username of the owner of the repository.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder owner(String owner);
    }

    static final class BuilderImpl implements Builder {
        private String name;

        private String connectionArn;

        private String owner;

        private BuilderImpl() {
        }

        private BuilderImpl(ThirdPartySourceRepository model) {
            name(model.name);
            connectionArn(model.connectionArn);
            owner(model.owner);
        }

        public final String getName() {
            return name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getConnectionArn() {
            return connectionArn;
        }

        @Override
        public final Builder connectionArn(String connectionArn) {
            this.connectionArn = connectionArn;
            return this;
        }

        public final void setConnectionArn(String connectionArn) {
            this.connectionArn = connectionArn;
        }

        public final String getOwner() {
            return owner;
        }

        @Override
        public final Builder owner(String owner) {
            this.owner = owner;
            return this;
        }

        public final void setOwner(String owner) {
            this.owner = owner;
        }

        @Override
        public ThirdPartySourceRepository build() {
            return new ThirdPartySourceRepository(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
