/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codegurureviewer.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.codegurureviewer.model.CodeGuruReviewerRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeRecommendationFeedbackRequest
extends CodeGuruReviewerRequest
implements ToCopyableBuilder<Builder, DescribeRecommendationFeedbackRequest> {
    private static final SdkField<String> CODE_REVIEW_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(DescribeRecommendationFeedbackRequest.getter(DescribeRecommendationFeedbackRequest::codeReviewArn)).setter(DescribeRecommendationFeedbackRequest.setter(Builder::codeReviewArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("CodeReviewArn").build()}).build();
    private static final SdkField<String> RECOMMENDATION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(DescribeRecommendationFeedbackRequest.getter(DescribeRecommendationFeedbackRequest::recommendationId)).setter(DescribeRecommendationFeedbackRequest.setter(Builder::recommendationId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("RecommendationId").build()}).build();
    private static final SdkField<String> USER_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(DescribeRecommendationFeedbackRequest.getter(DescribeRecommendationFeedbackRequest::userId)).setter(DescribeRecommendationFeedbackRequest.setter(Builder::userId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("UserId").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CODE_REVIEW_ARN_FIELD, RECOMMENDATION_ID_FIELD, USER_ID_FIELD));
    private final String codeReviewArn;
    private final String recommendationId;
    private final String userId;

    private DescribeRecommendationFeedbackRequest(BuilderImpl builder) {
        super(builder);
        this.codeReviewArn = builder.codeReviewArn;
        this.recommendationId = builder.recommendationId;
        this.userId = builder.userId;
    }

    public String codeReviewArn() {
        return this.codeReviewArn;
    }

    public String recommendationId() {
        return this.recommendationId;
    }

    public String userId() {
        return this.userId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.codeReviewArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.recommendationId());
        hashCode = 31 * hashCode + Objects.hashCode(this.userId());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeRecommendationFeedbackRequest)) {
            return false;
        }
        DescribeRecommendationFeedbackRequest other = (DescribeRecommendationFeedbackRequest)((Object)obj);
        return Objects.equals(this.codeReviewArn(), other.codeReviewArn()) && Objects.equals(this.recommendationId(), other.recommendationId()) && Objects.equals(this.userId(), other.userId());
    }

    public String toString() {
        return ToString.builder((String)"DescribeRecommendationFeedbackRequest").add("CodeReviewArn", (Object)this.codeReviewArn()).add("RecommendationId", (Object)this.recommendationId()).add("UserId", (Object)this.userId()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "CodeReviewArn": {
                return Optional.ofNullable(clazz.cast(this.codeReviewArn()));
            }
            case "RecommendationId": {
                return Optional.ofNullable(clazz.cast(this.recommendationId()));
            }
            case "UserId": {
                return Optional.ofNullable(clazz.cast(this.userId()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeRecommendationFeedbackRequest, T> g) {
        return obj -> g.apply((DescribeRecommendationFeedbackRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends CodeGuruReviewerRequest.BuilderImpl
    implements Builder {
        private String codeReviewArn;
        private String recommendationId;
        private String userId;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeRecommendationFeedbackRequest model) {
            super(model);
            this.codeReviewArn(model.codeReviewArn);
            this.recommendationId(model.recommendationId);
            this.userId(model.userId);
        }

        public final String getCodeReviewArn() {
            return this.codeReviewArn;
        }

        @Override
        public final Builder codeReviewArn(String codeReviewArn) {
            this.codeReviewArn = codeReviewArn;
            return this;
        }

        public final void setCodeReviewArn(String codeReviewArn) {
            this.codeReviewArn = codeReviewArn;
        }

        public final String getRecommendationId() {
            return this.recommendationId;
        }

        @Override
        public final Builder recommendationId(String recommendationId) {
            this.recommendationId = recommendationId;
            return this;
        }

        public final void setRecommendationId(String recommendationId) {
            this.recommendationId = recommendationId;
        }

        public final String getUserId() {
            return this.userId;
        }

        @Override
        public final Builder userId(String userId) {
            this.userId = userId;
            return this;
        }

        public final void setUserId(String userId) {
            this.userId = userId;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DescribeRecommendationFeedbackRequest build() {
            return new DescribeRecommendationFeedbackRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends CodeGuruReviewerRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeRecommendationFeedbackRequest> {
        public Builder codeReviewArn(String var1);

        public Builder recommendationId(String var1);

        public Builder userId(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

