/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codeguruprofiler.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.codeguruprofiler.model.FrameMetric;
import software.amazon.awssdk.services.codeguruprofiler.model.FrameMetricValuesCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class FrameMetricDatum
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, FrameMetricDatum> {
    private static final SdkField<FrameMetric> FRAME_METRIC_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("frameMetric").getter(FrameMetricDatum.getter(FrameMetricDatum::frameMetric)).setter(FrameMetricDatum.setter(Builder::frameMetric)).constructor(FrameMetric::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("frameMetric").build()}).build();
    private static final SdkField<List<Double>> VALUES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("values").getter(FrameMetricDatum.getter(FrameMetricDatum::values)).setter(FrameMetricDatum.setter(Builder::values)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("values").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.DOUBLE).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FRAME_METRIC_FIELD, VALUES_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = FrameMetricDatum.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final FrameMetric frameMetric;
    private final List<Double> values;

    private FrameMetricDatum(BuilderImpl builder) {
        this.frameMetric = builder.frameMetric;
        this.values = builder.values;
    }

    public final FrameMetric frameMetric() {
        return this.frameMetric;
    }

    public final boolean hasValues() {
        return this.values != null && !(this.values instanceof SdkAutoConstructList);
    }

    public final List<Double> values() {
        return this.values;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.frameMetric());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasValues() ? this.values() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof FrameMetricDatum)) {
            return false;
        }
        FrameMetricDatum other = (FrameMetricDatum)obj;
        return Objects.equals(this.frameMetric(), other.frameMetric()) && this.hasValues() == other.hasValues() && Objects.equals(this.values(), other.values());
    }

    public final String toString() {
        return ToString.builder((String)"FrameMetricDatum").add("FrameMetric", (Object)this.frameMetric()).add("Values", this.hasValues() ? this.values() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "frameMetric": {
                return Optional.ofNullable(clazz.cast(this.frameMetric()));
            }
            case "values": {
                return Optional.ofNullable(clazz.cast(this.values()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("frameMetric", FRAME_METRIC_FIELD);
        map.put("values", VALUES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<FrameMetricDatum, T> g) {
        return obj -> g.apply((FrameMetricDatum)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private FrameMetric frameMetric;
        private List<Double> values = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(FrameMetricDatum model) {
            this.frameMetric(model.frameMetric);
            this.values(model.values);
        }

        public final FrameMetric.Builder getFrameMetric() {
            return this.frameMetric != null ? this.frameMetric.toBuilder() : null;
        }

        public final void setFrameMetric(FrameMetric.BuilderImpl frameMetric) {
            this.frameMetric = frameMetric != null ? frameMetric.build() : null;
        }

        @Override
        public final Builder frameMetric(FrameMetric frameMetric) {
            this.frameMetric = frameMetric;
            return this;
        }

        public final Collection<Double> getValues() {
            if (this.values instanceof SdkAutoConstructList) {
                return null;
            }
            return this.values;
        }

        public final void setValues(Collection<Double> values) {
            this.values = FrameMetricValuesCopier.copy(values);
        }

        @Override
        public final Builder values(Collection<Double> values) {
            this.values = FrameMetricValuesCopier.copy(values);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder values(Double ... values) {
            this.values(Arrays.asList(values));
            return this;
        }

        public FrameMetricDatum build() {
            return new FrameMetricDatum(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, FrameMetricDatum> {
        public Builder frameMetric(FrameMetric var1);

        default public Builder frameMetric(Consumer<FrameMetric.Builder> frameMetric) {
            return this.frameMetric((FrameMetric)((FrameMetric.Builder)FrameMetric.builder().applyMutation(frameMetric)).build());
        }

        public Builder values(Collection<Double> var1);

        public Builder values(Double ... var1);
    }
}

