/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codeguruprofiler.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.codeguruprofiler.model.MetricType;
import software.amazon.awssdk.services.codeguruprofiler.model.StringsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Metric
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Metric> {
    private static final SdkField<String> FRAME_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("frameName").getter(Metric.getter(Metric::frameName)).setter(Metric.setter(Builder::frameName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("frameName").build()}).build();
    private static final SdkField<List<String>> THREAD_STATES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("threadStates").getter(Metric.getter(Metric::threadStates)).setter(Metric.setter(Builder::threadStates)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("threadStates").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("type").getter(Metric.getter(Metric::typeAsString)).setter(Metric.setter(Builder::type)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("type").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FRAME_NAME_FIELD, THREAD_STATES_FIELD, TYPE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Metric.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String frameName;
    private final List<String> threadStates;
    private final String type;

    private Metric(BuilderImpl builder) {
        this.frameName = builder.frameName;
        this.threadStates = builder.threadStates;
        this.type = builder.type;
    }

    public final String frameName() {
        return this.frameName;
    }

    public final boolean hasThreadStates() {
        return this.threadStates != null && !(this.threadStates instanceof SdkAutoConstructList);
    }

    public final List<String> threadStates() {
        return this.threadStates;
    }

    public final MetricType type() {
        return MetricType.fromValue(this.type);
    }

    public final String typeAsString() {
        return this.type;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.frameName());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasThreadStates() ? this.threadStates() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.typeAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Metric)) {
            return false;
        }
        Metric other = (Metric)obj;
        return Objects.equals(this.frameName(), other.frameName()) && this.hasThreadStates() == other.hasThreadStates() && Objects.equals(this.threadStates(), other.threadStates()) && Objects.equals(this.typeAsString(), other.typeAsString());
    }

    public final String toString() {
        return ToString.builder((String)"Metric").add("FrameName", (Object)this.frameName()).add("ThreadStates", this.hasThreadStates() ? this.threadStates() : null).add("Type", (Object)this.typeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "frameName": {
                return Optional.ofNullable(clazz.cast(this.frameName()));
            }
            case "threadStates": {
                return Optional.ofNullable(clazz.cast(this.threadStates()));
            }
            case "type": {
                return Optional.ofNullable(clazz.cast(this.typeAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("frameName", FRAME_NAME_FIELD);
        map.put("threadStates", THREAD_STATES_FIELD);
        map.put("type", TYPE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<Metric, T> g) {
        return obj -> g.apply((Metric)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String frameName;
        private List<String> threadStates = DefaultSdkAutoConstructList.getInstance();
        private String type;

        private BuilderImpl() {
        }

        private BuilderImpl(Metric model) {
            this.frameName(model.frameName);
            this.threadStates(model.threadStates);
            this.type(model.type);
        }

        public final String getFrameName() {
            return this.frameName;
        }

        public final void setFrameName(String frameName) {
            this.frameName = frameName;
        }

        @Override
        public final Builder frameName(String frameName) {
            this.frameName = frameName;
            return this;
        }

        public final Collection<String> getThreadStates() {
            if (this.threadStates instanceof SdkAutoConstructList) {
                return null;
            }
            return this.threadStates;
        }

        public final void setThreadStates(Collection<String> threadStates) {
            this.threadStates = StringsCopier.copy(threadStates);
        }

        @Override
        public final Builder threadStates(Collection<String> threadStates) {
            this.threadStates = StringsCopier.copy(threadStates);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder threadStates(String ... threadStates) {
            this.threadStates(Arrays.asList(threadStates));
            return this;
        }

        public final String getType() {
            return this.type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(MetricType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        public Metric build() {
            return new Metric(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Metric> {
        public Builder frameName(String var1);

        public Builder threadStates(Collection<String> var1);

        public Builder threadStates(String ... var1);

        public Builder type(String var1);

        public Builder type(MetricType var1);
    }
}

