/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codeguruprofiler.paginators;

import java.util.concurrent.CompletableFuture;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.codeguruprofiler.CodeGuruProfilerAsyncClient;
import software.amazon.awssdk.services.codeguruprofiler.internal.UserAgentUtils;
import software.amazon.awssdk.services.codeguruprofiler.model.ListProfilingGroupsRequest;
import software.amazon.awssdk.services.codeguruprofiler.model.ListProfilingGroupsResponse;

public class ListProfilingGroupsPublisher
implements SdkPublisher<ListProfilingGroupsResponse> {
    private final CodeGuruProfilerAsyncClient client;
    private final ListProfilingGroupsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListProfilingGroupsPublisher(CodeGuruProfilerAsyncClient client, ListProfilingGroupsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListProfilingGroupsPublisher(CodeGuruProfilerAsyncClient client, ListProfilingGroupsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListProfilingGroupsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListProfilingGroupsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    private class ListProfilingGroupsResponseFetcher
    implements AsyncPageFetcher<ListProfilingGroupsResponse> {
        private ListProfilingGroupsResponseFetcher() {
        }

        public boolean hasNextPage(ListProfilingGroupsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListProfilingGroupsResponse> nextPage(ListProfilingGroupsResponse previousPage) {
            if (previousPage == null) {
                return ListProfilingGroupsPublisher.this.client.listProfilingGroups(ListProfilingGroupsPublisher.this.firstRequest);
            }
            return ListProfilingGroupsPublisher.this.client.listProfilingGroups((ListProfilingGroupsRequest)((Object)ListProfilingGroupsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

