/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codeguruprofiler.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.codeguruprofiler.model.EventPublisher;
import software.amazon.awssdk.services.codeguruprofiler.model.EventPublishersCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Channel
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Channel> {
    private static final SdkField<List<String>> EVENT_PUBLISHERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("eventPublishers").getter(Channel.getter(Channel::eventPublishersAsStrings)).setter(Channel.setter(Builder::eventPublishersWithStrings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("eventPublishers").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("id").getter(Channel.getter(Channel::id)).setter(Channel.setter(Builder::id)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("id").build()}).build();
    private static final SdkField<String> URI_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("uri").getter(Channel.getter(Channel::uri)).setter(Channel.setter(Builder::uri)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("uri").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(EVENT_PUBLISHERS_FIELD, ID_FIELD, URI_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("eventPublishers", EVENT_PUBLISHERS_FIELD);
            this.put("id", ID_FIELD);
            this.put("uri", URI_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final List<String> eventPublishers;
    private final String id;
    private final String uri;

    private Channel(BuilderImpl builder) {
        this.eventPublishers = builder.eventPublishers;
        this.id = builder.id;
        this.uri = builder.uri;
    }

    public final List<EventPublisher> eventPublishers() {
        return EventPublishersCopier.copyStringToEnum(this.eventPublishers);
    }

    public final boolean hasEventPublishers() {
        return this.eventPublishers != null && !(this.eventPublishers instanceof SdkAutoConstructList);
    }

    public final List<String> eventPublishersAsStrings() {
        return this.eventPublishers;
    }

    public final String id() {
        return this.id;
    }

    public final String uri() {
        return this.uri;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasEventPublishers() ? this.eventPublishersAsStrings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.id());
        hashCode = 31 * hashCode + Objects.hashCode(this.uri());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Channel)) {
            return false;
        }
        Channel other = (Channel)obj;
        return this.hasEventPublishers() == other.hasEventPublishers() && Objects.equals(this.eventPublishersAsStrings(), other.eventPublishersAsStrings()) && Objects.equals(this.id(), other.id()) && Objects.equals(this.uri(), other.uri());
    }

    public final String toString() {
        return ToString.builder((String)"Channel").add("EventPublishers", this.hasEventPublishers() ? this.eventPublishersAsStrings() : null).add("Id", (Object)this.id()).add("Uri", (Object)this.uri()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "eventPublishers": {
                return Optional.ofNullable(clazz.cast(this.eventPublishersAsStrings()));
            }
            case "id": {
                return Optional.ofNullable(clazz.cast(this.id()));
            }
            case "uri": {
                return Optional.ofNullable(clazz.cast(this.uri()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<Channel, T> g) {
        return obj -> g.apply((Channel)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<String> eventPublishers = DefaultSdkAutoConstructList.getInstance();
        private String id;
        private String uri;

        private BuilderImpl() {
        }

        private BuilderImpl(Channel model) {
            this.eventPublishersWithStrings(model.eventPublishers);
            this.id(model.id);
            this.uri(model.uri);
        }

        public final Collection<String> getEventPublishers() {
            if (this.eventPublishers instanceof SdkAutoConstructList) {
                return null;
            }
            return this.eventPublishers;
        }

        public final void setEventPublishers(Collection<String> eventPublishers) {
            this.eventPublishers = EventPublishersCopier.copy(eventPublishers);
        }

        @Override
        public final Builder eventPublishersWithStrings(Collection<String> eventPublishers) {
            this.eventPublishers = EventPublishersCopier.copy(eventPublishers);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder eventPublishersWithStrings(String ... eventPublishers) {
            this.eventPublishersWithStrings(Arrays.asList(eventPublishers));
            return this;
        }

        @Override
        public final Builder eventPublishers(Collection<EventPublisher> eventPublishers) {
            this.eventPublishers = EventPublishersCopier.copyEnumToString(eventPublishers);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder eventPublishers(EventPublisher ... eventPublishers) {
            this.eventPublishers(Arrays.asList(eventPublishers));
            return this;
        }

        public final String getId() {
            return this.id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final String getUri() {
            return this.uri;
        }

        public final void setUri(String uri) {
            this.uri = uri;
        }

        @Override
        public final Builder uri(String uri) {
            this.uri = uri;
            return this;
        }

        public Channel build() {
            return new Channel(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Channel> {
        public Builder eventPublishersWithStrings(Collection<String> var1);

        public Builder eventPublishersWithStrings(String ... var1);

        public Builder eventPublishers(Collection<EventPublisher> var1);

        public Builder eventPublishers(EventPublisher ... var1);

        public Builder id(String var1);

        public Builder uri(String var1);
    }
}

