/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codeguruprofiler.paginators;

import java.util.concurrent.CompletableFuture;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.codeguruprofiler.CodeGuruProfilerAsyncClient;
import software.amazon.awssdk.services.codeguruprofiler.internal.UserAgentUtils;
import software.amazon.awssdk.services.codeguruprofiler.model.ListFindingsReportsRequest;
import software.amazon.awssdk.services.codeguruprofiler.model.ListFindingsReportsResponse;

public class ListFindingsReportsPublisher
implements SdkPublisher<ListFindingsReportsResponse> {
    private final CodeGuruProfilerAsyncClient client;
    private final ListFindingsReportsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListFindingsReportsPublisher(CodeGuruProfilerAsyncClient client, ListFindingsReportsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListFindingsReportsPublisher(CodeGuruProfilerAsyncClient client, ListFindingsReportsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListFindingsReportsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListFindingsReportsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    private class ListFindingsReportsResponseFetcher
    implements AsyncPageFetcher<ListFindingsReportsResponse> {
        private ListFindingsReportsResponseFetcher() {
        }

        public boolean hasNextPage(ListFindingsReportsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListFindingsReportsResponse> nextPage(ListFindingsReportsResponse previousPage) {
            if (previousPage == null) {
                return ListFindingsReportsPublisher.this.client.listFindingsReports(ListFindingsReportsPublisher.this.firstRequest);
            }
            return ListFindingsReportsPublisher.this.client.listFindingsReports((ListFindingsReportsRequest)((Object)ListFindingsReportsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

