/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.codeguruprofiler.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The structure representing the BatchGetFrameMetricDataRequest.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class BatchGetFrameMetricDataRequest extends CodeGuruProfilerRequest implements
        ToCopyableBuilder<BatchGetFrameMetricDataRequest.Builder, BatchGetFrameMetricDataRequest> {
    private static final SdkField<Instant> END_TIME_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("endTime")
            .getter(getter(BatchGetFrameMetricDataRequest::endTime))
            .setter(setter(Builder::endTime))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("endTime").build(),
                    TimestampFormatTrait.create(TimestampFormatTrait.Format.ISO_8601)).build();

    private static final SdkField<List<FrameMetric>> FRAME_METRICS_FIELD = SdkField
            .<List<FrameMetric>> builder(MarshallingType.LIST)
            .memberName("frameMetrics")
            .getter(getter(BatchGetFrameMetricDataRequest::frameMetrics))
            .setter(setter(Builder::frameMetrics))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("frameMetrics").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<FrameMetric> builder(MarshallingType.SDK_POJO)
                                            .constructor(FrameMetric::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> PERIOD_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("period")
            .getter(getter(BatchGetFrameMetricDataRequest::period)).setter(setter(Builder::period))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("period").build()).build();

    private static final SdkField<String> PROFILING_GROUP_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("profilingGroupName").getter(getter(BatchGetFrameMetricDataRequest::profilingGroupName))
            .setter(setter(Builder::profilingGroupName))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("profilingGroupName").build()).build();

    private static final SdkField<Instant> START_TIME_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("startTime")
            .getter(getter(BatchGetFrameMetricDataRequest::startTime))
            .setter(setter(Builder::startTime))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("startTime").build(),
                    TimestampFormatTrait.create(TimestampFormatTrait.Format.ISO_8601)).build();

    private static final SdkField<String> TARGET_RESOLUTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("targetResolution").getter(getter(BatchGetFrameMetricDataRequest::targetResolutionAsString))
            .setter(setter(Builder::targetResolution))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("targetResolution").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(END_TIME_FIELD,
            FRAME_METRICS_FIELD, PERIOD_FIELD, PROFILING_GROUP_NAME_FIELD, START_TIME_FIELD, TARGET_RESOLUTION_FIELD));

    private final Instant endTime;

    private final List<FrameMetric> frameMetrics;

    private final String period;

    private final String profilingGroupName;

    private final Instant startTime;

    private final String targetResolution;

    private BatchGetFrameMetricDataRequest(BuilderImpl builder) {
        super(builder);
        this.endTime = builder.endTime;
        this.frameMetrics = builder.frameMetrics;
        this.period = builder.period;
        this.profilingGroupName = builder.profilingGroupName;
        this.startTime = builder.startTime;
        this.targetResolution = builder.targetResolution;
    }

    /**
     * <p>
     * The end time of the time period for the returned time series values. This is specified using the ISO 8601 format.
     * For example, 2020-06-01T13:15:02.001Z represents 1 millisecond past June 1, 2020 1:15:02 PM UTC.
     * </p>
     * 
     * @return The end time of the time period for the returned time series values. This is specified using the ISO 8601
     *         format. For example, 2020-06-01T13:15:02.001Z represents 1 millisecond past June 1, 2020 1:15:02 PM UTC.
     */
    public final Instant endTime() {
        return endTime;
    }

    /**
     * For responses, this returns true if the service returned a value for the FrameMetrics property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasFrameMetrics() {
        return frameMetrics != null && !(frameMetrics instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The details of the metrics that are used to request a time series of values. The metric includes the name of the
     * frame, the aggregation type to calculate the metric value for the frame, and the thread states to use to get the
     * count for the metric value of the frame.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasFrameMetrics} method.
     * </p>
     * 
     * @return The details of the metrics that are used to request a time series of values. The metric includes the name
     *         of the frame, the aggregation type to calculate the metric value for the frame, and the thread states to
     *         use to get the count for the metric value of the frame.
     */
    public final List<FrameMetric> frameMetrics() {
        return frameMetrics;
    }

    /**
     * <p>
     * The duration of the frame metrics used to return the time series values. Specify using the ISO 8601 format. The
     * maximum period duration is one day (<code>PT24H</code> or <code>P1D</code>).
     * </p>
     * 
     * @return The duration of the frame metrics used to return the time series values. Specify using the ISO 8601
     *         format. The maximum period duration is one day (<code>PT24H</code> or <code>P1D</code>).
     */
    public final String period() {
        return period;
    }

    /**
     * <p>
     * The name of the profiling group associated with the the frame metrics used to return the time series values.
     * </p>
     * 
     * @return The name of the profiling group associated with the the frame metrics used to return the time series
     *         values.
     */
    public final String profilingGroupName() {
        return profilingGroupName;
    }

    /**
     * <p>
     * The start time of the time period for the frame metrics used to return the time series values. This is specified
     * using the ISO 8601 format. For example, 2020-06-01T13:15:02.001Z represents 1 millisecond past June 1, 2020
     * 1:15:02 PM UTC.
     * </p>
     * 
     * @return The start time of the time period for the frame metrics used to return the time series values. This is
     *         specified using the ISO 8601 format. For example, 2020-06-01T13:15:02.001Z represents 1 millisecond past
     *         June 1, 2020 1:15:02 PM UTC.
     */
    public final Instant startTime() {
        return startTime;
    }

    /**
     * <p>
     * The requested resolution of time steps for the returned time series of values. If the requested target resolution
     * is not available due to data not being retained we provide a best effort result by falling back to the most
     * granular available resolution after the target resolution. There are 3 valid values.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>P1D</code> — 1 day
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>PT1H</code> — 1 hour
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>PT5M</code> — 5 minutes
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #targetResolution}
     * will return {@link AggregationPeriod#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #targetResolutionAsString}.
     * </p>
     * 
     * @return The requested resolution of time steps for the returned time series of values. If the requested target
     *         resolution is not available due to data not being retained we provide a best effort result by falling
     *         back to the most granular available resolution after the target resolution. There are 3 valid values.
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>P1D</code> — 1 day
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>PT1H</code> — 1 hour
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>PT5M</code> — 5 minutes
     *         </p>
     *         </li>
     * @see AggregationPeriod
     */
    public final AggregationPeriod targetResolution() {
        return AggregationPeriod.fromValue(targetResolution);
    }

    /**
     * <p>
     * The requested resolution of time steps for the returned time series of values. If the requested target resolution
     * is not available due to data not being retained we provide a best effort result by falling back to the most
     * granular available resolution after the target resolution. There are 3 valid values.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>P1D</code> — 1 day
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>PT1H</code> — 1 hour
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>PT5M</code> — 5 minutes
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #targetResolution}
     * will return {@link AggregationPeriod#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #targetResolutionAsString}.
     * </p>
     * 
     * @return The requested resolution of time steps for the returned time series of values. If the requested target
     *         resolution is not available due to data not being retained we provide a best effort result by falling
     *         back to the most granular available resolution after the target resolution. There are 3 valid values.
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>P1D</code> — 1 day
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>PT1H</code> — 1 hour
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>PT5M</code> — 5 minutes
     *         </p>
     *         </li>
     * @see AggregationPeriod
     */
    public final String targetResolutionAsString() {
        return targetResolution;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(endTime());
        hashCode = 31 * hashCode + Objects.hashCode(hasFrameMetrics() ? frameMetrics() : null);
        hashCode = 31 * hashCode + Objects.hashCode(period());
        hashCode = 31 * hashCode + Objects.hashCode(profilingGroupName());
        hashCode = 31 * hashCode + Objects.hashCode(startTime());
        hashCode = 31 * hashCode + Objects.hashCode(targetResolutionAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BatchGetFrameMetricDataRequest)) {
            return false;
        }
        BatchGetFrameMetricDataRequest other = (BatchGetFrameMetricDataRequest) obj;
        return Objects.equals(endTime(), other.endTime()) && hasFrameMetrics() == other.hasFrameMetrics()
                && Objects.equals(frameMetrics(), other.frameMetrics()) && Objects.equals(period(), other.period())
                && Objects.equals(profilingGroupName(), other.profilingGroupName())
                && Objects.equals(startTime(), other.startTime())
                && Objects.equals(targetResolutionAsString(), other.targetResolutionAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("BatchGetFrameMetricDataRequest").add("EndTime", endTime())
                .add("FrameMetrics", hasFrameMetrics() ? frameMetrics() : null).add("Period", period())
                .add("ProfilingGroupName", profilingGroupName()).add("StartTime", startTime())
                .add("TargetResolution", targetResolutionAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "endTime":
            return Optional.ofNullable(clazz.cast(endTime()));
        case "frameMetrics":
            return Optional.ofNullable(clazz.cast(frameMetrics()));
        case "period":
            return Optional.ofNullable(clazz.cast(period()));
        case "profilingGroupName":
            return Optional.ofNullable(clazz.cast(profilingGroupName()));
        case "startTime":
            return Optional.ofNullable(clazz.cast(startTime()));
        case "targetResolution":
            return Optional.ofNullable(clazz.cast(targetResolutionAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<BatchGetFrameMetricDataRequest, T> g) {
        return obj -> g.apply((BatchGetFrameMetricDataRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends CodeGuruProfilerRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, BatchGetFrameMetricDataRequest> {
        /**
         * <p>
         * The end time of the time period for the returned time series values. This is specified using the ISO 8601
         * format. For example, 2020-06-01T13:15:02.001Z represents 1 millisecond past June 1, 2020 1:15:02 PM UTC.
         * </p>
         * 
         * @param endTime
         *        The end time of the time period for the returned time series values. This is specified using the ISO
         *        8601 format. For example, 2020-06-01T13:15:02.001Z represents 1 millisecond past June 1, 2020 1:15:02
         *        PM UTC.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder endTime(Instant endTime);

        /**
         * <p>
         * The details of the metrics that are used to request a time series of values. The metric includes the name of
         * the frame, the aggregation type to calculate the metric value for the frame, and the thread states to use to
         * get the count for the metric value of the frame.
         * </p>
         * 
         * @param frameMetrics
         *        The details of the metrics that are used to request a time series of values. The metric includes the
         *        name of the frame, the aggregation type to calculate the metric value for the frame, and the thread
         *        states to use to get the count for the metric value of the frame.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder frameMetrics(Collection<FrameMetric> frameMetrics);

        /**
         * <p>
         * The details of the metrics that are used to request a time series of values. The metric includes the name of
         * the frame, the aggregation type to calculate the metric value for the frame, and the thread states to use to
         * get the count for the metric value of the frame.
         * </p>
         * 
         * @param frameMetrics
         *        The details of the metrics that are used to request a time series of values. The metric includes the
         *        name of the frame, the aggregation type to calculate the metric value for the frame, and the thread
         *        states to use to get the count for the metric value of the frame.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder frameMetrics(FrameMetric... frameMetrics);

        /**
         * <p>
         * The details of the metrics that are used to request a time series of values. The metric includes the name of
         * the frame, the aggregation type to calculate the metric value for the frame, and the thread states to use to
         * get the count for the metric value of the frame.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.codeguruprofiler.model.FrameMetric.Builder} avoiding the need to
         * create one manually via {@link software.amazon.awssdk.services.codeguruprofiler.model.FrameMetric#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.codeguruprofiler.model.FrameMetric.Builder#build()} is called
         * immediately and its result is passed to {@link #frameMetrics(List<FrameMetric>)}.
         * 
         * @param frameMetrics
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.codeguruprofiler.model.FrameMetric.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #frameMetrics(java.util.Collection<FrameMetric>)
         */
        Builder frameMetrics(Consumer<FrameMetric.Builder>... frameMetrics);

        /**
         * <p>
         * The duration of the frame metrics used to return the time series values. Specify using the ISO 8601 format.
         * The maximum period duration is one day (<code>PT24H</code> or <code>P1D</code>).
         * </p>
         * 
         * @param period
         *        The duration of the frame metrics used to return the time series values. Specify using the ISO 8601
         *        format. The maximum period duration is one day (<code>PT24H</code> or <code>P1D</code>).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder period(String period);

        /**
         * <p>
         * The name of the profiling group associated with the the frame metrics used to return the time series values.
         * </p>
         * 
         * @param profilingGroupName
         *        The name of the profiling group associated with the the frame metrics used to return the time series
         *        values.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder profilingGroupName(String profilingGroupName);

        /**
         * <p>
         * The start time of the time period for the frame metrics used to return the time series values. This is
         * specified using the ISO 8601 format. For example, 2020-06-01T13:15:02.001Z represents 1 millisecond past June
         * 1, 2020 1:15:02 PM UTC.
         * </p>
         * 
         * @param startTime
         *        The start time of the time period for the frame metrics used to return the time series values. This is
         *        specified using the ISO 8601 format. For example, 2020-06-01T13:15:02.001Z represents 1 millisecond
         *        past June 1, 2020 1:15:02 PM UTC.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder startTime(Instant startTime);

        /**
         * <p>
         * The requested resolution of time steps for the returned time series of values. If the requested target
         * resolution is not available due to data not being retained we provide a best effort result by falling back to
         * the most granular available resolution after the target resolution. There are 3 valid values.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>P1D</code> — 1 day
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>PT1H</code> — 1 hour
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>PT5M</code> — 5 minutes
         * </p>
         * </li>
         * </ul>
         * 
         * @param targetResolution
         *        The requested resolution of time steps for the returned time series of values. If the requested target
         *        resolution is not available due to data not being retained we provide a best effort result by falling
         *        back to the most granular available resolution after the target resolution. There are 3 valid values.
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>P1D</code> — 1 day
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>PT1H</code> — 1 hour
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>PT5M</code> — 5 minutes
         *        </p>
         *        </li>
         * @see AggregationPeriod
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AggregationPeriod
         */
        Builder targetResolution(String targetResolution);

        /**
         * <p>
         * The requested resolution of time steps for the returned time series of values. If the requested target
         * resolution is not available due to data not being retained we provide a best effort result by falling back to
         * the most granular available resolution after the target resolution. There are 3 valid values.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>P1D</code> — 1 day
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>PT1H</code> — 1 hour
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>PT5M</code> — 5 minutes
         * </p>
         * </li>
         * </ul>
         * 
         * @param targetResolution
         *        The requested resolution of time steps for the returned time series of values. If the requested target
         *        resolution is not available due to data not being retained we provide a best effort result by falling
         *        back to the most granular available resolution after the target resolution. There are 3 valid values.
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>P1D</code> — 1 day
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>PT1H</code> — 1 hour
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>PT5M</code> — 5 minutes
         *        </p>
         *        </li>
         * @see AggregationPeriod
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AggregationPeriod
         */
        Builder targetResolution(AggregationPeriod targetResolution);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends CodeGuruProfilerRequest.BuilderImpl implements Builder {
        private Instant endTime;

        private List<FrameMetric> frameMetrics = DefaultSdkAutoConstructList.getInstance();

        private String period;

        private String profilingGroupName;

        private Instant startTime;

        private String targetResolution;

        private BuilderImpl() {
        }

        private BuilderImpl(BatchGetFrameMetricDataRequest model) {
            super(model);
            endTime(model.endTime);
            frameMetrics(model.frameMetrics);
            period(model.period);
            profilingGroupName(model.profilingGroupName);
            startTime(model.startTime);
            targetResolution(model.targetResolution);
        }

        public final Instant getEndTime() {
            return endTime;
        }

        public final void setEndTime(Instant endTime) {
            this.endTime = endTime;
        }

        @Override
        public final Builder endTime(Instant endTime) {
            this.endTime = endTime;
            return this;
        }

        public final List<FrameMetric.Builder> getFrameMetrics() {
            List<FrameMetric.Builder> result = FrameMetricsCopier.copyToBuilder(this.frameMetrics);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setFrameMetrics(Collection<FrameMetric.BuilderImpl> frameMetrics) {
            this.frameMetrics = FrameMetricsCopier.copyFromBuilder(frameMetrics);
        }

        @Override
        public final Builder frameMetrics(Collection<FrameMetric> frameMetrics) {
            this.frameMetrics = FrameMetricsCopier.copy(frameMetrics);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder frameMetrics(FrameMetric... frameMetrics) {
            frameMetrics(Arrays.asList(frameMetrics));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder frameMetrics(Consumer<FrameMetric.Builder>... frameMetrics) {
            frameMetrics(Stream.of(frameMetrics).map(c -> FrameMetric.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getPeriod() {
            return period;
        }

        public final void setPeriod(String period) {
            this.period = period;
        }

        @Override
        public final Builder period(String period) {
            this.period = period;
            return this;
        }

        public final String getProfilingGroupName() {
            return profilingGroupName;
        }

        public final void setProfilingGroupName(String profilingGroupName) {
            this.profilingGroupName = profilingGroupName;
        }

        @Override
        public final Builder profilingGroupName(String profilingGroupName) {
            this.profilingGroupName = profilingGroupName;
            return this;
        }

        public final Instant getStartTime() {
            return startTime;
        }

        public final void setStartTime(Instant startTime) {
            this.startTime = startTime;
        }

        @Override
        public final Builder startTime(Instant startTime) {
            this.startTime = startTime;
            return this;
        }

        public final String getTargetResolution() {
            return targetResolution;
        }

        public final void setTargetResolution(String targetResolution) {
            this.targetResolution = targetResolution;
        }

        @Override
        public final Builder targetResolution(String targetResolution) {
            this.targetResolution = targetResolution;
            return this;
        }

        @Override
        public final Builder targetResolution(AggregationPeriod targetResolution) {
            this.targetResolution(targetResolution == null ? null : targetResolution.toString());
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public BatchGetFrameMetricDataRequest build() {
            return new BatchGetFrameMetricDataRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
