/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codeguruprofiler;

import java.net.URI;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.client.config.AwsClientOption;
import software.amazon.awssdk.core.client.config.ClientOption;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.codeguruprofiler.CodeGuruProfilerClient;
import software.amazon.awssdk.services.codeguruprofiler.CodeGuruProfilerClientBuilder;
import software.amazon.awssdk.services.codeguruprofiler.CodeGuruProfilerServiceClientConfiguration;
import software.amazon.awssdk.services.codeguruprofiler.DefaultCodeGuruProfilerBaseClientBuilder;
import software.amazon.awssdk.services.codeguruprofiler.DefaultCodeGuruProfilerClient;
import software.amazon.awssdk.services.codeguruprofiler.endpoints.CodeGuruProfilerEndpointProvider;

@SdkInternalApi
final class DefaultCodeGuruProfilerClientBuilder
extends DefaultCodeGuruProfilerBaseClientBuilder<CodeGuruProfilerClientBuilder, CodeGuruProfilerClient>
implements CodeGuruProfilerClientBuilder {
    DefaultCodeGuruProfilerClientBuilder() {
    }

    @Override
    public DefaultCodeGuruProfilerClientBuilder endpointProvider(CodeGuruProfilerEndpointProvider endpointProvider) {
        this.clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_PROVIDER, (Object)endpointProvider);
        return this;
    }

    protected final CodeGuruProfilerClient buildClient() {
        SdkClientConfiguration clientConfiguration = super.syncClientConfiguration();
        DefaultCodeGuruProfilerClientBuilder.validateClientOptions(clientConfiguration);
        URI endpointOverride = null;
        if (clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_OVERRIDDEN) != null && Boolean.TRUE.equals(clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_OVERRIDDEN))) {
            endpointOverride = (URI)clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT);
        }
        CodeGuruProfilerServiceClientConfiguration serviceClientConfiguration = CodeGuruProfilerServiceClientConfiguration.builder().overrideConfiguration(this.overrideConfiguration()).region((Region)clientConfiguration.option((ClientOption)AwsClientOption.AWS_REGION)).endpointOverride(endpointOverride).build();
        return new DefaultCodeGuruProfilerClient(serviceClientConfiguration, clientConfiguration);
    }
}

