/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codeguruprofiler;

import java.net.URI;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.client.config.AwsClientOption;
import software.amazon.awssdk.core.client.config.ClientOption;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.endpoints.EndpointProvider;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.codeguruprofiler.CodeGuruProfilerClient;
import software.amazon.awssdk.services.codeguruprofiler.CodeGuruProfilerClientBuilder;
import software.amazon.awssdk.services.codeguruprofiler.CodeGuruProfilerServiceClientConfiguration;
import software.amazon.awssdk.services.codeguruprofiler.DefaultCodeGuruProfilerBaseClientBuilder;
import software.amazon.awssdk.services.codeguruprofiler.DefaultCodeGuruProfilerClient;
import software.amazon.awssdk.services.codeguruprofiler.endpoints.CodeGuruProfilerEndpointProvider;

@SdkInternalApi
final class DefaultCodeGuruProfilerClientBuilder
extends DefaultCodeGuruProfilerBaseClientBuilder<CodeGuruProfilerClientBuilder, CodeGuruProfilerClient>
implements CodeGuruProfilerClientBuilder {
    DefaultCodeGuruProfilerClientBuilder() {
    }

    @Override
    public DefaultCodeGuruProfilerClientBuilder endpointProvider(CodeGuruProfilerEndpointProvider endpointProvider) {
        this.clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_PROVIDER, (Object)endpointProvider);
        return this;
    }

    protected final CodeGuruProfilerClient buildClient() {
        SdkClientConfiguration clientConfiguration = super.syncClientConfiguration();
        DefaultCodeGuruProfilerClientBuilder.validateClientOptions(clientConfiguration);
        CodeGuruProfilerServiceClientConfiguration serviceClientConfiguration = this.initializeServiceClientConfig(clientConfiguration);
        DefaultCodeGuruProfilerClient client = new DefaultCodeGuruProfilerClient(serviceClientConfiguration, clientConfiguration);
        return client;
    }

    private CodeGuruProfilerServiceClientConfiguration initializeServiceClientConfig(SdkClientConfiguration clientConfig) {
        URI endpointOverride = null;
        EndpointProvider endpointProvider = (EndpointProvider)clientConfig.option((ClientOption)SdkClientOption.ENDPOINT_PROVIDER);
        if (clientConfig.option((ClientOption)SdkClientOption.ENDPOINT_OVERRIDDEN) != null && Boolean.TRUE.equals(clientConfig.option((ClientOption)SdkClientOption.ENDPOINT_OVERRIDDEN))) {
            endpointOverride = (URI)clientConfig.option((ClientOption)SdkClientOption.ENDPOINT);
        }
        return CodeGuruProfilerServiceClientConfiguration.builder().overrideConfiguration(this.overrideConfiguration()).region((Region)clientConfig.option((ClientOption)AwsClientOption.AWS_REGION)).endpointOverride(endpointOverride).endpointProvider(endpointProvider).build();
    }
}

