/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codeguruprofiler.model;

import java.beans.Transient;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.codeguruprofiler.model.AggregationPeriod;
import software.amazon.awssdk.services.codeguruprofiler.model.CodeGuruProfilerRequest;
import software.amazon.awssdk.services.codeguruprofiler.model.FrameMetric;
import software.amazon.awssdk.services.codeguruprofiler.model.FrameMetricsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class BatchGetFrameMetricDataRequest
extends CodeGuruProfilerRequest
implements ToCopyableBuilder<Builder, BatchGetFrameMetricDataRequest> {
    private static final SdkField<Instant> END_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("endTime").getter(BatchGetFrameMetricDataRequest.getter(BatchGetFrameMetricDataRequest::endTime)).setter(BatchGetFrameMetricDataRequest.setter(Builder::endTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("endTime").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.ISO_8601)}).build();
    private static final SdkField<List<FrameMetric>> FRAME_METRICS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("frameMetrics").getter(BatchGetFrameMetricDataRequest.getter(BatchGetFrameMetricDataRequest::frameMetrics)).setter(BatchGetFrameMetricDataRequest.setter(Builder::frameMetrics)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("frameMetrics").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(FrameMetric::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> PERIOD_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("period").getter(BatchGetFrameMetricDataRequest.getter(BatchGetFrameMetricDataRequest::period)).setter(BatchGetFrameMetricDataRequest.setter(Builder::period)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("period").build()}).build();
    private static final SdkField<String> PROFILING_GROUP_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("profilingGroupName").getter(BatchGetFrameMetricDataRequest.getter(BatchGetFrameMetricDataRequest::profilingGroupName)).setter(BatchGetFrameMetricDataRequest.setter(Builder::profilingGroupName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("profilingGroupName").build()}).build();
    private static final SdkField<Instant> START_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("startTime").getter(BatchGetFrameMetricDataRequest.getter(BatchGetFrameMetricDataRequest::startTime)).setter(BatchGetFrameMetricDataRequest.setter(Builder::startTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("startTime").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.ISO_8601)}).build();
    private static final SdkField<String> TARGET_RESOLUTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("targetResolution").getter(BatchGetFrameMetricDataRequest.getter(BatchGetFrameMetricDataRequest::targetResolutionAsString)).setter(BatchGetFrameMetricDataRequest.setter(Builder::targetResolution)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("targetResolution").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(END_TIME_FIELD, FRAME_METRICS_FIELD, PERIOD_FIELD, PROFILING_GROUP_NAME_FIELD, START_TIME_FIELD, TARGET_RESOLUTION_FIELD));
    private final Instant endTime;
    private final List<FrameMetric> frameMetrics;
    private final String period;
    private final String profilingGroupName;
    private final Instant startTime;
    private final String targetResolution;

    private BatchGetFrameMetricDataRequest(BuilderImpl builder) {
        super(builder);
        this.endTime = builder.endTime;
        this.frameMetrics = builder.frameMetrics;
        this.period = builder.period;
        this.profilingGroupName = builder.profilingGroupName;
        this.startTime = builder.startTime;
        this.targetResolution = builder.targetResolution;
    }

    public final Instant endTime() {
        return this.endTime;
    }

    public final boolean hasFrameMetrics() {
        return this.frameMetrics != null && !(this.frameMetrics instanceof SdkAutoConstructList);
    }

    public final List<FrameMetric> frameMetrics() {
        return this.frameMetrics;
    }

    public final String period() {
        return this.period;
    }

    public final String profilingGroupName() {
        return this.profilingGroupName;
    }

    public final Instant startTime() {
        return this.startTime;
    }

    public final AggregationPeriod targetResolution() {
        return AggregationPeriod.fromValue(this.targetResolution);
    }

    public final String targetResolutionAsString() {
        return this.targetResolution;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.endTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasFrameMetrics() ? this.frameMetrics() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.period());
        hashCode = 31 * hashCode + Objects.hashCode(this.profilingGroupName());
        hashCode = 31 * hashCode + Objects.hashCode(this.startTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.targetResolutionAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BatchGetFrameMetricDataRequest)) {
            return false;
        }
        BatchGetFrameMetricDataRequest other = (BatchGetFrameMetricDataRequest)((Object)obj);
        return Objects.equals(this.endTime(), other.endTime()) && this.hasFrameMetrics() == other.hasFrameMetrics() && Objects.equals(this.frameMetrics(), other.frameMetrics()) && Objects.equals(this.period(), other.period()) && Objects.equals(this.profilingGroupName(), other.profilingGroupName()) && Objects.equals(this.startTime(), other.startTime()) && Objects.equals(this.targetResolutionAsString(), other.targetResolutionAsString());
    }

    public final String toString() {
        return ToString.builder((String)"BatchGetFrameMetricDataRequest").add("EndTime", (Object)this.endTime()).add("FrameMetrics", this.hasFrameMetrics() ? this.frameMetrics() : null).add("Period", (Object)this.period()).add("ProfilingGroupName", (Object)this.profilingGroupName()).add("StartTime", (Object)this.startTime()).add("TargetResolution", (Object)this.targetResolutionAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "endTime": {
                return Optional.ofNullable(clazz.cast(this.endTime()));
            }
            case "frameMetrics": {
                return Optional.ofNullable(clazz.cast(this.frameMetrics()));
            }
            case "period": {
                return Optional.ofNullable(clazz.cast(this.period()));
            }
            case "profilingGroupName": {
                return Optional.ofNullable(clazz.cast(this.profilingGroupName()));
            }
            case "startTime": {
                return Optional.ofNullable(clazz.cast(this.startTime()));
            }
            case "targetResolution": {
                return Optional.ofNullable(clazz.cast(this.targetResolutionAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<BatchGetFrameMetricDataRequest, T> g) {
        return obj -> g.apply((BatchGetFrameMetricDataRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends CodeGuruProfilerRequest.BuilderImpl
    implements Builder {
        private Instant endTime;
        private List<FrameMetric> frameMetrics = DefaultSdkAutoConstructList.getInstance();
        private String period;
        private String profilingGroupName;
        private Instant startTime;
        private String targetResolution;

        private BuilderImpl() {
        }

        private BuilderImpl(BatchGetFrameMetricDataRequest model) {
            super(model);
            this.endTime(model.endTime);
            this.frameMetrics(model.frameMetrics);
            this.period(model.period);
            this.profilingGroupName(model.profilingGroupName);
            this.startTime(model.startTime);
            this.targetResolution(model.targetResolution);
        }

        public final Instant getEndTime() {
            return this.endTime;
        }

        public final void setEndTime(Instant endTime) {
            this.endTime = endTime;
        }

        @Override
        @Transient
        public final Builder endTime(Instant endTime) {
            this.endTime = endTime;
            return this;
        }

        public final List<FrameMetric.Builder> getFrameMetrics() {
            List<FrameMetric.Builder> result = FrameMetricsCopier.copyToBuilder(this.frameMetrics);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setFrameMetrics(Collection<FrameMetric.BuilderImpl> frameMetrics) {
            this.frameMetrics = FrameMetricsCopier.copyFromBuilder(frameMetrics);
        }

        @Override
        @Transient
        public final Builder frameMetrics(Collection<FrameMetric> frameMetrics) {
            this.frameMetrics = FrameMetricsCopier.copy(frameMetrics);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder frameMetrics(FrameMetric ... frameMetrics) {
            this.frameMetrics(Arrays.asList(frameMetrics));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder frameMetrics(Consumer<FrameMetric.Builder> ... frameMetrics) {
            this.frameMetrics(Stream.of(frameMetrics).map(c -> (FrameMetric)((FrameMetric.Builder)FrameMetric.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getPeriod() {
            return this.period;
        }

        public final void setPeriod(String period) {
            this.period = period;
        }

        @Override
        @Transient
        public final Builder period(String period) {
            this.period = period;
            return this;
        }

        public final String getProfilingGroupName() {
            return this.profilingGroupName;
        }

        public final void setProfilingGroupName(String profilingGroupName) {
            this.profilingGroupName = profilingGroupName;
        }

        @Override
        @Transient
        public final Builder profilingGroupName(String profilingGroupName) {
            this.profilingGroupName = profilingGroupName;
            return this;
        }

        public final Instant getStartTime() {
            return this.startTime;
        }

        public final void setStartTime(Instant startTime) {
            this.startTime = startTime;
        }

        @Override
        @Transient
        public final Builder startTime(Instant startTime) {
            this.startTime = startTime;
            return this;
        }

        public final String getTargetResolution() {
            return this.targetResolution;
        }

        public final void setTargetResolution(String targetResolution) {
            this.targetResolution = targetResolution;
        }

        @Override
        @Transient
        public final Builder targetResolution(String targetResolution) {
            this.targetResolution = targetResolution;
            return this;
        }

        @Override
        @Transient
        public final Builder targetResolution(AggregationPeriod targetResolution) {
            this.targetResolution(targetResolution == null ? null : targetResolution.toString());
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public BatchGetFrameMetricDataRequest build() {
            return new BatchGetFrameMetricDataRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends CodeGuruProfilerRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, BatchGetFrameMetricDataRequest> {
        public Builder endTime(Instant var1);

        public Builder frameMetrics(Collection<FrameMetric> var1);

        public Builder frameMetrics(FrameMetric ... var1);

        public Builder frameMetrics(Consumer<FrameMetric.Builder> ... var1);

        public Builder period(String var1);

        public Builder profilingGroupName(String var1);

        public Builder startTime(Instant var1);

        public Builder targetResolution(String var1);

        public Builder targetResolution(AggregationPeriod var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

