/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codeguruprofiler.paginators;

import java.util.Iterator;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.codeguruprofiler.CodeGuruProfilerClient;
import software.amazon.awssdk.services.codeguruprofiler.model.ListFindingsReportsRequest;
import software.amazon.awssdk.services.codeguruprofiler.model.ListFindingsReportsResponse;

public class ListFindingsReportsIterable
implements SdkIterable<ListFindingsReportsResponse> {
    private final CodeGuruProfilerClient client;
    private final ListFindingsReportsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListFindingsReportsIterable(CodeGuruProfilerClient client, ListFindingsReportsRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new ListFindingsReportsResponseFetcher();
    }

    public Iterator<ListFindingsReportsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    private class ListFindingsReportsResponseFetcher
    implements SyncPageFetcher<ListFindingsReportsResponse> {
        private ListFindingsReportsResponseFetcher() {
        }

        public boolean hasNextPage(ListFindingsReportsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListFindingsReportsResponse nextPage(ListFindingsReportsResponse previousPage) {
            if (previousPage == null) {
                return ListFindingsReportsIterable.this.client.listFindingsReports(ListFindingsReportsIterable.this.firstRequest);
            }
            return ListFindingsReportsIterable.this.client.listFindingsReports((ListFindingsReportsRequest)((Object)ListFindingsReportsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

