/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.codeguruprofiler.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The structure representing the listProfilingGroupsResponse.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListProfilingGroupsResponse extends CodeGuruProfilerResponse implements
        ToCopyableBuilder<ListProfilingGroupsResponse.Builder, ListProfilingGroupsResponse> {
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("nextToken").getter(getter(ListProfilingGroupsResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()).build();

    private static final SdkField<List<String>> PROFILING_GROUP_NAMES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("profilingGroupNames")
            .getter(getter(ListProfilingGroupsResponse::profilingGroupNames))
            .setter(setter(Builder::profilingGroupNames))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("profilingGroupNames").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<ProfilingGroupDescription>> PROFILING_GROUPS_FIELD = SdkField
            .<List<ProfilingGroupDescription>> builder(MarshallingType.LIST)
            .memberName("profilingGroups")
            .getter(getter(ListProfilingGroupsResponse::profilingGroups))
            .setter(setter(Builder::profilingGroups))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("profilingGroups").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ProfilingGroupDescription> builder(MarshallingType.SDK_POJO)
                                            .constructor(ProfilingGroupDescription::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NEXT_TOKEN_FIELD,
            PROFILING_GROUP_NAMES_FIELD, PROFILING_GROUPS_FIELD));

    private final String nextToken;

    private final List<String> profilingGroupNames;

    private final List<ProfilingGroupDescription> profilingGroups;

    private ListProfilingGroupsResponse(BuilderImpl builder) {
        super(builder);
        this.nextToken = builder.nextToken;
        this.profilingGroupNames = builder.profilingGroupNames;
        this.profilingGroups = builder.profilingGroups;
    }

    /**
     * <p>
     * The <code>nextToken</code> value to include in a future <code>ListProfilingGroups</code> request. When the
     * results of a <code>ListProfilingGroups</code> request exceed <code>maxResults</code>, this value can be used to
     * retrieve the next page of results. This value is <code>null</code> when there are no more results to return.
     * </p>
     * 
     * @return The <code>nextToken</code> value to include in a future <code>ListProfilingGroups</code> request. When
     *         the results of a <code>ListProfilingGroups</code> request exceed <code>maxResults</code>, this value can
     *         be used to retrieve the next page of results. This value is <code>null</code> when there are no more
     *         results to return.
     */
    public final String nextToken() {
        return nextToken;
    }

    /**
     * Returns true if the ProfilingGroupNames property was specified by the sender (it may be empty), or false if the
     * sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public final boolean hasProfilingGroupNames() {
        return profilingGroupNames != null && !(profilingGroupNames instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A returned list of profiling group names. A list of the names is returned only if <code>includeDescription</code>
     * is <code>false</code>, otherwise a list of <a
     * href="https://docs.aws.amazon.com/codeguru/latest/profiler-api/API_ProfilingGroupDescription.html">
     * <code>ProfilingGroupDescription</code> </a> objects is returned.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasProfilingGroupNames()} to see if a value was sent in this field.
     * </p>
     * 
     * @return A returned list of profiling group names. A list of the names is returned only if
     *         <code>includeDescription</code> is <code>false</code>, otherwise a list of <a
     *         href="https://docs.aws.amazon.com/codeguru/latest/profiler-api/API_ProfilingGroupDescription.html">
     *         <code>ProfilingGroupDescription</code> </a> objects is returned.
     */
    public final List<String> profilingGroupNames() {
        return profilingGroupNames;
    }

    /**
     * Returns true if the ProfilingGroups property was specified by the sender (it may be empty), or false if the
     * sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public final boolean hasProfilingGroups() {
        return profilingGroups != null && !(profilingGroups instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A returned list <a
     * href="https://docs.aws.amazon.com/codeguru/latest/profiler-api/API_ProfilingGroupDescription.html">
     * <code>ProfilingGroupDescription</code> </a> objects. A list of <a
     * href="https://docs.aws.amazon.com/codeguru/latest/profiler-api/API_ProfilingGroupDescription.html">
     * <code>ProfilingGroupDescription</code> </a> objects is returned only if <code>includeDescription</code> is
     * <code>true</code>, otherwise a list of profiling group names is returned.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasProfilingGroups()} to see if a value was sent in this field.
     * </p>
     * 
     * @return A returned list <a
     *         href="https://docs.aws.amazon.com/codeguru/latest/profiler-api/API_ProfilingGroupDescription.html">
     *         <code>ProfilingGroupDescription</code> </a> objects. A list of <a
     *         href="https://docs.aws.amazon.com/codeguru/latest/profiler-api/API_ProfilingGroupDescription.html">
     *         <code>ProfilingGroupDescription</code> </a> objects is returned only if <code>includeDescription</code>
     *         is <code>true</code>, otherwise a list of profiling group names is returned.
     */
    public final List<ProfilingGroupDescription> profilingGroups() {
        return profilingGroups;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(hasProfilingGroupNames() ? profilingGroupNames() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasProfilingGroups() ? profilingGroups() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListProfilingGroupsResponse)) {
            return false;
        }
        ListProfilingGroupsResponse other = (ListProfilingGroupsResponse) obj;
        return Objects.equals(nextToken(), other.nextToken()) && hasProfilingGroupNames() == other.hasProfilingGroupNames()
                && Objects.equals(profilingGroupNames(), other.profilingGroupNames())
                && hasProfilingGroups() == other.hasProfilingGroups()
                && Objects.equals(profilingGroups(), other.profilingGroups());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListProfilingGroupsResponse").add("NextToken", nextToken())
                .add("ProfilingGroupNames", hasProfilingGroupNames() ? profilingGroupNames() : null)
                .add("ProfilingGroups", hasProfilingGroups() ? profilingGroups() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "nextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "profilingGroupNames":
            return Optional.ofNullable(clazz.cast(profilingGroupNames()));
        case "profilingGroups":
            return Optional.ofNullable(clazz.cast(profilingGroups()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListProfilingGroupsResponse, T> g) {
        return obj -> g.apply((ListProfilingGroupsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends CodeGuruProfilerResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, ListProfilingGroupsResponse> {
        /**
         * <p>
         * The <code>nextToken</code> value to include in a future <code>ListProfilingGroups</code> request. When the
         * results of a <code>ListProfilingGroups</code> request exceed <code>maxResults</code>, this value can be used
         * to retrieve the next page of results. This value is <code>null</code> when there are no more results to
         * return.
         * </p>
         * 
         * @param nextToken
         *        The <code>nextToken</code> value to include in a future <code>ListProfilingGroups</code> request. When
         *        the results of a <code>ListProfilingGroups</code> request exceed <code>maxResults</code>, this value
         *        can be used to retrieve the next page of results. This value is <code>null</code> when there are no
         *        more results to return.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * A returned list of profiling group names. A list of the names is returned only if
         * <code>includeDescription</code> is <code>false</code>, otherwise a list of <a
         * href="https://docs.aws.amazon.com/codeguru/latest/profiler-api/API_ProfilingGroupDescription.html">
         * <code>ProfilingGroupDescription</code> </a> objects is returned.
         * </p>
         * 
         * @param profilingGroupNames
         *        A returned list of profiling group names. A list of the names is returned only if
         *        <code>includeDescription</code> is <code>false</code>, otherwise a list of <a
         *        href="https://docs.aws.amazon.com/codeguru/latest/profiler-api/API_ProfilingGroupDescription.html">
         *        <code>ProfilingGroupDescription</code> </a> objects is returned.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder profilingGroupNames(Collection<String> profilingGroupNames);

        /**
         * <p>
         * A returned list of profiling group names. A list of the names is returned only if
         * <code>includeDescription</code> is <code>false</code>, otherwise a list of <a
         * href="https://docs.aws.amazon.com/codeguru/latest/profiler-api/API_ProfilingGroupDescription.html">
         * <code>ProfilingGroupDescription</code> </a> objects is returned.
         * </p>
         * 
         * @param profilingGroupNames
         *        A returned list of profiling group names. A list of the names is returned only if
         *        <code>includeDescription</code> is <code>false</code>, otherwise a list of <a
         *        href="https://docs.aws.amazon.com/codeguru/latest/profiler-api/API_ProfilingGroupDescription.html">
         *        <code>ProfilingGroupDescription</code> </a> objects is returned.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder profilingGroupNames(String... profilingGroupNames);

        /**
         * <p>
         * A returned list <a
         * href="https://docs.aws.amazon.com/codeguru/latest/profiler-api/API_ProfilingGroupDescription.html">
         * <code>ProfilingGroupDescription</code> </a> objects. A list of <a
         * href="https://docs.aws.amazon.com/codeguru/latest/profiler-api/API_ProfilingGroupDescription.html">
         * <code>ProfilingGroupDescription</code> </a> objects is returned only if <code>includeDescription</code> is
         * <code>true</code>, otherwise a list of profiling group names is returned.
         * </p>
         * 
         * @param profilingGroups
         *        A returned list <a
         *        href="https://docs.aws.amazon.com/codeguru/latest/profiler-api/API_ProfilingGroupDescription.html">
         *        <code>ProfilingGroupDescription</code> </a> objects. A list of <a
         *        href="https://docs.aws.amazon.com/codeguru/latest/profiler-api/API_ProfilingGroupDescription.html">
         *        <code>ProfilingGroupDescription</code> </a> objects is returned only if
         *        <code>includeDescription</code> is <code>true</code>, otherwise a list of profiling group names is
         *        returned.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder profilingGroups(Collection<ProfilingGroupDescription> profilingGroups);

        /**
         * <p>
         * A returned list <a
         * href="https://docs.aws.amazon.com/codeguru/latest/profiler-api/API_ProfilingGroupDescription.html">
         * <code>ProfilingGroupDescription</code> </a> objects. A list of <a
         * href="https://docs.aws.amazon.com/codeguru/latest/profiler-api/API_ProfilingGroupDescription.html">
         * <code>ProfilingGroupDescription</code> </a> objects is returned only if <code>includeDescription</code> is
         * <code>true</code>, otherwise a list of profiling group names is returned.
         * </p>
         * 
         * @param profilingGroups
         *        A returned list <a
         *        href="https://docs.aws.amazon.com/codeguru/latest/profiler-api/API_ProfilingGroupDescription.html">
         *        <code>ProfilingGroupDescription</code> </a> objects. A list of <a
         *        href="https://docs.aws.amazon.com/codeguru/latest/profiler-api/API_ProfilingGroupDescription.html">
         *        <code>ProfilingGroupDescription</code> </a> objects is returned only if
         *        <code>includeDescription</code> is <code>true</code>, otherwise a list of profiling group names is
         *        returned.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder profilingGroups(ProfilingGroupDescription... profilingGroups);

        /**
         * <p>
         * A returned list <a
         * href="https://docs.aws.amazon.com/codeguru/latest/profiler-api/API_ProfilingGroupDescription.html">
         * <code>ProfilingGroupDescription</code> </a> objects. A list of <a
         * href="https://docs.aws.amazon.com/codeguru/latest/profiler-api/API_ProfilingGroupDescription.html">
         * <code>ProfilingGroupDescription</code> </a> objects is returned only if <code>includeDescription</code> is
         * <code>true</code>, otherwise a list of profiling group names is returned.
         * </p>
         * This is a convenience that creates an instance of the {@link List<ProfilingGroupDescription>.Builder}
         * avoiding the need to create one manually via {@link List<ProfilingGroupDescription>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<ProfilingGroupDescription>.Builder#build()} is called
         * immediately and its result is passed to {@link #profilingGroups(List<ProfilingGroupDescription>)}.
         * 
         * @param profilingGroups
         *        a consumer that will call methods on {@link List<ProfilingGroupDescription>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #profilingGroups(List<ProfilingGroupDescription>)
         */
        Builder profilingGroups(Consumer<ProfilingGroupDescription.Builder>... profilingGroups);
    }

    static final class BuilderImpl extends CodeGuruProfilerResponse.BuilderImpl implements Builder {
        private String nextToken;

        private List<String> profilingGroupNames = DefaultSdkAutoConstructList.getInstance();

        private List<ProfilingGroupDescription> profilingGroups = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ListProfilingGroupsResponse model) {
            super(model);
            nextToken(model.nextToken);
            profilingGroupNames(model.profilingGroupNames);
            profilingGroups(model.profilingGroups);
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        public final Collection<String> getProfilingGroupNames() {
            if (profilingGroupNames instanceof SdkAutoConstructList) {
                return null;
            }
            return profilingGroupNames;
        }

        @Override
        public final Builder profilingGroupNames(Collection<String> profilingGroupNames) {
            this.profilingGroupNames = ProfilingGroupNamesCopier.copy(profilingGroupNames);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder profilingGroupNames(String... profilingGroupNames) {
            profilingGroupNames(Arrays.asList(profilingGroupNames));
            return this;
        }

        public final void setProfilingGroupNames(Collection<String> profilingGroupNames) {
            this.profilingGroupNames = ProfilingGroupNamesCopier.copy(profilingGroupNames);
        }

        public final Collection<ProfilingGroupDescription.Builder> getProfilingGroups() {
            if (profilingGroups instanceof SdkAutoConstructList) {
                return null;
            }
            return profilingGroups != null ? profilingGroups.stream().map(ProfilingGroupDescription::toBuilder)
                    .collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder profilingGroups(Collection<ProfilingGroupDescription> profilingGroups) {
            this.profilingGroups = ProfilingGroupDescriptionsCopier.copy(profilingGroups);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder profilingGroups(ProfilingGroupDescription... profilingGroups) {
            profilingGroups(Arrays.asList(profilingGroups));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder profilingGroups(Consumer<ProfilingGroupDescription.Builder>... profilingGroups) {
            profilingGroups(Stream.of(profilingGroups).map(c -> ProfilingGroupDescription.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setProfilingGroups(Collection<ProfilingGroupDescription.BuilderImpl> profilingGroups) {
            this.profilingGroups = ProfilingGroupDescriptionsCopier.copyFromBuilder(profilingGroups);
        }

        @Override
        public ListProfilingGroupsResponse build() {
            return new ListProfilingGroupsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
