/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.codeguruprofiler.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The structure representing the listProfileTimesResponse.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListProfileTimesResponse extends CodeGuruProfilerResponse implements
        ToCopyableBuilder<ListProfileTimesResponse.Builder, ListProfileTimesResponse> {
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("nextToken").getter(getter(ListProfileTimesResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()).build();

    private static final SdkField<List<ProfileTime>> PROFILE_TIMES_FIELD = SdkField
            .<List<ProfileTime>> builder(MarshallingType.LIST)
            .memberName("profileTimes")
            .getter(getter(ListProfileTimesResponse::profileTimes))
            .setter(setter(Builder::profileTimes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("profileTimes").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ProfileTime> builder(MarshallingType.SDK_POJO)
                                            .constructor(ProfileTime::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NEXT_TOKEN_FIELD,
            PROFILE_TIMES_FIELD));

    private final String nextToken;

    private final List<ProfileTime> profileTimes;

    private ListProfileTimesResponse(BuilderImpl builder) {
        super(builder);
        this.nextToken = builder.nextToken;
        this.profileTimes = builder.profileTimes;
    }

    /**
     * <p>
     * The <code>nextToken</code> value to include in a future <code>ListProfileTimes</code> request. When the results
     * of a <code>ListProfileTimes</code> request exceed <code>maxResults</code>, this value can be used to retrieve the
     * next page of results. This value is <code>null</code> when there are no more results to return.
     * </p>
     * 
     * @return The <code>nextToken</code> value to include in a future <code>ListProfileTimes</code> request. When the
     *         results of a <code>ListProfileTimes</code> request exceed <code>maxResults</code>, this value can be used
     *         to retrieve the next page of results. This value is <code>null</code> when there are no more results to
     *         return.
     */
    public final String nextToken() {
        return nextToken;
    }

    /**
     * Returns true if the ProfileTimes property was specified by the sender (it may be empty), or false if the sender
     * did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public final boolean hasProfileTimes() {
        return profileTimes != null && !(profileTimes instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The list of start times of the available profiles for the aggregation period in the specified time range.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasProfileTimes()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The list of start times of the available profiles for the aggregation period in the specified time range.
     */
    public final List<ProfileTime> profileTimes() {
        return profileTimes;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(hasProfileTimes() ? profileTimes() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListProfileTimesResponse)) {
            return false;
        }
        ListProfileTimesResponse other = (ListProfileTimesResponse) obj;
        return Objects.equals(nextToken(), other.nextToken()) && hasProfileTimes() == other.hasProfileTimes()
                && Objects.equals(profileTimes(), other.profileTimes());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListProfileTimesResponse").add("NextToken", nextToken())
                .add("ProfileTimes", hasProfileTimes() ? profileTimes() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "nextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "profileTimes":
            return Optional.ofNullable(clazz.cast(profileTimes()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListProfileTimesResponse, T> g) {
        return obj -> g.apply((ListProfileTimesResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends CodeGuruProfilerResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, ListProfileTimesResponse> {
        /**
         * <p>
         * The <code>nextToken</code> value to include in a future <code>ListProfileTimes</code> request. When the
         * results of a <code>ListProfileTimes</code> request exceed <code>maxResults</code>, this value can be used to
         * retrieve the next page of results. This value is <code>null</code> when there are no more results to return.
         * </p>
         * 
         * @param nextToken
         *        The <code>nextToken</code> value to include in a future <code>ListProfileTimes</code> request. When
         *        the results of a <code>ListProfileTimes</code> request exceed <code>maxResults</code>, this value can
         *        be used to retrieve the next page of results. This value is <code>null</code> when there are no more
         *        results to return.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * The list of start times of the available profiles for the aggregation period in the specified time range.
         * </p>
         * 
         * @param profileTimes
         *        The list of start times of the available profiles for the aggregation period in the specified time
         *        range.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder profileTimes(Collection<ProfileTime> profileTimes);

        /**
         * <p>
         * The list of start times of the available profiles for the aggregation period in the specified time range.
         * </p>
         * 
         * @param profileTimes
         *        The list of start times of the available profiles for the aggregation period in the specified time
         *        range.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder profileTimes(ProfileTime... profileTimes);

        /**
         * <p>
         * The list of start times of the available profiles for the aggregation period in the specified time range.
         * </p>
         * This is a convenience that creates an instance of the {@link List<ProfileTime>.Builder} avoiding the need to
         * create one manually via {@link List<ProfileTime>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<ProfileTime>.Builder#build()} is called immediately and its
         * result is passed to {@link #profileTimes(List<ProfileTime>)}.
         * 
         * @param profileTimes
         *        a consumer that will call methods on {@link List<ProfileTime>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #profileTimes(List<ProfileTime>)
         */
        Builder profileTimes(Consumer<ProfileTime.Builder>... profileTimes);
    }

    static final class BuilderImpl extends CodeGuruProfilerResponse.BuilderImpl implements Builder {
        private String nextToken;

        private List<ProfileTime> profileTimes = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ListProfileTimesResponse model) {
            super(model);
            nextToken(model.nextToken);
            profileTimes(model.profileTimes);
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        public final Collection<ProfileTime.Builder> getProfileTimes() {
            if (profileTimes instanceof SdkAutoConstructList) {
                return null;
            }
            return profileTimes != null ? profileTimes.stream().map(ProfileTime::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder profileTimes(Collection<ProfileTime> profileTimes) {
            this.profileTimes = ProfileTimesCopier.copy(profileTimes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder profileTimes(ProfileTime... profileTimes) {
            profileTimes(Arrays.asList(profileTimes));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder profileTimes(Consumer<ProfileTime.Builder>... profileTimes) {
            profileTimes(Stream.of(profileTimes).map(c -> ProfileTime.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setProfileTimes(Collection<ProfileTime.BuilderImpl> profileTimes) {
            this.profileTimes = ProfileTimesCopier.copyFromBuilder(profileTimes);
        }

        @Override
        public ListProfileTimesResponse build() {
            return new ListProfileTimesResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
