/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codeguruprofiler.model;

import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkBytes;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.adapter.StandardMemberCopier;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.PayloadTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.codeguruprofiler.model.CodeGuruProfilerResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetProfileResponse
extends CodeGuruProfilerResponse
implements ToCopyableBuilder<Builder, GetProfileResponse> {
    private static final SdkField<String> CONTENT_ENCODING_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("contentEncoding").getter(GetProfileResponse.getter(GetProfileResponse::contentEncoding)).setter(GetProfileResponse.setter(Builder::contentEncoding)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.HEADER).locationName("Content-Encoding").build()}).build();
    private static final SdkField<String> CONTENT_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("contentType").getter(GetProfileResponse.getter(GetProfileResponse::contentType)).setter(GetProfileResponse.setter(Builder::contentType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.HEADER).locationName("Content-Type").build()}).build();
    private static final SdkField<SdkBytes> PROFILE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_BYTES).memberName("profile").getter(GetProfileResponse.getter(GetProfileResponse::profile)).setter(GetProfileResponse.setter(Builder::profile)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("profile").build(), PayloadTrait.create()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONTENT_ENCODING_FIELD, CONTENT_TYPE_FIELD, PROFILE_FIELD));
    private final String contentEncoding;
    private final String contentType;
    private final SdkBytes profile;

    private GetProfileResponse(BuilderImpl builder) {
        super(builder);
        this.contentEncoding = builder.contentEncoding;
        this.contentType = builder.contentType;
        this.profile = builder.profile;
    }

    public final String contentEncoding() {
        return this.contentEncoding;
    }

    public final String contentType() {
        return this.contentType;
    }

    public final SdkBytes profile() {
        return this.profile;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.contentEncoding());
        hashCode = 31 * hashCode + Objects.hashCode(this.contentType());
        hashCode = 31 * hashCode + Objects.hashCode(this.profile());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetProfileResponse)) {
            return false;
        }
        GetProfileResponse other = (GetProfileResponse)((Object)obj);
        return Objects.equals(this.contentEncoding(), other.contentEncoding()) && Objects.equals(this.contentType(), other.contentType()) && Objects.equals(this.profile(), other.profile());
    }

    public final String toString() {
        return ToString.builder((String)"GetProfileResponse").add("ContentEncoding", (Object)this.contentEncoding()).add("ContentType", (Object)this.contentType()).add("Profile", (Object)this.profile()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "contentEncoding": {
                return Optional.ofNullable(clazz.cast(this.contentEncoding()));
            }
            case "contentType": {
                return Optional.ofNullable(clazz.cast(this.contentType()));
            }
            case "profile": {
                return Optional.ofNullable(clazz.cast(this.profile()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetProfileResponse, T> g) {
        return obj -> g.apply((GetProfileResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends CodeGuruProfilerResponse.BuilderImpl
    implements Builder {
        private String contentEncoding;
        private String contentType;
        private SdkBytes profile;

        private BuilderImpl() {
        }

        private BuilderImpl(GetProfileResponse model) {
            super(model);
            this.contentEncoding(model.contentEncoding);
            this.contentType(model.contentType);
            this.profile(model.profile);
        }

        public final String getContentEncoding() {
            return this.contentEncoding;
        }

        @Override
        public final Builder contentEncoding(String contentEncoding) {
            this.contentEncoding = contentEncoding;
            return this;
        }

        public final void setContentEncoding(String contentEncoding) {
            this.contentEncoding = contentEncoding;
        }

        public final String getContentType() {
            return this.contentType;
        }

        @Override
        public final Builder contentType(String contentType) {
            this.contentType = contentType;
            return this;
        }

        public final void setContentType(String contentType) {
            this.contentType = contentType;
        }

        public final ByteBuffer getProfile() {
            return this.profile == null ? null : this.profile.asByteBuffer();
        }

        @Override
        public final Builder profile(SdkBytes profile) {
            this.profile = StandardMemberCopier.copy((SdkBytes)profile);
            return this;
        }

        public final void setProfile(ByteBuffer profile) {
            this.profile(profile == null ? null : SdkBytes.fromByteBuffer((ByteBuffer)profile));
        }

        @Override
        public GetProfileResponse build() {
            return new GetProfileResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends CodeGuruProfilerResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetProfileResponse> {
        public Builder contentEncoding(String var1);

        public Builder contentType(String var1);

        public Builder profile(SdkBytes var1);
    }
}

