/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codeguruprofiler.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.codeguruprofiler.model.CodeGuruProfilerRequest;
import software.amazon.awssdk.services.codeguruprofiler.model.FeedbackType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class SubmitFeedbackRequest
extends CodeGuruProfilerRequest
implements ToCopyableBuilder<Builder, SubmitFeedbackRequest> {
    private static final SdkField<String> ANOMALY_INSTANCE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(SubmitFeedbackRequest.getter(SubmitFeedbackRequest::anomalyInstanceId)).setter(SubmitFeedbackRequest.setter(Builder::anomalyInstanceId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("anomalyInstanceId").build()}).build();
    private static final SdkField<String> COMMENT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(SubmitFeedbackRequest.getter(SubmitFeedbackRequest::comment)).setter(SubmitFeedbackRequest.setter(Builder::comment)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("comment").build()}).build();
    private static final SdkField<String> PROFILING_GROUP_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(SubmitFeedbackRequest.getter(SubmitFeedbackRequest::profilingGroupName)).setter(SubmitFeedbackRequest.setter(Builder::profilingGroupName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("profilingGroupName").build()}).build();
    private static final SdkField<String> TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(SubmitFeedbackRequest.getter(SubmitFeedbackRequest::typeAsString)).setter(SubmitFeedbackRequest.setter(Builder::type)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("type").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ANOMALY_INSTANCE_ID_FIELD, COMMENT_FIELD, PROFILING_GROUP_NAME_FIELD, TYPE_FIELD));
    private final String anomalyInstanceId;
    private final String comment;
    private final String profilingGroupName;
    private final String type;

    private SubmitFeedbackRequest(BuilderImpl builder) {
        super(builder);
        this.anomalyInstanceId = builder.anomalyInstanceId;
        this.comment = builder.comment;
        this.profilingGroupName = builder.profilingGroupName;
        this.type = builder.type;
    }

    public String anomalyInstanceId() {
        return this.anomalyInstanceId;
    }

    public String comment() {
        return this.comment;
    }

    public String profilingGroupName() {
        return this.profilingGroupName;
    }

    public FeedbackType type() {
        return FeedbackType.fromValue(this.type);
    }

    public String typeAsString() {
        return this.type;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.anomalyInstanceId());
        hashCode = 31 * hashCode + Objects.hashCode(this.comment());
        hashCode = 31 * hashCode + Objects.hashCode(this.profilingGroupName());
        hashCode = 31 * hashCode + Objects.hashCode(this.typeAsString());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SubmitFeedbackRequest)) {
            return false;
        }
        SubmitFeedbackRequest other = (SubmitFeedbackRequest)((Object)obj);
        return Objects.equals(this.anomalyInstanceId(), other.anomalyInstanceId()) && Objects.equals(this.comment(), other.comment()) && Objects.equals(this.profilingGroupName(), other.profilingGroupName()) && Objects.equals(this.typeAsString(), other.typeAsString());
    }

    public String toString() {
        return ToString.builder((String)"SubmitFeedbackRequest").add("AnomalyInstanceId", (Object)this.anomalyInstanceId()).add("Comment", (Object)this.comment()).add("ProfilingGroupName", (Object)this.profilingGroupName()).add("Type", (Object)this.typeAsString()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "anomalyInstanceId": {
                return Optional.ofNullable(clazz.cast(this.anomalyInstanceId()));
            }
            case "comment": {
                return Optional.ofNullable(clazz.cast(this.comment()));
            }
            case "profilingGroupName": {
                return Optional.ofNullable(clazz.cast(this.profilingGroupName()));
            }
            case "type": {
                return Optional.ofNullable(clazz.cast(this.typeAsString()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<SubmitFeedbackRequest, T> g) {
        return obj -> g.apply((SubmitFeedbackRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends CodeGuruProfilerRequest.BuilderImpl
    implements Builder {
        private String anomalyInstanceId;
        private String comment;
        private String profilingGroupName;
        private String type;

        private BuilderImpl() {
        }

        private BuilderImpl(SubmitFeedbackRequest model) {
            super(model);
            this.anomalyInstanceId(model.anomalyInstanceId);
            this.comment(model.comment);
            this.profilingGroupName(model.profilingGroupName);
            this.type(model.type);
        }

        public final String getAnomalyInstanceId() {
            return this.anomalyInstanceId;
        }

        @Override
        public final Builder anomalyInstanceId(String anomalyInstanceId) {
            this.anomalyInstanceId = anomalyInstanceId;
            return this;
        }

        public final void setAnomalyInstanceId(String anomalyInstanceId) {
            this.anomalyInstanceId = anomalyInstanceId;
        }

        public final String getComment() {
            return this.comment;
        }

        @Override
        public final Builder comment(String comment) {
            this.comment = comment;
            return this;
        }

        public final void setComment(String comment) {
            this.comment = comment;
        }

        public final String getProfilingGroupName() {
            return this.profilingGroupName;
        }

        @Override
        public final Builder profilingGroupName(String profilingGroupName) {
            this.profilingGroupName = profilingGroupName;
            return this;
        }

        public final void setProfilingGroupName(String profilingGroupName) {
            this.profilingGroupName = profilingGroupName;
        }

        public final String getType() {
            return this.type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(FeedbackType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public SubmitFeedbackRequest build() {
            return new SubmitFeedbackRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends CodeGuruProfilerRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, SubmitFeedbackRequest> {
        public Builder anomalyInstanceId(String var1);

        public Builder comment(String var1);

        public Builder profilingGroupName(String var1);

        public Builder type(String var1);

        public Builder type(FeedbackType var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

