/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.codeguruprofiler.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p/>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AgentConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<AgentConfiguration.Builder, AgentConfiguration> {
    private static final SdkField<Integer> PERIOD_IN_SECONDS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .getter(getter(AgentConfiguration::periodInSeconds)).setter(setter(Builder::periodInSeconds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("periodInSeconds").build()).build();

    private static final SdkField<Boolean> SHOULD_PROFILE_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .getter(getter(AgentConfiguration::shouldProfile)).setter(setter(Builder::shouldProfile))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("shouldProfile").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PERIOD_IN_SECONDS_FIELD,
            SHOULD_PROFILE_FIELD));

    private static final long serialVersionUID = 1L;

    private final Integer periodInSeconds;

    private final Boolean shouldProfile;

    private AgentConfiguration(BuilderImpl builder) {
        this.periodInSeconds = builder.periodInSeconds;
        this.shouldProfile = builder.shouldProfile;
    }

    /**
     * <p/>
     * 
     * @return
     */
    public Integer periodInSeconds() {
        return periodInSeconds;
    }

    /**
     * <p/>
     * 
     * @return
     */
    public Boolean shouldProfile() {
        return shouldProfile;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(periodInSeconds());
        hashCode = 31 * hashCode + Objects.hashCode(shouldProfile());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AgentConfiguration)) {
            return false;
        }
        AgentConfiguration other = (AgentConfiguration) obj;
        return Objects.equals(periodInSeconds(), other.periodInSeconds())
                && Objects.equals(shouldProfile(), other.shouldProfile());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("AgentConfiguration").add("PeriodInSeconds", periodInSeconds())
                .add("ShouldProfile", shouldProfile()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "periodInSeconds":
            return Optional.ofNullable(clazz.cast(periodInSeconds()));
        case "shouldProfile":
            return Optional.ofNullable(clazz.cast(shouldProfile()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AgentConfiguration, T> g) {
        return obj -> g.apply((AgentConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AgentConfiguration> {
        /**
         * <p/>
         * 
         * @param periodInSeconds
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder periodInSeconds(Integer periodInSeconds);

        /**
         * <p/>
         * 
         * @param shouldProfile
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder shouldProfile(Boolean shouldProfile);
    }

    static final class BuilderImpl implements Builder {
        private Integer periodInSeconds;

        private Boolean shouldProfile;

        private BuilderImpl() {
        }

        private BuilderImpl(AgentConfiguration model) {
            periodInSeconds(model.periodInSeconds);
            shouldProfile(model.shouldProfile);
        }

        public final Integer getPeriodInSeconds() {
            return periodInSeconds;
        }

        @Override
        public final Builder periodInSeconds(Integer periodInSeconds) {
            this.periodInSeconds = periodInSeconds;
            return this;
        }

        public final void setPeriodInSeconds(Integer periodInSeconds) {
            this.periodInSeconds = periodInSeconds;
        }

        public final Boolean getShouldProfile() {
            return shouldProfile;
        }

        @Override
        public final Builder shouldProfile(Boolean shouldProfile) {
            this.shouldProfile = shouldProfile;
            return this;
        }

        public final void setShouldProfile(Boolean shouldProfile) {
            this.shouldProfile = shouldProfile;
        }

        @Override
        public AgentConfiguration build() {
            return new AgentConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
