/*
 * Copyright 2015-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.codeguruprofiler;

import java.util.function.Consumer;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.core.SdkClient;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.regions.ServiceMetadata;
import software.amazon.awssdk.services.codeguruprofiler.model.CodeGuruProfilerException;
import software.amazon.awssdk.services.codeguruprofiler.model.ConfigureAgentRequest;
import software.amazon.awssdk.services.codeguruprofiler.model.ConfigureAgentResponse;
import software.amazon.awssdk.services.codeguruprofiler.model.ConflictException;
import software.amazon.awssdk.services.codeguruprofiler.model.CreateProfilingGroupRequest;
import software.amazon.awssdk.services.codeguruprofiler.model.CreateProfilingGroupResponse;
import software.amazon.awssdk.services.codeguruprofiler.model.DeleteProfilingGroupRequest;
import software.amazon.awssdk.services.codeguruprofiler.model.DeleteProfilingGroupResponse;
import software.amazon.awssdk.services.codeguruprofiler.model.DescribeProfilingGroupRequest;
import software.amazon.awssdk.services.codeguruprofiler.model.DescribeProfilingGroupResponse;
import software.amazon.awssdk.services.codeguruprofiler.model.GetProfileRequest;
import software.amazon.awssdk.services.codeguruprofiler.model.GetProfileResponse;
import software.amazon.awssdk.services.codeguruprofiler.model.InternalServerException;
import software.amazon.awssdk.services.codeguruprofiler.model.ListProfileTimesRequest;
import software.amazon.awssdk.services.codeguruprofiler.model.ListProfileTimesResponse;
import software.amazon.awssdk.services.codeguruprofiler.model.ListProfilingGroupsRequest;
import software.amazon.awssdk.services.codeguruprofiler.model.ListProfilingGroupsResponse;
import software.amazon.awssdk.services.codeguruprofiler.model.PostAgentProfileRequest;
import software.amazon.awssdk.services.codeguruprofiler.model.PostAgentProfileResponse;
import software.amazon.awssdk.services.codeguruprofiler.model.ResourceNotFoundException;
import software.amazon.awssdk.services.codeguruprofiler.model.ServiceQuotaExceededException;
import software.amazon.awssdk.services.codeguruprofiler.model.ThrottlingException;
import software.amazon.awssdk.services.codeguruprofiler.model.UpdateProfilingGroupRequest;
import software.amazon.awssdk.services.codeguruprofiler.model.UpdateProfilingGroupResponse;
import software.amazon.awssdk.services.codeguruprofiler.model.ValidationException;
import software.amazon.awssdk.services.codeguruprofiler.paginators.ListProfileTimesIterable;
import software.amazon.awssdk.services.codeguruprofiler.paginators.ListProfilingGroupsIterable;

/**
 * Service client for accessing Amazon CodeGuru Profiler. This can be created using the static {@link #builder()}
 * method.
 *
 * <p>
 * Example service documentation.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public interface CodeGuruProfilerClient extends SdkClient {
    String SERVICE_NAME = "codeguru-profiler";

    /**
     * Create a {@link CodeGuruProfilerClient} with the region loaded from the
     * {@link software.amazon.awssdk.regions.providers.DefaultAwsRegionProviderChain} and credentials loaded from the
     * {@link software.amazon.awssdk.auth.credentials.DefaultCredentialsProvider}.
     */
    static CodeGuruProfilerClient create() {
        return builder().build();
    }

    /**
     * Create a builder that can be used to configure and create a {@link CodeGuruProfilerClient}.
     */
    static CodeGuruProfilerClientBuilder builder() {
        return new DefaultCodeGuruProfilerClientBuilder();
    }

    /**
     * <p>
     * Provides the configuration to use for an agent of the profiling group.
     * </p>
     *
     * @param configureAgentRequest
     *        Request for ConfigureAgent operation.
     * @return Result of the ConfigureAgent operation returned by the service.
     * @throws InternalServerException
     *         Unexpected error during processing of request.
     * @throws ValidationException
     *         The input fails to satisfy the constraints of the API.
     * @throws ThrottlingException
     *         Request was denied due to request throttling.
     * @throws ResourceNotFoundException
     *         Request references a resource which does not exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CodeGuruProfilerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CodeGuruProfilerClient.ConfigureAgent
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/codeguruprofiler-2019-07-18/ConfigureAgent"
     *      target="_top">AWS API Documentation</a>
     */
    default ConfigureAgentResponse configureAgent(ConfigureAgentRequest configureAgentRequest) throws InternalServerException,
            ValidationException, ThrottlingException, ResourceNotFoundException, AwsServiceException, SdkClientException,
            CodeGuruProfilerException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Provides the configuration to use for an agent of the profiling group.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ConfigureAgentRequest.Builder} avoiding the need to
     * create one manually via {@link ConfigureAgentRequest#builder()}
     * </p>
     *
     * @param configureAgentRequest
     *        A {@link Consumer} that will call methods on {@link ConfigureAgentRequest.Builder} to create a request.
     *        Request for ConfigureAgent operation.
     * @return Result of the ConfigureAgent operation returned by the service.
     * @throws InternalServerException
     *         Unexpected error during processing of request.
     * @throws ValidationException
     *         The input fails to satisfy the constraints of the API.
     * @throws ThrottlingException
     *         Request was denied due to request throttling.
     * @throws ResourceNotFoundException
     *         Request references a resource which does not exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CodeGuruProfilerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CodeGuruProfilerClient.ConfigureAgent
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/codeguruprofiler-2019-07-18/ConfigureAgent"
     *      target="_top">AWS API Documentation</a>
     */
    default ConfigureAgentResponse configureAgent(Consumer<ConfigureAgentRequest.Builder> configureAgentRequest)
            throws InternalServerException, ValidationException, ThrottlingException, ResourceNotFoundException,
            AwsServiceException, SdkClientException, CodeGuruProfilerException {
        return configureAgent(ConfigureAgentRequest.builder().applyMutation(configureAgentRequest).build());
    }

    /**
     * <p>
     * Create a profiling group.
     * </p>
     *
     * @param createProfilingGroupRequest
     *        Request for CreateProfilingGroup operation.
     * @return Result of the CreateProfilingGroup operation returned by the service.
     * @throws ServiceQuotaExceededException
     *         Request would cause a service quota to be exceeded.
     * @throws InternalServerException
     *         Unexpected error during processing of request.
     * @throws ConflictException
     *         Request can can cause an inconsistent state for the resource.
     * @throws ValidationException
     *         The input fails to satisfy the constraints of the API.
     * @throws ThrottlingException
     *         Request was denied due to request throttling.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CodeGuruProfilerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CodeGuruProfilerClient.CreateProfilingGroup
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/codeguruprofiler-2019-07-18/CreateProfilingGroup"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateProfilingGroupResponse createProfilingGroup(CreateProfilingGroupRequest createProfilingGroupRequest)
            throws ServiceQuotaExceededException, InternalServerException, ConflictException, ValidationException,
            ThrottlingException, AwsServiceException, SdkClientException, CodeGuruProfilerException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Create a profiling group.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateProfilingGroupRequest.Builder} avoiding the
     * need to create one manually via {@link CreateProfilingGroupRequest#builder()}
     * </p>
     *
     * @param createProfilingGroupRequest
     *        A {@link Consumer} that will call methods on {@link CreateProfilingGroupRequest.Builder} to create a
     *        request. Request for CreateProfilingGroup operation.
     * @return Result of the CreateProfilingGroup operation returned by the service.
     * @throws ServiceQuotaExceededException
     *         Request would cause a service quota to be exceeded.
     * @throws InternalServerException
     *         Unexpected error during processing of request.
     * @throws ConflictException
     *         Request can can cause an inconsistent state for the resource.
     * @throws ValidationException
     *         The input fails to satisfy the constraints of the API.
     * @throws ThrottlingException
     *         Request was denied due to request throttling.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CodeGuruProfilerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CodeGuruProfilerClient.CreateProfilingGroup
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/codeguruprofiler-2019-07-18/CreateProfilingGroup"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateProfilingGroupResponse createProfilingGroup(
            Consumer<CreateProfilingGroupRequest.Builder> createProfilingGroupRequest) throws ServiceQuotaExceededException,
            InternalServerException, ConflictException, ValidationException, ThrottlingException, AwsServiceException,
            SdkClientException, CodeGuruProfilerException {
        return createProfilingGroup(CreateProfilingGroupRequest.builder().applyMutation(createProfilingGroupRequest).build());
    }

    /**
     * <p>
     * Delete a profiling group.
     * </p>
     *
     * @param deleteProfilingGroupRequest
     *        Request for DeleteProfilingGroup operation.
     * @return Result of the DeleteProfilingGroup operation returned by the service.
     * @throws InternalServerException
     *         Unexpected error during processing of request.
     * @throws ValidationException
     *         The input fails to satisfy the constraints of the API.
     * @throws ThrottlingException
     *         Request was denied due to request throttling.
     * @throws ResourceNotFoundException
     *         Request references a resource which does not exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CodeGuruProfilerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CodeGuruProfilerClient.DeleteProfilingGroup
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/codeguruprofiler-2019-07-18/DeleteProfilingGroup"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteProfilingGroupResponse deleteProfilingGroup(DeleteProfilingGroupRequest deleteProfilingGroupRequest)
            throws InternalServerException, ValidationException, ThrottlingException, ResourceNotFoundException,
            AwsServiceException, SdkClientException, CodeGuruProfilerException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Delete a profiling group.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteProfilingGroupRequest.Builder} avoiding the
     * need to create one manually via {@link DeleteProfilingGroupRequest#builder()}
     * </p>
     *
     * @param deleteProfilingGroupRequest
     *        A {@link Consumer} that will call methods on {@link DeleteProfilingGroupRequest.Builder} to create a
     *        request. Request for DeleteProfilingGroup operation.
     * @return Result of the DeleteProfilingGroup operation returned by the service.
     * @throws InternalServerException
     *         Unexpected error during processing of request.
     * @throws ValidationException
     *         The input fails to satisfy the constraints of the API.
     * @throws ThrottlingException
     *         Request was denied due to request throttling.
     * @throws ResourceNotFoundException
     *         Request references a resource which does not exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CodeGuruProfilerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CodeGuruProfilerClient.DeleteProfilingGroup
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/codeguruprofiler-2019-07-18/DeleteProfilingGroup"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteProfilingGroupResponse deleteProfilingGroup(
            Consumer<DeleteProfilingGroupRequest.Builder> deleteProfilingGroupRequest) throws InternalServerException,
            ValidationException, ThrottlingException, ResourceNotFoundException, AwsServiceException, SdkClientException,
            CodeGuruProfilerException {
        return deleteProfilingGroup(DeleteProfilingGroupRequest.builder().applyMutation(deleteProfilingGroupRequest).build());
    }

    /**
     * <p>
     * Describe a profiling group.
     * </p>
     *
     * @param describeProfilingGroupRequest
     *        Request for DescribeProfilingGroup operation.
     * @return Result of the DescribeProfilingGroup operation returned by the service.
     * @throws InternalServerException
     *         Unexpected error during processing of request.
     * @throws ValidationException
     *         The input fails to satisfy the constraints of the API.
     * @throws ThrottlingException
     *         Request was denied due to request throttling.
     * @throws ResourceNotFoundException
     *         Request references a resource which does not exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CodeGuruProfilerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CodeGuruProfilerClient.DescribeProfilingGroup
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/codeguruprofiler-2019-07-18/DescribeProfilingGroup"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeProfilingGroupResponse describeProfilingGroup(DescribeProfilingGroupRequest describeProfilingGroupRequest)
            throws InternalServerException, ValidationException, ThrottlingException, ResourceNotFoundException,
            AwsServiceException, SdkClientException, CodeGuruProfilerException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Describe a profiling group.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeProfilingGroupRequest.Builder} avoiding the
     * need to create one manually via {@link DescribeProfilingGroupRequest#builder()}
     * </p>
     *
     * @param describeProfilingGroupRequest
     *        A {@link Consumer} that will call methods on {@link DescribeProfilingGroupRequest.Builder} to create a
     *        request. Request for DescribeProfilingGroup operation.
     * @return Result of the DescribeProfilingGroup operation returned by the service.
     * @throws InternalServerException
     *         Unexpected error during processing of request.
     * @throws ValidationException
     *         The input fails to satisfy the constraints of the API.
     * @throws ThrottlingException
     *         Request was denied due to request throttling.
     * @throws ResourceNotFoundException
     *         Request references a resource which does not exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CodeGuruProfilerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CodeGuruProfilerClient.DescribeProfilingGroup
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/codeguruprofiler-2019-07-18/DescribeProfilingGroup"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeProfilingGroupResponse describeProfilingGroup(
            Consumer<DescribeProfilingGroupRequest.Builder> describeProfilingGroupRequest) throws InternalServerException,
            ValidationException, ThrottlingException, ResourceNotFoundException, AwsServiceException, SdkClientException,
            CodeGuruProfilerException {
        return describeProfilingGroup(DescribeProfilingGroupRequest.builder().applyMutation(describeProfilingGroupRequest)
                .build());
    }

    /**
     * <p>
     * Get the aggregated profile of a profiling group for the specified time range. If the requested time range does
     * not align with the available aggregated profiles, it will be expanded to attain alignment. If aggregated profiles
     * are available only for part of the period requested, the profile is returned from the earliest available to the
     * latest within the requested time range. For instance, if the requested time range is from 00:00 to 00:20 and the
     * available profiles are from 00:15 to 00:25, then the returned profile will be from 00:15 to 00:20.
     * </p>
     *
     * @param getProfileRequest
     *        Request for GetProfile operation.
     * @return Result of the GetProfile operation returned by the service.
     * @throws InternalServerException
     *         Unexpected error during processing of request.
     * @throws ValidationException
     *         The input fails to satisfy the constraints of the API.
     * @throws ThrottlingException
     *         Request was denied due to request throttling.
     * @throws ResourceNotFoundException
     *         Request references a resource which does not exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CodeGuruProfilerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CodeGuruProfilerClient.GetProfile
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/codeguruprofiler-2019-07-18/GetProfile" target="_top">AWS
     *      API Documentation</a>
     */
    default GetProfileResponse getProfile(GetProfileRequest getProfileRequest) throws InternalServerException,
            ValidationException, ThrottlingException, ResourceNotFoundException, AwsServiceException, SdkClientException,
            CodeGuruProfilerException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Get the aggregated profile of a profiling group for the specified time range. If the requested time range does
     * not align with the available aggregated profiles, it will be expanded to attain alignment. If aggregated profiles
     * are available only for part of the period requested, the profile is returned from the earliest available to the
     * latest within the requested time range. For instance, if the requested time range is from 00:00 to 00:20 and the
     * available profiles are from 00:15 to 00:25, then the returned profile will be from 00:15 to 00:20.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetProfileRequest.Builder} avoiding the need to
     * create one manually via {@link GetProfileRequest#builder()}
     * </p>
     *
     * @param getProfileRequest
     *        A {@link Consumer} that will call methods on {@link GetProfileRequest.Builder} to create a request.
     *        Request for GetProfile operation.
     * @return Result of the GetProfile operation returned by the service.
     * @throws InternalServerException
     *         Unexpected error during processing of request.
     * @throws ValidationException
     *         The input fails to satisfy the constraints of the API.
     * @throws ThrottlingException
     *         Request was denied due to request throttling.
     * @throws ResourceNotFoundException
     *         Request references a resource which does not exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CodeGuruProfilerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CodeGuruProfilerClient.GetProfile
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/codeguruprofiler-2019-07-18/GetProfile" target="_top">AWS
     *      API Documentation</a>
     */
    default GetProfileResponse getProfile(Consumer<GetProfileRequest.Builder> getProfileRequest) throws InternalServerException,
            ValidationException, ThrottlingException, ResourceNotFoundException, AwsServiceException, SdkClientException,
            CodeGuruProfilerException {
        return getProfile(GetProfileRequest.builder().applyMutation(getProfileRequest).build());
    }

    /**
     * <p>
     * List the start times of the available aggregated profiles of a profiling group for an aggregation period within
     * the specified time range.
     * </p>
     *
     * @param listProfileTimesRequest
     *        Request for ListProfileTimes operation.
     * @return Result of the ListProfileTimes operation returned by the service.
     * @throws InternalServerException
     *         Unexpected error during processing of request.
     * @throws ValidationException
     *         The input fails to satisfy the constraints of the API.
     * @throws ThrottlingException
     *         Request was denied due to request throttling.
     * @throws ResourceNotFoundException
     *         Request references a resource which does not exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CodeGuruProfilerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CodeGuruProfilerClient.ListProfileTimes
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/codeguruprofiler-2019-07-18/ListProfileTimes"
     *      target="_top">AWS API Documentation</a>
     */
    default ListProfileTimesResponse listProfileTimes(ListProfileTimesRequest listProfileTimesRequest)
            throws InternalServerException, ValidationException, ThrottlingException, ResourceNotFoundException,
            AwsServiceException, SdkClientException, CodeGuruProfilerException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * List the start times of the available aggregated profiles of a profiling group for an aggregation period within
     * the specified time range.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListProfileTimesRequest.Builder} avoiding the need
     * to create one manually via {@link ListProfileTimesRequest#builder()}
     * </p>
     *
     * @param listProfileTimesRequest
     *        A {@link Consumer} that will call methods on {@link ListProfileTimesRequest.Builder} to create a request.
     *        Request for ListProfileTimes operation.
     * @return Result of the ListProfileTimes operation returned by the service.
     * @throws InternalServerException
     *         Unexpected error during processing of request.
     * @throws ValidationException
     *         The input fails to satisfy the constraints of the API.
     * @throws ThrottlingException
     *         Request was denied due to request throttling.
     * @throws ResourceNotFoundException
     *         Request references a resource which does not exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CodeGuruProfilerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CodeGuruProfilerClient.ListProfileTimes
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/codeguruprofiler-2019-07-18/ListProfileTimes"
     *      target="_top">AWS API Documentation</a>
     */
    default ListProfileTimesResponse listProfileTimes(Consumer<ListProfileTimesRequest.Builder> listProfileTimesRequest)
            throws InternalServerException, ValidationException, ThrottlingException, ResourceNotFoundException,
            AwsServiceException, SdkClientException, CodeGuruProfilerException {
        return listProfileTimes(ListProfileTimesRequest.builder().applyMutation(listProfileTimesRequest).build());
    }

    /**
     * <p>
     * List the start times of the available aggregated profiles of a profiling group for an aggregation period within
     * the specified time range.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listProfileTimes(software.amazon.awssdk.services.codeguruprofiler.model.ListProfileTimesRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.codeguruprofiler.paginators.ListProfileTimesIterable responses = client.listProfileTimesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.codeguruprofiler.paginators.ListProfileTimesIterable responses = client
     *             .listProfileTimesPaginator(request);
     *     for (software.amazon.awssdk.services.codeguruprofiler.model.ListProfileTimesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.codeguruprofiler.paginators.ListProfileTimesIterable responses = client.listProfileTimesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listProfileTimes(software.amazon.awssdk.services.codeguruprofiler.model.ListProfileTimesRequest)}
     * operation.</b>
     * </p>
     *
     * @param listProfileTimesRequest
     *        Request for ListProfileTimes operation.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InternalServerException
     *         Unexpected error during processing of request.
     * @throws ValidationException
     *         The input fails to satisfy the constraints of the API.
     * @throws ThrottlingException
     *         Request was denied due to request throttling.
     * @throws ResourceNotFoundException
     *         Request references a resource which does not exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CodeGuruProfilerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CodeGuruProfilerClient.ListProfileTimes
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/codeguruprofiler-2019-07-18/ListProfileTimes"
     *      target="_top">AWS API Documentation</a>
     */
    default ListProfileTimesIterable listProfileTimesPaginator(ListProfileTimesRequest listProfileTimesRequest)
            throws InternalServerException, ValidationException, ThrottlingException, ResourceNotFoundException,
            AwsServiceException, SdkClientException, CodeGuruProfilerException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * List the start times of the available aggregated profiles of a profiling group for an aggregation period within
     * the specified time range.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listProfileTimes(software.amazon.awssdk.services.codeguruprofiler.model.ListProfileTimesRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.codeguruprofiler.paginators.ListProfileTimesIterable responses = client.listProfileTimesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.codeguruprofiler.paginators.ListProfileTimesIterable responses = client
     *             .listProfileTimesPaginator(request);
     *     for (software.amazon.awssdk.services.codeguruprofiler.model.ListProfileTimesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.codeguruprofiler.paginators.ListProfileTimesIterable responses = client.listProfileTimesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listProfileTimes(software.amazon.awssdk.services.codeguruprofiler.model.ListProfileTimesRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListProfileTimesRequest.Builder} avoiding the need
     * to create one manually via {@link ListProfileTimesRequest#builder()}
     * </p>
     *
     * @param listProfileTimesRequest
     *        A {@link Consumer} that will call methods on {@link ListProfileTimesRequest.Builder} to create a request.
     *        Request for ListProfileTimes operation.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InternalServerException
     *         Unexpected error during processing of request.
     * @throws ValidationException
     *         The input fails to satisfy the constraints of the API.
     * @throws ThrottlingException
     *         Request was denied due to request throttling.
     * @throws ResourceNotFoundException
     *         Request references a resource which does not exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CodeGuruProfilerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CodeGuruProfilerClient.ListProfileTimes
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/codeguruprofiler-2019-07-18/ListProfileTimes"
     *      target="_top">AWS API Documentation</a>
     */
    default ListProfileTimesIterable listProfileTimesPaginator(Consumer<ListProfileTimesRequest.Builder> listProfileTimesRequest)
            throws InternalServerException, ValidationException, ThrottlingException, ResourceNotFoundException,
            AwsServiceException, SdkClientException, CodeGuruProfilerException {
        return listProfileTimesPaginator(ListProfileTimesRequest.builder().applyMutation(listProfileTimesRequest).build());
    }

    /**
     * <p>
     * List profiling groups in the account.
     * </p>
     *
     * @param listProfilingGroupsRequest
     *        Request for ListProfilingGroups operation.
     * @return Result of the ListProfilingGroups operation returned by the service.
     * @throws InternalServerException
     *         Unexpected error during processing of request.
     * @throws ThrottlingException
     *         Request was denied due to request throttling.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CodeGuruProfilerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CodeGuruProfilerClient.ListProfilingGroups
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/codeguruprofiler-2019-07-18/ListProfilingGroups"
     *      target="_top">AWS API Documentation</a>
     */
    default ListProfilingGroupsResponse listProfilingGroups(ListProfilingGroupsRequest listProfilingGroupsRequest)
            throws InternalServerException, ThrottlingException, AwsServiceException, SdkClientException,
            CodeGuruProfilerException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * List profiling groups in the account.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListProfilingGroupsRequest.Builder} avoiding the
     * need to create one manually via {@link ListProfilingGroupsRequest#builder()}
     * </p>
     *
     * @param listProfilingGroupsRequest
     *        A {@link Consumer} that will call methods on {@link ListProfilingGroupsRequest.Builder} to create a
     *        request. Request for ListProfilingGroups operation.
     * @return Result of the ListProfilingGroups operation returned by the service.
     * @throws InternalServerException
     *         Unexpected error during processing of request.
     * @throws ThrottlingException
     *         Request was denied due to request throttling.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CodeGuruProfilerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CodeGuruProfilerClient.ListProfilingGroups
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/codeguruprofiler-2019-07-18/ListProfilingGroups"
     *      target="_top">AWS API Documentation</a>
     */
    default ListProfilingGroupsResponse listProfilingGroups(
            Consumer<ListProfilingGroupsRequest.Builder> listProfilingGroupsRequest) throws InternalServerException,
            ThrottlingException, AwsServiceException, SdkClientException, CodeGuruProfilerException {
        return listProfilingGroups(ListProfilingGroupsRequest.builder().applyMutation(listProfilingGroupsRequest).build());
    }

    /**
     * <p>
     * List profiling groups in the account.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listProfilingGroups(software.amazon.awssdk.services.codeguruprofiler.model.ListProfilingGroupsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.codeguruprofiler.paginators.ListProfilingGroupsIterable responses = client.listProfilingGroupsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.codeguruprofiler.paginators.ListProfilingGroupsIterable responses = client
     *             .listProfilingGroupsPaginator(request);
     *     for (software.amazon.awssdk.services.codeguruprofiler.model.ListProfilingGroupsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.codeguruprofiler.paginators.ListProfilingGroupsIterable responses = client.listProfilingGroupsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listProfilingGroups(software.amazon.awssdk.services.codeguruprofiler.model.ListProfilingGroupsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listProfilingGroupsRequest
     *        Request for ListProfilingGroups operation.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InternalServerException
     *         Unexpected error during processing of request.
     * @throws ThrottlingException
     *         Request was denied due to request throttling.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CodeGuruProfilerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CodeGuruProfilerClient.ListProfilingGroups
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/codeguruprofiler-2019-07-18/ListProfilingGroups"
     *      target="_top">AWS API Documentation</a>
     */
    default ListProfilingGroupsIterable listProfilingGroupsPaginator(ListProfilingGroupsRequest listProfilingGroupsRequest)
            throws InternalServerException, ThrottlingException, AwsServiceException, SdkClientException,
            CodeGuruProfilerException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * List profiling groups in the account.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listProfilingGroups(software.amazon.awssdk.services.codeguruprofiler.model.ListProfilingGroupsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.codeguruprofiler.paginators.ListProfilingGroupsIterable responses = client.listProfilingGroupsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.codeguruprofiler.paginators.ListProfilingGroupsIterable responses = client
     *             .listProfilingGroupsPaginator(request);
     *     for (software.amazon.awssdk.services.codeguruprofiler.model.ListProfilingGroupsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.codeguruprofiler.paginators.ListProfilingGroupsIterable responses = client.listProfilingGroupsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listProfilingGroups(software.amazon.awssdk.services.codeguruprofiler.model.ListProfilingGroupsRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListProfilingGroupsRequest.Builder} avoiding the
     * need to create one manually via {@link ListProfilingGroupsRequest#builder()}
     * </p>
     *
     * @param listProfilingGroupsRequest
     *        A {@link Consumer} that will call methods on {@link ListProfilingGroupsRequest.Builder} to create a
     *        request. Request for ListProfilingGroups operation.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InternalServerException
     *         Unexpected error during processing of request.
     * @throws ThrottlingException
     *         Request was denied due to request throttling.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CodeGuruProfilerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CodeGuruProfilerClient.ListProfilingGroups
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/codeguruprofiler-2019-07-18/ListProfilingGroups"
     *      target="_top">AWS API Documentation</a>
     */
    default ListProfilingGroupsIterable listProfilingGroupsPaginator(
            Consumer<ListProfilingGroupsRequest.Builder> listProfilingGroupsRequest) throws InternalServerException,
            ThrottlingException, AwsServiceException, SdkClientException, CodeGuruProfilerException {
        return listProfilingGroupsPaginator(ListProfilingGroupsRequest.builder().applyMutation(listProfilingGroupsRequest)
                .build());
    }

    /**
     * <p>
     * Submit profile collected by an agent belonging to a profiling group for aggregation.
     * </p>
     *
     * @param postAgentProfileRequest
     *        Request for PostAgentProfile operation.
     * @return Result of the PostAgentProfile operation returned by the service.
     * @throws InternalServerException
     *         Unexpected error during processing of request.
     * @throws ValidationException
     *         The input fails to satisfy the constraints of the API.
     * @throws ThrottlingException
     *         Request was denied due to request throttling.
     * @throws ResourceNotFoundException
     *         Request references a resource which does not exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CodeGuruProfilerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CodeGuruProfilerClient.PostAgentProfile
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/codeguruprofiler-2019-07-18/PostAgentProfile"
     *      target="_top">AWS API Documentation</a>
     */
    default PostAgentProfileResponse postAgentProfile(PostAgentProfileRequest postAgentProfileRequest)
            throws InternalServerException, ValidationException, ThrottlingException, ResourceNotFoundException,
            AwsServiceException, SdkClientException, CodeGuruProfilerException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Submit profile collected by an agent belonging to a profiling group for aggregation.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link PostAgentProfileRequest.Builder} avoiding the need
     * to create one manually via {@link PostAgentProfileRequest#builder()}
     * </p>
     *
     * @param postAgentProfileRequest
     *        A {@link Consumer} that will call methods on {@link PostAgentProfileRequest.Builder} to create a request.
     *        Request for PostAgentProfile operation.
     * @return Result of the PostAgentProfile operation returned by the service.
     * @throws InternalServerException
     *         Unexpected error during processing of request.
     * @throws ValidationException
     *         The input fails to satisfy the constraints of the API.
     * @throws ThrottlingException
     *         Request was denied due to request throttling.
     * @throws ResourceNotFoundException
     *         Request references a resource which does not exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CodeGuruProfilerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CodeGuruProfilerClient.PostAgentProfile
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/codeguruprofiler-2019-07-18/PostAgentProfile"
     *      target="_top">AWS API Documentation</a>
     */
    default PostAgentProfileResponse postAgentProfile(Consumer<PostAgentProfileRequest.Builder> postAgentProfileRequest)
            throws InternalServerException, ValidationException, ThrottlingException, ResourceNotFoundException,
            AwsServiceException, SdkClientException, CodeGuruProfilerException {
        return postAgentProfile(PostAgentProfileRequest.builder().applyMutation(postAgentProfileRequest).build());
    }

    /**
     * <p>
     * Update a profiling group.
     * </p>
     *
     * @param updateProfilingGroupRequest
     *        Request for UpdateProfilingGroup operation.
     * @return Result of the UpdateProfilingGroup operation returned by the service.
     * @throws InternalServerException
     *         Unexpected error during processing of request.
     * @throws ConflictException
     *         Request can can cause an inconsistent state for the resource.
     * @throws ValidationException
     *         The input fails to satisfy the constraints of the API.
     * @throws ThrottlingException
     *         Request was denied due to request throttling.
     * @throws ResourceNotFoundException
     *         Request references a resource which does not exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CodeGuruProfilerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CodeGuruProfilerClient.UpdateProfilingGroup
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/codeguruprofiler-2019-07-18/UpdateProfilingGroup"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateProfilingGroupResponse updateProfilingGroup(UpdateProfilingGroupRequest updateProfilingGroupRequest)
            throws InternalServerException, ConflictException, ValidationException, ThrottlingException,
            ResourceNotFoundException, AwsServiceException, SdkClientException, CodeGuruProfilerException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Update a profiling group.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateProfilingGroupRequest.Builder} avoiding the
     * need to create one manually via {@link UpdateProfilingGroupRequest#builder()}
     * </p>
     *
     * @param updateProfilingGroupRequest
     *        A {@link Consumer} that will call methods on {@link UpdateProfilingGroupRequest.Builder} to create a
     *        request. Request for UpdateProfilingGroup operation.
     * @return Result of the UpdateProfilingGroup operation returned by the service.
     * @throws InternalServerException
     *         Unexpected error during processing of request.
     * @throws ConflictException
     *         Request can can cause an inconsistent state for the resource.
     * @throws ValidationException
     *         The input fails to satisfy the constraints of the API.
     * @throws ThrottlingException
     *         Request was denied due to request throttling.
     * @throws ResourceNotFoundException
     *         Request references a resource which does not exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CodeGuruProfilerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CodeGuruProfilerClient.UpdateProfilingGroup
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/codeguruprofiler-2019-07-18/UpdateProfilingGroup"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateProfilingGroupResponse updateProfilingGroup(
            Consumer<UpdateProfilingGroupRequest.Builder> updateProfilingGroupRequest) throws InternalServerException,
            ConflictException, ValidationException, ThrottlingException, ResourceNotFoundException, AwsServiceException,
            SdkClientException, CodeGuruProfilerException {
        return updateProfilingGroup(UpdateProfilingGroupRequest.builder().applyMutation(updateProfilingGroupRequest).build());
    }

    static ServiceMetadata serviceMetadata() {
        return ServiceMetadata.of("codeguru-profiler");
    }
}
