/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.codegen;

import software.amazon.awssdk.codegen.model.config.customization.CustomizationConfig;
import software.amazon.awssdk.codegen.model.intermediate.Metadata;
import software.amazon.awssdk.codegen.model.intermediate.Protocol;
import software.amazon.awssdk.codegen.model.service.AuthType;
import software.amazon.awssdk.codegen.model.service.Operation;
import software.amazon.awssdk.codegen.model.service.ServiceMetadata;
import software.amazon.awssdk.codegen.model.service.ServiceModel;
import software.amazon.awssdk.codegen.naming.DefaultNamingStrategy;

final class AddMetadata {
    private static final String AWS_PACKAGE_PREFIX = "software.amazon.awssdk.services";

    private AddMetadata() {
    }

    public static Metadata constructMetadata(ServiceModel serviceModel, CustomizationConfig customizationConfig) {
        Metadata metadata = new Metadata();
        DefaultNamingStrategy namingStrategy = new DefaultNamingStrategy(serviceModel, customizationConfig);
        ServiceMetadata serviceMetadata = serviceModel.getMetadata();
        if (serviceMetadata.getProtocol().equals(Protocol.API_GATEWAY.getValue())) {
            throw new UnsupportedOperationException("Java SDK V2 doesn't support api-gateway protocol yet");
        }
        String serviceName = namingStrategy.getServiceName();
        String rootPackageName = AWS_PACKAGE_PREFIX;
        metadata.withApiVersion(serviceMetadata.getApiVersion()).withAsyncClient(String.format("Default%sAsyncClient", serviceName)).withAsyncInterface(String.format("%sAsyncClient", serviceName)).withAsyncBuilder(String.format("Default%sAsyncClientBuilder", serviceName)).withAsyncBuilderInterface(String.format("%sAsyncClientBuilder", serviceName)).withBaseBuilderInterface(String.format("%sBaseClientBuilder", serviceName)).withBaseBuilder(String.format("Default%sBaseClientBuilder", serviceName)).withDocumentation(serviceModel.getDocumentation()).withRootPackageName(rootPackageName).withClientPackageName(namingStrategy.getClientPackageName(serviceName)).withModelPackageName(namingStrategy.getModelPackageName(serviceName)).withTransformPackageName(namingStrategy.getTransformPackageName(serviceName)).withRequestTransformPackageName(namingStrategy.getRequestTransformPackageName(serviceName)).withPaginatorsPackageName(namingStrategy.getPaginatorsPackageName(serviceName)).withServiceAbbreviation(serviceMetadata.getServiceAbbreviation()).withServiceFullName(serviceMetadata.getServiceFullName()).withServiceName(serviceName).withSyncClient(String.format("Default%sClient", serviceName)).withSyncInterface(String.format("%sClient", serviceName)).withSyncBuilder(String.format("Default%sClientBuilder", serviceName)).withSyncBuilderInterface(String.format("%sClientBuilder", serviceName)).withBaseExceptionName(String.format("%sException", serviceName)).withBaseRequestName(String.format("%sRequest", serviceName)).withBaseResponseName(String.format("%sResponse", serviceName)).withProtocol(Protocol.fromValue(serviceMetadata.getProtocol())).withJsonVersion(serviceMetadata.getJsonVersion()).withEndpointPrefix(serviceMetadata.getEndpointPrefix()).withSigningName(serviceMetadata.getSigningName()).withAuthType(AuthType.fromValue(serviceMetadata.getSignatureVersion())).withRequiresApiKey(AddMetadata.requiresApiKey(serviceModel)).withUid(serviceMetadata.getUid()).withServiceId(serviceMetadata.getServiceId()).withSupportsH2(AddMetadata.supportsH2(serviceMetadata));
        String jsonVersion = AddMetadata.getJsonVersion(metadata, serviceMetadata);
        metadata.setJsonVersion(jsonVersion);
        return metadata;
    }

    private static boolean supportsH2(ServiceMetadata serviceMetadata) {
        return serviceMetadata.getProtocolSettings() != null && serviceMetadata.getProtocolSettings().containsKey("h2");
    }

    private static String getJsonVersion(Metadata metadata, ServiceMetadata serviceMetadata) {
        if (serviceMetadata.getJsonVersion() == null && metadata.isJsonProtocol()) {
            return "1.1";
        }
        return serviceMetadata.getJsonVersion();
    }

    private static boolean requiresApiKey(ServiceModel serviceModel) {
        return serviceModel.getOperations().values().stream().anyMatch(Operation::requiresApiKey);
    }
}

