/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.codegen.model.intermediate;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.List;
import java.util.Map;
import software.amazon.awssdk.codegen.internal.Constant;
import software.amazon.awssdk.codegen.internal.DocumentationUtils;
import software.amazon.awssdk.codegen.internal.TypeUtils;
import software.amazon.awssdk.codegen.model.intermediate.DocumentationModel;
import software.amazon.awssdk.codegen.model.intermediate.ListModel;
import software.amazon.awssdk.codegen.model.intermediate.MapModel;
import software.amazon.awssdk.codegen.model.intermediate.ParameterHttpMapping;
import software.amazon.awssdk.codegen.model.intermediate.ReturnTypeModel;
import software.amazon.awssdk.codegen.model.intermediate.ShapeModel;
import software.amazon.awssdk.codegen.model.intermediate.VariableModel;
import software.amazon.awssdk.core.SdkBytes;
import software.amazon.awssdk.protocols.core.PathMarshaller;
import software.amazon.awssdk.utils.StringUtils;

public class MemberModel
extends DocumentationModel {
    private String name;
    private String c2jName;
    private String c2jShape;
    private VariableModel variable;
    private VariableModel setterModel;
    private ReturnTypeModel getterModel;
    private ParameterHttpMapping http;
    private boolean deprecated;
    private ListModel listModel;
    private MapModel mapModel;
    private String enumType;
    private String xmlNameSpaceUri;
    private boolean idempotencyToken;
    private ShapeModel shape;
    private String fluentGetterMethodName;
    private String fluentEnumGetterMethodName;
    private String fluentSetterMethodName;
    private String fluentEnumSetterMethodName;
    private String beanStyleGetterName;
    private String beanStyleSetterName;
    private boolean isJsonValue;
    private String timestampFormat;
    private boolean eventPayload;
    private boolean eventHeader;
    private boolean endpointDiscoveryId;
    private boolean sensitive;
    private boolean xmlAttribute;

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public MemberModel withName(String name) {
        this.setName(name);
        return this;
    }

    public String getC2jName() {
        return this.c2jName;
    }

    public void setC2jName(String c2jName) {
        this.c2jName = c2jName;
    }

    public MemberModel withC2jName(String c2jName) {
        this.setC2jName(c2jName);
        return this;
    }

    public String getC2jShape() {
        return this.c2jShape;
    }

    public void setC2jShape(String c2jShape) {
        this.c2jShape = c2jShape;
    }

    public MemberModel withC2jShape(String c2jShape) {
        this.setC2jShape(c2jShape);
        return this;
    }

    public VariableModel getVariable() {
        return this.variable;
    }

    public void setVariable(VariableModel variable) {
        this.variable = variable;
    }

    public MemberModel withVariable(VariableModel variable) {
        this.setVariable(variable);
        return this;
    }

    public VariableModel getSetterModel() {
        return this.setterModel;
    }

    public void setSetterModel(VariableModel setterModel) {
        this.setterModel = setterModel;
    }

    public MemberModel withSetterModel(VariableModel setterModel) {
        this.setSetterModel(setterModel);
        return this;
    }

    public String getFluentGetterMethodName() {
        return this.fluentGetterMethodName;
    }

    public void setFluentGetterMethodName(String fluentGetterMethodName) {
        this.fluentGetterMethodName = fluentGetterMethodName;
    }

    public MemberModel withFluentGetterMethodName(String getterMethodName) {
        this.setFluentGetterMethodName(getterMethodName);
        return this;
    }

    public String getFluentEnumGetterMethodName() {
        return this.fluentEnumGetterMethodName;
    }

    public void setFluentEnumGetterMethodName(String fluentEnumGetterMethodName) {
        this.fluentEnumGetterMethodName = fluentEnumGetterMethodName;
    }

    public MemberModel withFluentEnumGetterMethodName(String fluentEnumGetterMethodName) {
        this.setFluentEnumGetterMethodName(fluentEnumGetterMethodName);
        return this;
    }

    public String getBeanStyleGetterMethodName() {
        return this.beanStyleGetterName;
    }

    public void setBeanStyleGetterMethodName(String beanStyleGetterName) {
        this.beanStyleGetterName = beanStyleGetterName;
    }

    public MemberModel withBeanStyleGetterMethodName(String beanStyleGetterName) {
        this.beanStyleGetterName = beanStyleGetterName;
        return this;
    }

    public String getBeanStyleSetterMethodName() {
        return this.beanStyleSetterName;
    }

    public void setBeanStyleSetterMethodName(String beanStyleSetterName) {
        this.beanStyleSetterName = beanStyleSetterName;
    }

    public MemberModel withBeanStyleSetterMethodName(String beanStyleSetterName) {
        this.beanStyleSetterName = beanStyleSetterName;
        return this;
    }

    public String getSetterMethodName() {
        return this.getBeanStyleSetterMethodName();
    }

    public void setSetterMethodName(String setterMethodName) {
        this.setBeanStyleGetterMethodName(setterMethodName);
    }

    public MemberModel withSetterMethodName(String setterMethodName) {
        this.setSetterMethodName(setterMethodName);
        return this;
    }

    public String getFluentSetterMethodName() {
        return this.fluentSetterMethodName;
    }

    public void setFluentSetterMethodName(String fluentSetterMethodName) {
        this.fluentSetterMethodName = fluentSetterMethodName;
    }

    public MemberModel withFluentSetterMethodName(String fluentMethodName) {
        this.setFluentSetterMethodName(fluentMethodName);
        return this;
    }

    public String getFluentEnumSetterMethodName() {
        return this.fluentEnumSetterMethodName;
    }

    public void setFluentEnumSetterMethodName(String fluentEnumSetterMethodName) {
        this.fluentEnumSetterMethodName = fluentEnumSetterMethodName;
    }

    public MemberModel withFluentEnumSetterMethodName(String fluentEnumSetterMethodName) {
        this.setFluentEnumSetterMethodName(fluentEnumSetterMethodName);
        return this;
    }

    public ReturnTypeModel getGetterModel() {
        return this.getterModel;
    }

    public void setGetterModel(ReturnTypeModel getterModel) {
        this.getterModel = getterModel;
    }

    public MemberModel withGetterModel(ReturnTypeModel getterModel) {
        this.setGetterModel(getterModel);
        return this;
    }

    public ParameterHttpMapping getHttp() {
        return this.http;
    }

    public void setHttp(ParameterHttpMapping parameterHttpMapping) {
        this.http = parameterHttpMapping;
    }

    public boolean isSimple() {
        return TypeUtils.isSimple(this.variable.getVariableType());
    }

    public boolean isList() {
        return this.listModel != null;
    }

    public boolean isMap() {
        return this.mapModel != null;
    }

    public boolean isDeprecated() {
        return this.deprecated;
    }

    public void setDeprecated(boolean deprecated) {
        this.deprecated = deprecated;
    }

    public boolean isEventPayload() {
        return this.eventPayload;
    }

    public void setEventPayload(boolean eventPayload) {
        this.eventPayload = eventPayload;
    }

    public boolean isEventHeader() {
        return this.eventHeader;
    }

    public void setEventHeader(boolean eventHeader) {
        this.eventHeader = eventHeader;
    }

    public boolean isEndpointDiscoveryId() {
        return this.endpointDiscoveryId;
    }

    public void setEndpointDiscoveryId(boolean endpointDiscoveryId) {
        this.endpointDiscoveryId = endpointDiscoveryId;
    }

    public ListModel getListModel() {
        return this.listModel;
    }

    public void setListModel(ListModel listModel) {
        this.listModel = listModel;
    }

    public MemberModel withListModel(ListModel list) {
        this.setListModel(list);
        return this;
    }

    public MapModel getMapModel() {
        return this.mapModel;
    }

    public void setMapModel(MapModel map) {
        this.mapModel = map;
    }

    public MemberModel withMapModel(MapModel map) {
        this.setMapModel(map);
        return this;
    }

    public String getEnumType() {
        return this.enumType;
    }

    public void setEnumType(String enumType) {
        this.enumType = enumType;
    }

    public MemberModel withEnumType(String enumType) {
        this.setEnumType(enumType);
        return this;
    }

    public String getXmlNameSpaceUri() {
        return this.xmlNameSpaceUri;
    }

    public void setXmlNameSpaceUri(String xmlNameSpaceUri) {
        this.xmlNameSpaceUri = xmlNameSpaceUri;
    }

    public MemberModel withXmlNameSpaceUri(String xmlNameSpaceUri) {
        this.setXmlNameSpaceUri(xmlNameSpaceUri);
        return this;
    }

    public String getSetterDocumentation() {
        StringBuilder docBuilder = new StringBuilder();
        docBuilder.append(StringUtils.isNotBlank((CharSequence)this.documentation) ? this.documentation : DocumentationUtils.defaultSetter().replace("%s", this.name) + "\n");
        docBuilder.append(this.getParamDoc()).append(this.getEnumDoc());
        return docBuilder.toString();
    }

    public String getGetterDocumentation() {
        StringBuilder docBuilder = new StringBuilder();
        docBuilder.append(StringUtils.isNotBlank((CharSequence)this.documentation) ? this.documentation : DocumentationUtils.defaultGetter().replace("%s", this.name)).append(Constant.LF);
        if (this.returnTypeIs(List.class) || this.returnTypeIs(Map.class)) {
            this.appendParagraph(docBuilder, "Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.", new Object[0]);
        }
        if (this.enumType != null) {
            if (this.returnTypeIs(List.class)) {
                this.appendParagraph(docBuilder, "If the list returned by the service includes enum values that are not available in the current SDK version, {@link #%s} will use {@link %s#UNKNOWN_TO_SDK_VERSION} in place of those values in the list. The raw values returned by the service are available from {@link #%s}.", this.getFluentEnumGetterMethodName(), this.getEnumType(), this.getFluentGetterMethodName());
            } else if (this.returnTypeIs(Map.class)) {
                this.appendParagraph(docBuilder, "If the map returned by the service includes enum values that are not available in the current SDK version, {@link #%s} will not include those keys in the map. {@link #%s} will include all data from the service.", this.getFluentEnumGetterMethodName(), this.getEnumType(), this.getFluentGetterMethodName());
            } else {
                this.appendParagraph(docBuilder, "If the service returns an enum value that is not available in the current SDK version, {@link #%s} will return {@link %s#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from {@link #%s}.", this.getFluentEnumGetterMethodName(), this.getEnumType(), this.getFluentGetterMethodName());
            }
        }
        String variableDesc = StringUtils.isNotBlank((CharSequence)this.documentation) ? this.documentation : DocumentationUtils.defaultGetterParam().replace("%s", this.name);
        docBuilder.append("@return ").append(DocumentationUtils.stripHtmlTags(variableDesc)).append(this.getEnumDoc());
        return docBuilder.toString();
    }

    private boolean returnTypeIs(Class<?> clazz) {
        String returnType = this.getGetterModel().getReturnType();
        return returnType != null && returnType.startsWith(clazz.getName());
    }

    public String getFluentSetterDocumentation() {
        return this.getSetterDocumentation() + Constant.LF + "@return " + DocumentationUtils.stripHtmlTags(DocumentationUtils.defaultFluentReturn()) + this.getEnumDoc();
    }

    public String getDefaultConsumerFluentSetterDocumentation() {
        return (StringUtils.isNotBlank((CharSequence)this.documentation) ? this.documentation : DocumentationUtils.defaultSetter().replace("%s", this.name) + "\n") + Constant.LF + "This is a convenience that creates an instance of the {@link " + this.variable.getSimpleType() + ".Builder} avoiding the need to create one manually via {@link " + this.variable.getSimpleType() + "#builder()}.\n" + Constant.LF + "When the {@link Consumer} completes, {@link " + this.variable.getSimpleType() + ".Builder#build()} is called immediately and its result is passed to {@link #" + this.getFluentGetterMethodName() + "(" + this.variable.getSimpleType() + ")}." + Constant.LF + "@param " + this.variable.getVariableName() + " a consumer that will call methods on {@link " + this.variable.getSimpleType() + ".Builder}" + Constant.LF + "@return " + DocumentationUtils.stripHtmlTags(DocumentationUtils.defaultFluentReturn()) + Constant.LF + "@see #" + this.getFluentSetterMethodName() + "(" + this.variable.getSimpleType() + ")";
    }

    private String getParamDoc() {
        return Constant.LF + "@param " + this.variable.getVariableName() + " " + DocumentationUtils.stripHtmlTags(StringUtils.isNotBlank((CharSequence)this.documentation) ? this.documentation : DocumentationUtils.defaultSetterParam().replace("%s", this.name));
    }

    private String getEnumDoc() {
        StringBuilder docBuilder = new StringBuilder();
        if (this.enumType != null) {
            docBuilder.append(Constant.LF).append("@see ").append(this.enumType);
        }
        return docBuilder.toString();
    }

    public boolean isIdempotencyToken() {
        return this.idempotencyToken;
    }

    public void setIdempotencyToken(boolean idempotencyToken) {
        this.idempotencyToken = idempotencyToken;
    }

    public boolean getIsBinary() {
        return this.http.getIsStreaming() || this.isSdkBytesType() && (this.http.getIsPayload() || this.isEventPayload());
    }

    @JsonIgnore
    public String getPathMarshaller() {
        if (!this.http.isUri()) {
            throw new IllegalStateException("Only members bound to the URI have a path marshaller");
        }
        String prefix = PathMarshaller.class.getName();
        if (this.http.isGreedy()) {
            return prefix + ".GREEDY";
        }
        if (this.isIdempotencyToken()) {
            return prefix + ".IDEMPOTENCY";
        }
        return prefix + ".NON_GREEDY";
    }

    public boolean isJsonValue() {
        return this.isJsonValue;
    }

    public void setJsonValue(boolean jsonValue) {
        this.isJsonValue = jsonValue;
    }

    public MemberModel withJsonValue(boolean jsonValue) {
        this.setJsonValue(jsonValue);
        return this;
    }

    public String getTimestampFormat() {
        return this.timestampFormat;
    }

    public void setTimestampFormat(String timestampFormat) {
        this.timestampFormat = timestampFormat;
    }

    public MemberModel withTimestampFormat(String timestampFormat) {
        this.setTimestampFormat(timestampFormat);
        return this;
    }

    public void setSensitive(boolean sensitive) {
        this.sensitive = sensitive;
    }

    public boolean isSensitive() {
        return this.sensitive;
    }

    public boolean isXmlAttribute() {
        return this.xmlAttribute;
    }

    public void setXmlAttribute(boolean xmlAttribute) {
        this.xmlAttribute = xmlAttribute;
    }

    public MemberModel withXmlAttribtue(boolean xmlAttribtue) {
        this.xmlAttribute = xmlAttribtue;
        return this;
    }

    @JsonIgnore
    public boolean hasBuilder() {
        return !this.isSimple() && !this.isList() && !this.isMap();
    }

    @JsonIgnore
    public boolean isCollectionWithBuilderMember() {
        return this.isList() && this.getListModel().getListMemberModel() != null && this.getListModel().getListMemberModel().hasBuilder() || this.isMap() && this.getMapModel().getValueModel() != null && this.getMapModel().getValueModel().hasBuilder();
    }

    @JsonIgnore
    public boolean isSdkBytesType() {
        return SdkBytes.class.getName().equals(this.variable.getVariableType());
    }

    public String getMarshallingType() {
        if (this.isList()) {
            return "LIST";
        }
        if (this.isMap()) {
            return "MAP";
        }
        if (!this.isSimple()) {
            return "SDK_POJO";
        }
        return TypeUtils.getMarshallingType(this.variable.getSimpleType());
    }

    @JsonIgnore
    public ShapeModel getShape() {
        return this.shape;
    }

    public void setShape(ShapeModel shape) {
        this.shape = shape;
    }

    public String toString() {
        return this.c2jName;
    }

    private void appendParagraph(StringBuilder builder, String content, Object ... contentArgs) {
        builder.append("<p>").append(Constant.LF).append(String.format(content, contentArgs)).append(Constant.LF).append("</p>").append(Constant.LF);
    }
}

