/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.codegen.emitters.tasks;

import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.codegen.emitters.GeneratorTask;
import software.amazon.awssdk.codegen.emitters.GeneratorTaskParams;
import software.amazon.awssdk.codegen.emitters.PoetGeneratorTask;
import software.amazon.awssdk.codegen.emitters.tasks.BaseGeneratorTasks;
import software.amazon.awssdk.codegen.model.intermediate.OperationModel;
import software.amazon.awssdk.codegen.poet.ClassSpec;
import software.amazon.awssdk.codegen.poet.eventstream.EventStreamResponseHandlerBuilderImplSpec;
import software.amazon.awssdk.codegen.poet.eventstream.EventStreamResponseHandlerSpec;
import software.amazon.awssdk.codegen.poet.eventstream.EventStreamVisitorBuilderImplSpec;

class EventStreamGeneratorTasks
extends BaseGeneratorTasks {
    private final GeneratorTaskParams params;

    EventStreamGeneratorTasks(GeneratorTaskParams dependencies) {
        super(dependencies);
        this.params = dependencies;
    }

    @Override
    protected List<GeneratorTask> createTasks() throws Exception {
        this.info("Emitting event stream classes");
        String fileHeader = this.model.getFileHeader();
        String modelDirectory = this.params.getPathProvider().getModelDirectory();
        return this.model.getOperations().values().stream().filter(OperationModel::hasEventStreamOutput).flatMap(this::eventStreamClassSpecs).map(spec -> new PoetGeneratorTask(modelDirectory, fileHeader, (ClassSpec)spec)).collect(Collectors.toList());
    }

    private Stream<ClassSpec> eventStreamClassSpecs(OperationModel opModel) {
        return Stream.of(new EventStreamResponseHandlerSpec(this.params, opModel), new EventStreamResponseHandlerBuilderImplSpec(this.params, opModel), new EventStreamVisitorBuilderImplSpec(this.params, opModel));
    }
}

