/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.codegen;

import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import software.amazon.awssdk.codegen.C2jModels;
import software.amazon.awssdk.codegen.IntermediateModelBuilder;
import software.amazon.awssdk.codegen.emitters.CodeEmitter;
import software.amazon.awssdk.codegen.emitters.GeneratorTask;
import software.amazon.awssdk.codegen.emitters.GeneratorTaskExecutor;
import software.amazon.awssdk.codegen.emitters.GeneratorTaskParams;
import software.amazon.awssdk.codegen.emitters.tasks.ApiGatewayGeneratorTasks;
import software.amazon.awssdk.codegen.emitters.tasks.AwsGeneratorTasks;
import software.amazon.awssdk.codegen.internal.Jackson;
import software.amazon.awssdk.codegen.internal.Utils;
import software.amazon.awssdk.codegen.model.intermediate.IntermediateModel;
import software.amazon.awssdk.codegen.model.intermediate.Protocol;

public class CodeGenerator {
    private static final String MODEL_DIR_NAME = "models";
    private final C2jModels models;
    private final String sourcesDirectory;
    private final String testsDirectory;
    private final String fileNamePrefix;

    public CodeGenerator(Builder builder) {
        this.models = builder.models;
        this.sourcesDirectory = builder.sourcesDirectory;
        this.testsDirectory = builder.testsDirectory;
        this.fileNamePrefix = builder.fileNamePrefix;
    }

    public static File getModelDirectory(String outputDirectory) {
        File dir = new File(outputDirectory, MODEL_DIR_NAME);
        Utils.createDirectory(dir);
        return dir;
    }

    public static Builder builder() {
        return new Builder();
    }

    public void execute() {
        try {
            IntermediateModel intermediateModel = new IntermediateModelBuilder(this.models).build();
            this.writeIntermediateModel(intermediateModel);
            this.emitCode(intermediateModel);
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to generate code. Exception message : " + e.getMessage(), e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeIntermediateModel(IntermediateModel model) throws IOException {
        File modelDir = CodeGenerator.getModelDirectory(this.sourcesDirectory);
        PrintWriter writer = null;
        try {
            File outDir = new File(this.sourcesDirectory);
            if (!outDir.exists() && !outDir.mkdirs()) {
                throw new RuntimeException("Failed to create " + outDir.getAbsolutePath());
            }
            File outputFile = new File(modelDir, this.fileNamePrefix + "-intermediate.json");
            if (!outputFile.exists() && !outputFile.createNewFile()) {
                throw new RuntimeException("Error creating file " + outputFile.getAbsolutePath());
            }
            writer = new PrintWriter(outputFile, "UTF-8");
            Jackson.write(model, writer);
        }
        finally {
            if (writer != null) {
                writer.flush();
                writer.close();
            }
        }
    }

    private void emitCode(IntermediateModel intermediateModel) {
        Iterable<GeneratorTask> generatorTasks = this.createGeneratorTasks(intermediateModel);
        try (CodeEmitter emitter = new CodeEmitter(generatorTasks, new GeneratorTaskExecutor());){
            emitter.emit();
        }
    }

    private Iterable<GeneratorTask> createGeneratorTasks(IntermediateModel intermediateModel) {
        GeneratorTaskParams params = GeneratorTaskParams.create(intermediateModel, this.sourcesDirectory, this.testsDirectory);
        if (params.getModel().getMetadata().getProtocol() == Protocol.API_GATEWAY) {
            return new ApiGatewayGeneratorTasks(params);
        }
        return new AwsGeneratorTasks(params);
    }

    public static final class Builder {
        private C2jModels models;
        private String sourcesDirectory;
        private String testsDirectory;
        private String fileNamePrefix;

        private Builder() {
        }

        public Builder models(C2jModels models) {
            this.models = models;
            return this;
        }

        public Builder sourcesDirectory(String sourcesDirectory) {
            this.sourcesDirectory = sourcesDirectory;
            return this;
        }

        public Builder testsDirectory(String smokeTestsDirectory) {
            this.testsDirectory = smokeTestsDirectory;
            return this;
        }

        public Builder fileNamePrefix(String fileNamePrefix) {
            this.fileNamePrefix = fileNamePrefix;
            return this;
        }

        public CodeGenerator build() {
            return new CodeGenerator(this);
        }
    }
}

