/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.codegen.poet.model;

import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.CodeBlock;
import com.squareup.javapoet.FieldSpec;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.ParameterizedTypeName;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeSpec;
import com.squareup.javapoet.TypeVariableName;
import com.squareup.javapoet.WildcardTypeName;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.lang.model.element.Modifier;
import software.amazon.awssdk.annotations.SdkPublicApi;
import software.amazon.awssdk.codegen.docs.DocumentationBuilder;
import software.amazon.awssdk.codegen.model.intermediate.IntermediateModel;
import software.amazon.awssdk.codegen.model.intermediate.MemberModel;
import software.amazon.awssdk.codegen.model.intermediate.OperationModel;
import software.amazon.awssdk.codegen.model.intermediate.ShapeModel;
import software.amazon.awssdk.codegen.model.intermediate.ShapeType;
import software.amazon.awssdk.codegen.model.intermediate.VariableModel;
import software.amazon.awssdk.codegen.poet.ClassSpec;
import software.amazon.awssdk.codegen.poet.PoetExtensions;
import software.amazon.awssdk.codegen.poet.PoetUtils;
import software.amazon.awssdk.codegen.poet.eventstream.EventStreamUtils;
import software.amazon.awssdk.codegen.poet.model.AwsServiceBaseRequestSpec;
import software.amazon.awssdk.codegen.poet.model.AwsServiceBaseResponseSpec;
import software.amazon.awssdk.codegen.poet.model.MemberCopierSpec;
import software.amazon.awssdk.codegen.poet.model.ModelBuilderSpecs;
import software.amazon.awssdk.codegen.poet.model.ModelMethodOverrides;
import software.amazon.awssdk.codegen.poet.model.ServiceModelCopiers;
import software.amazon.awssdk.codegen.poet.model.ShapeModelSpec;
import software.amazon.awssdk.codegen.poet.model.TypeProvider;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class AwsServiceModel
implements ClassSpec {
    private final IntermediateModel intermediateModel;
    private final ShapeModel shapeModel;
    private final PoetExtensions poetExtensions;
    private final TypeProvider typeProvider;
    private final ShapeModelSpec shapeModelSpec;
    private final ModelMethodOverrides modelMethodOverrides;
    private final ModelBuilderSpecs modelBuilderSpecs;
    private final ServiceModelCopiers serviceModelCopiers;

    public AwsServiceModel(IntermediateModel intermediateModel, ShapeModel shapeModel) {
        this.intermediateModel = intermediateModel;
        this.shapeModel = shapeModel;
        this.poetExtensions = new PoetExtensions(intermediateModel);
        this.typeProvider = new TypeProvider(intermediateModel);
        this.shapeModelSpec = new ShapeModelSpec(this.shapeModel, this.typeProvider, this.poetExtensions, intermediateModel);
        this.modelMethodOverrides = new ModelMethodOverrides(this.poetExtensions);
        this.modelBuilderSpecs = new ModelBuilderSpecs(intermediateModel, this.shapeModel, this.typeProvider);
        this.serviceModelCopiers = new ServiceModelCopiers(this.intermediateModel);
    }

    @Override
    public TypeSpec poetSpec() {
        if (this.shapeModel.isEventStream()) {
            OperationModel opModel = EventStreamUtils.findOperationWithEventStream(this.intermediateModel, this.shapeModel);
            String apiName = this.poetExtensions.getApiName(opModel);
            ClassName modelClass = this.poetExtensions.getModelClassFromShape(this.shapeModel);
            if (EventStreamUtils.doesShapeContainsEventStream(opModel.getOutputShape(), this.shapeModel)) {
                ClassName responseHandlerClass = this.poetExtensions.eventStreamResponseHandlerType(opModel);
                return PoetUtils.createInterfaceBuilder(modelClass).addAnnotation(SdkPublicApi.class).addSuperinterface((TypeName)ClassName.get(SdkPojo.class)).addJavadoc("Base interface for all event types of the $L API.", new Object[]{apiName}).addField(FieldSpec.builder((TypeName)modelClass, (String)"UNKNOWN", (Modifier[])new Modifier[0]).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.STATIC, Modifier.FINAL}).initializer(CodeBlock.builder().add("new $T() {\n        @Override\n        public $T<$T<?>> sdkFields() {\n            return $T.emptyList();\n        }\n        @Override\n        public void accept($T.Visitor visitor) {            \nvisitor.visitDefault(this);\n        }\n    };\n", new Object[]{modelClass, List.class, SdkField.class, Collections.class, responseHandlerClass}).build()).addJavadoc("Special type of {@link $T} for unknown types of events that this version of the SDK does not know about", new Object[]{modelClass}).build()).addMethod(this.acceptMethodSpec(modelClass, responseHandlerClass).addModifiers(new Modifier[]{Modifier.ABSTRACT}).build()).build();
            }
            if (EventStreamUtils.doesShapeContainsEventStream(opModel.getInputShape(), this.shapeModel)) {
                return PoetUtils.createInterfaceBuilder(modelClass).addAnnotation(SdkPublicApi.class).addJavadoc("Base interface for all event types of the $L API.", new Object[]{apiName}).build();
            }
            throw new IllegalArgumentException(this.shapeModel.getShapeName() + " event stream shape is not found in any request or response shape");
        }
        List<FieldSpec> fields = this.shapeModelSpec.fields();
        TypeSpec.Builder specBuilder = TypeSpec.classBuilder((String)this.shapeModel.getShapeName()).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.FINAL}).addAnnotation(PoetUtils.generatedAnnotation()).addSuperinterfaces(this.modelSuperInterfaces()).superclass(this.modelSuperClass()).addMethods(this.modelClassMethods()).addFields(fields).addFields(this.shapeModelSpec.staticFields(new Modifier[0])).addMethod(this.sdkFieldsMethod()).addTypes(this.nestedModelClassTypes());
        if (this.shapeModel.getShapeType() == ShapeType.Model || this.shapeModel.getShapeType() == ShapeType.Exception) {
            specBuilder.addField(FieldSpec.builder(Long.TYPE, (String)"serialVersionUID", (Modifier[])new Modifier[]{Modifier.PRIVATE, Modifier.STATIC, Modifier.FINAL}).initializer("1L", new Object[0]).build());
        }
        if (!fields.isEmpty()) {
            specBuilder.addMethod(this.getterCreator()).addMethod(this.setterCreator());
        }
        if (this.shapeModel.isEvent()) {
            ShapeModel eventStream = EventStreamUtils.getBaseEventStreamShape(this.intermediateModel, this.shapeModel);
            ClassName eventStreamClassName = this.poetExtensions.getModelClassFromShape(eventStream);
            OperationModel opModel = EventStreamUtils.findOperationWithEventStream(this.intermediateModel, eventStream);
            if (EventStreamUtils.doesShapeContainsEventStream(opModel.getOutputShape(), eventStream)) {
                ClassName modelClass = this.poetExtensions.getModelClass(this.shapeModel.getShapeName());
                ClassName responseHandlerClass = this.poetExtensions.eventStreamResponseHandlerType(opModel);
                specBuilder.addSuperinterface((TypeName)eventStreamClassName);
                specBuilder.addMethod(this.acceptMethodSpec(modelClass, responseHandlerClass).addAnnotation(Override.class).addCode(CodeBlock.builder().addStatement("visitor.visit(this)", new Object[0]).build()).build());
            } else if (EventStreamUtils.doesShapeContainsEventStream(opModel.getInputShape(), eventStream)) {
                specBuilder.addSuperinterface((TypeName)eventStreamClassName);
            } else {
                throw new IllegalArgumentException(this.shapeModel.getC2jName() + " event shape is not a member in any request or response event shape");
            }
        }
        if (this.shapeModel.getDocumentation() != null) {
            specBuilder.addJavadoc("$L", new Object[]{this.shapeModel.getDocumentation()});
        }
        return specBuilder.build();
    }

    private MethodSpec sdkFieldsMethod() {
        ParameterizedTypeName sdkFieldType = ParameterizedTypeName.get((ClassName)ClassName.get(SdkField.class), (TypeName[])new TypeName[]{WildcardTypeName.subtypeOf((TypeName)ClassName.get(Object.class))});
        return MethodSpec.methodBuilder((String)"sdkFields").addModifiers(new Modifier[]{Modifier.PUBLIC}).addAnnotation(Override.class).returns((TypeName)ParameterizedTypeName.get((ClassName)ClassName.get(List.class), (TypeName[])new TypeName[]{sdkFieldType})).addCode("return SDK_FIELDS;", new Object[0]).build();
    }

    private MethodSpec getterCreator() {
        TypeVariableName t = TypeVariableName.get((String)"T");
        return MethodSpec.methodBuilder((String)"getter").addTypeVariable(t).addModifiers(new Modifier[]{Modifier.PRIVATE, Modifier.STATIC}).addParameter((TypeName)ParameterizedTypeName.get((ClassName)ClassName.get(Function.class), (TypeName[])new TypeName[]{this.className(), t}), "g", new Modifier[0]).returns((TypeName)ParameterizedTypeName.get((ClassName)ClassName.get(Function.class), (TypeName[])new TypeName[]{ClassName.get(Object.class), t})).addStatement("return obj -> g.apply(($T) obj)", new Object[]{this.className()}).build();
    }

    private MethodSpec setterCreator() {
        TypeVariableName t = TypeVariableName.get((String)"T");
        return MethodSpec.methodBuilder((String)"setter").addTypeVariable(t).addModifiers(new Modifier[]{Modifier.PRIVATE, Modifier.STATIC}).addParameter((TypeName)ParameterizedTypeName.get((ClassName)ClassName.get(BiConsumer.class), (TypeName[])new TypeName[]{this.builderClassName(), t}), "s", new Modifier[0]).returns((TypeName)ParameterizedTypeName.get((ClassName)ClassName.get(BiConsumer.class), (TypeName[])new TypeName[]{ClassName.get(Object.class), t})).addStatement("return (obj, val) -> s.accept(($T) obj, val)", new Object[]{this.builderClassName()}).build();
    }

    private MethodSpec.Builder acceptMethodSpec(ClassName modelClass, ClassName responseHandlerClass) {
        return MethodSpec.methodBuilder((String)"accept").addModifiers(new Modifier[]{Modifier.PUBLIC}).addJavadoc(new DocumentationBuilder().description("Calls the appropriate visit method depending on the subtype of {@link $T}.").param("visitor", "Visitor to invoke.").build(), new Object[]{modelClass}).addParameter((TypeName)responseHandlerClass.nestedClass("Visitor"), "visitor", new Modifier[0]);
    }

    @Override
    public ClassName className() {
        return this.shapeModelSpec.className();
    }

    private ClassName builderClassName() {
        return this.className().nestedClass("Builder");
    }

    private List<TypeName> modelSuperInterfaces() {
        ArrayList<TypeName> interfaces = new ArrayList<TypeName>();
        switch (this.shapeModel.getShapeType()) {
            case Model: {
                interfaces.add((TypeName)ClassName.get(SdkPojo.class));
                interfaces.add((TypeName)ClassName.get(Serializable.class));
                interfaces.add(this.toCopyableBuilderInterface());
                break;
            }
            case Exception: 
            case Request: 
            case Response: {
                interfaces.add(this.toCopyableBuilderInterface());
                break;
            }
        }
        return interfaces;
    }

    private TypeName modelSuperClass() {
        switch (this.shapeModel.getShapeType()) {
            case Request: {
                return this.requestBaseClass();
            }
            case Response: {
                return this.responseBaseClass();
            }
            case Exception: {
                return this.exceptionBaseClass();
            }
        }
        return ClassName.OBJECT;
    }

    private TypeName requestBaseClass() {
        return new AwsServiceBaseRequestSpec(this.intermediateModel).className();
    }

    private TypeName responseBaseClass() {
        return new AwsServiceBaseResponseSpec(this.intermediateModel).className();
    }

    private ClassName exceptionBaseClass() {
        String customExceptionBase = this.intermediateModel.getCustomizationConfig().getSdkModeledExceptionBaseClassName();
        if (customExceptionBase != null) {
            return this.poetExtensions.getModelClass(customExceptionBase);
        }
        return this.poetExtensions.getModelClass(this.intermediateModel.getSdkModeledExceptionBaseClassName());
    }

    private TypeName toCopyableBuilderInterface() {
        return ParameterizedTypeName.get((ClassName)ClassName.get(ToCopyableBuilder.class), (TypeName[])new TypeName[]{this.className().nestedClass("Builder"), this.className()});
    }

    private List<MethodSpec> modelClassMethods() {
        ArrayList<MethodSpec> methodSpecs = new ArrayList<MethodSpec>();
        switch (this.shapeModel.getShapeType()) {
            case Exception: {
                methodSpecs.add(this.exceptionConstructor());
                methodSpecs.add(this.toBuilderMethod());
                methodSpecs.add(this.builderMethod());
                methodSpecs.add(this.serializableBuilderClass());
                methodSpecs.addAll(this.memberGetters());
                break;
            }
            default: {
                methodSpecs.addAll(this.memberGetters());
                methodSpecs.add(this.constructor());
                methodSpecs.add(this.toBuilderMethod());
                methodSpecs.add(this.builderMethod());
                methodSpecs.add(this.serializableBuilderClass());
                methodSpecs.add(this.modelMethodOverrides.hashCodeMethod(this.shapeModel));
                methodSpecs.add(this.modelMethodOverrides.equalsMethod(this.shapeModel));
                methodSpecs.add(this.modelMethodOverrides.toStringMethod(this.shapeModel));
                methodSpecs.add(this.getValueForField());
            }
        }
        return methodSpecs;
    }

    private MethodSpec getValueForField() {
        MethodSpec.Builder methodBuilder = MethodSpec.methodBuilder((String)"getValueForField").addModifiers(new Modifier[]{Modifier.PUBLIC}).addTypeVariable(TypeVariableName.get((String)"T")).returns((TypeName)ParameterizedTypeName.get((ClassName)ClassName.get(Optional.class), (TypeName[])new TypeName[]{TypeVariableName.get((String)"T")})).addParameter(String.class, "fieldName", new Modifier[0]).addParameter((TypeName)ParameterizedTypeName.get((ClassName)ClassName.get(Class.class), (TypeName[])new TypeName[]{TypeVariableName.get((String)"T")}), "clazz", new Modifier[0]);
        if (this.shapeModel.getNonStreamingMembers().isEmpty()) {
            methodBuilder.addStatement("return $T.empty()", new Object[]{Optional.class});
            return methodBuilder.build();
        }
        methodBuilder.beginControlFlow("switch ($L)", new Object[]{"fieldName"});
        this.shapeModel.getNonStreamingMembers().forEach(m -> methodBuilder.addCode("case $S:", new Object[]{m.getC2jName()}).addStatement("return $T.ofNullable(clazz.cast($L()))", new Object[]{Optional.class, m.getFluentGetterMethodName()}));
        methodBuilder.addCode("default:", new Object[0]);
        methodBuilder.addStatement("return $T.empty()", new Object[]{Optional.class});
        methodBuilder.endControlFlow();
        return methodBuilder.build();
    }

    private List<MethodSpec> memberGetters() {
        return this.shapeModel.getNonStreamingMembers().stream().filter(m -> !m.getHttp().getIsStreaming()).flatMap(this::memberGetters).collect(Collectors.toList());
    }

    private Stream<MethodSpec> memberGetters(MemberModel member) {
        ArrayList<MethodSpec> result = new ArrayList<MethodSpec>();
        if (this.shouldGenerateEnumGetter(member)) {
            result.add(this.enumMemberGetter(member));
        }
        result.add(this.memberGetter(member));
        return result.stream();
    }

    private boolean shouldGenerateEnumGetter(MemberModel member) {
        return member.getEnumType() != null || MemberCopierSpec.isEnumCopyAvailable(member);
    }

    private MethodSpec enumMemberGetter(MemberModel member) {
        return MethodSpec.methodBuilder((String)member.getFluentEnumGetterMethodName()).addJavadoc("$L", new Object[]{member.getGetterDocumentation()}).addModifiers(new Modifier[]{Modifier.PUBLIC}).returns(this.typeProvider.enumReturnType(member)).addCode(this.enumGetterStatement(member)).build();
    }

    private MethodSpec memberGetter(MemberModel member) {
        return MethodSpec.methodBuilder((String)member.getFluentGetterMethodName()).addJavadoc("$L", new Object[]{member.getGetterDocumentation()}).addModifiers(new Modifier[]{Modifier.PUBLIC}).returns(this.typeProvider.returnType(member)).addCode(this.getterStatement(member)).build();
    }

    private CodeBlock enumGetterStatement(MemberModel member) {
        String fieldName = member.getVariable().getVariableName();
        if (member.isList() || member.isMap()) {
            Optional<ClassName> copier = this.serviceModelCopiers.copierClassFor(member);
            if (!copier.isPresent()) {
                throw new IllegalStateException("Don't know how to copy " + fieldName + " with enum elements!");
            }
            return CodeBlock.of((String)"return $T.$N($N);", (Object[])new Object[]{copier.get(), this.serviceModelCopiers.stringToEnumCopyMethodName(), fieldName});
        }
        ClassName enumClass = this.poetExtensions.getModelClass(member.getEnumType());
        return CodeBlock.of((String)"return $T.fromValue($N);", (Object[])new Object[]{enumClass, fieldName});
    }

    private CodeBlock getterStatement(MemberModel model) {
        VariableModel modelVariable = model.getVariable();
        return CodeBlock.of((String)"return $N;", (Object[])new Object[]{modelVariable.getVariableName()});
    }

    private List<TypeSpec> nestedModelClassTypes() {
        ArrayList<TypeSpec> nestedClasses = new ArrayList<TypeSpec>();
        switch (this.shapeModel.getShapeType()) {
            case Model: 
            case Exception: 
            case Request: 
            case Response: {
                nestedClasses.add(this.modelBuilderSpecs.builderInterface());
                nestedClasses.add(this.modelBuilderSpecs.beanStyleBuilder());
                break;
            }
        }
        return nestedClasses;
    }

    private MethodSpec constructor() {
        MethodSpec.Builder ctorBuilder = MethodSpec.constructorBuilder().addModifiers(new Modifier[]{Modifier.PRIVATE}).addParameter((TypeName)this.modelBuilderSpecs.builderImplName(), "builder", new Modifier[0]);
        if (this.isRequest() || this.isResponse()) {
            ctorBuilder.addStatement("super(builder)", new Object[0]);
        }
        this.shapeModelSpec.fields().forEach(f -> ctorBuilder.addStatement("this.$N = builder.$N", new Object[]{f, f}));
        return ctorBuilder.build();
    }

    private MethodSpec exceptionConstructor() {
        MethodSpec.Builder ctorBuilder = MethodSpec.constructorBuilder().addModifiers(new Modifier[]{Modifier.PRIVATE}).addParameter((TypeName)this.modelBuilderSpecs.builderImplName(), "builder", new Modifier[0]);
        ctorBuilder.addStatement("super(builder)", new Object[0]);
        this.shapeModelSpec.fields().forEach(f -> ctorBuilder.addStatement("this.$N = builder.$N", new Object[]{f, f}));
        return ctorBuilder.build();
    }

    private MethodSpec builderMethod() {
        return MethodSpec.methodBuilder((String)"builder").addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.STATIC}).returns((TypeName)this.modelBuilderSpecs.builderInterfaceName()).addStatement("return new $T()", new Object[]{this.modelBuilderSpecs.builderImplName()}).build();
    }

    private MethodSpec toBuilderMethod() {
        return MethodSpec.methodBuilder((String)"toBuilder").addModifiers(new Modifier[]{Modifier.PUBLIC}).addAnnotation(Override.class).returns((TypeName)this.modelBuilderSpecs.builderInterfaceName()).addStatement("return new $T(this)", new Object[]{this.modelBuilderSpecs.builderImplName()}).build();
    }

    private MethodSpec serializableBuilderClass() {
        return MethodSpec.methodBuilder((String)"serializableBuilderClass").addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.STATIC}).returns((TypeName)ParameterizedTypeName.get((ClassName)ClassName.get(Class.class), (TypeName[])new TypeName[]{WildcardTypeName.subtypeOf((TypeName)this.modelBuilderSpecs.builderInterfaceName())})).addStatement("return $T.class", new Object[]{this.modelBuilderSpecs.builderImplName()}).build();
    }

    private boolean isResponse() {
        return this.shapeModel.getShapeType() == ShapeType.Response;
    }

    private boolean isRequest() {
        return this.shapeModel.getShapeType() == ShapeType.Request;
    }
}

