/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.codegen.customization.processors;

import software.amazon.awssdk.codegen.customization.CodegenCustomizationProcessor;
import software.amazon.awssdk.codegen.model.intermediate.IntermediateModel;
import software.amazon.awssdk.codegen.model.service.Http;
import software.amazon.awssdk.codegen.model.service.Operation;
import software.amazon.awssdk.codegen.model.service.ServiceModel;
import software.amazon.awssdk.codegen.utils.ProtocolUtils;

public class SmithyRpcV2CborProtocolProcessor
implements CodegenCustomizationProcessor {
    @Override
    public void preprocess(ServiceModel serviceModel) {
        String protocol = ProtocolUtils.resolveProtocol(serviceModel.getMetadata());
        if (!"smithy-rpc-v2-cbor".equals(protocol)) {
            return;
        }
        serviceModel.getOperations().forEach((name, op) -> this.setRequestUri(serviceModel, (String)name, (Operation)op));
    }

    private void setRequestUri(ServiceModel service, String name, Operation op) {
        String uri = String.format("/service/%s/operation/%s", service.getMetadata().getTargetPrefix(), op.getName());
        if (op.getHttp() == null) {
            op.setHttp(new Http().withMethod("POST").withResponseCode("200"));
        }
        op.getHttp().withRequestUri(uri);
    }

    @Override
    public void postprocess(IntermediateModel intermediateModel) {
    }
}

