/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.codegen.poet.rules2;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Deque;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import software.amazon.awssdk.codegen.poet.rules2.LetExpression;
import software.amazon.awssdk.codegen.poet.rules2.RuleSetExpression;
import software.amazon.awssdk.codegen.poet.rules2.SymbolTable;
import software.amazon.awssdk.codegen.poet.rules2.VariableReferenceExpression;
import software.amazon.awssdk.codegen.poet.rules2.WalkRuleExpressionVisitor;

public final class ComputeScopeTree
extends WalkRuleExpressionVisitor {
    private final SymbolTable symbolTable;
    private final Deque<ScopeBuilder> scopes = new ArrayDeque<ScopeBuilder>();
    private final Map<String, Scope> scopesByName = new HashMap<String, Scope>();
    private Scope result;

    public ComputeScopeTree(SymbolTable symbolTable) {
        this.symbolTable = symbolTable;
    }

    public Scope result() {
        return this.result;
    }

    public Map<String, Scope> scopesByName() {
        return this.scopesByName;
    }

    @Override
    public Void visitRuleSetExpression(RuleSetExpression node) {
        ScopeBuilder scopeBuilder = new ScopeBuilder();
        scopeBuilder.ruleId(node.ruleId());
        this.scopes.push(scopeBuilder);
        super.visitRuleSetExpression(node);
        this.result = this.scopes.pop().build();
        this.scopesByName.put(this.result.ruleId(), this.result);
        if (!this.scopes.isEmpty()) {
            this.scopes.peekFirst().addChild(this.result);
        }
        return null;
    }

    @Override
    public Void visitVariableReferenceExpression(VariableReferenceExpression e) {
        String variableName = e.variableName();
        ScopeBuilder current = this.scopes.peekFirst();
        if (this.symbolTable.isLocal(variableName)) {
            current.usesLocal(variableName);
        } else if (this.symbolTable.isParam(variableName)) {
            current.usesParam(variableName);
        }
        return null;
    }

    @Override
    public Void visitLetExpression(LetExpression e) {
        ScopeBuilder scopeBuilder = this.scopes.peekFirst();
        for (String binding : e.bindings().keySet()) {
            scopeBuilder.defines(binding);
        }
        return super.visitLetExpression(e);
    }

    public static class ScopeBuilder {
        private String ruleId;
        private final Set<String> defines = new LinkedHashSet<String>();
        private final Set<String> usesLocals = new LinkedHashSet<String>();
        private final Set<String> usesParams = new LinkedHashSet<String>();
        private final List<Scope> children = new ArrayList<Scope>();

        public ScopeBuilder ruleId(String ruleId) {
            this.ruleId = ruleId;
            return this;
        }

        public ScopeBuilder defines(String define) {
            this.defines.add(define);
            return this;
        }

        public ScopeBuilder usesLocal(String use) {
            this.usesLocals.add(use);
            return this;
        }

        public ScopeBuilder usesParam(String use) {
            this.usesParams.add(use);
            return this;
        }

        public ScopeBuilder addChild(Scope child) {
            this.children.add(child);
            for (String local : child.usesLocals) {
                if (child.defines.contains(local)) continue;
                this.usesLocals.add(local);
            }
            for (String param : child.usesParams) {
                this.usesParams.add(param);
            }
            return this;
        }

        public Scope build() {
            return new Scope(this);
        }
    }

    public static class Scope {
        private final String ruleId;
        private final Set<String> defines;
        private final Set<String> usesLocals;
        private final Set<String> usesParams;
        private final List<Scope> children;

        public Scope(ScopeBuilder builder) {
            this.ruleId = Objects.requireNonNull(builder.ruleId, "ruleId cannot be null");
            this.defines = Collections.unmodifiableSet(new LinkedHashSet(builder.defines));
            this.usesLocals = Collections.unmodifiableSet(new LinkedHashSet(builder.usesLocals));
            this.usesParams = Collections.unmodifiableSet(new LinkedHashSet(builder.usesParams));
            this.children = Collections.unmodifiableList(new ArrayList(builder.children));
        }

        public String ruleId() {
            return this.ruleId;
        }

        public Set<String> defines() {
            return this.defines;
        }

        public Set<String> usesLocals() {
            return this.usesLocals;
        }

        public Set<String> usesParams() {
            return this.usesParams;
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            this.appendTo(0, builder);
            return builder.toString();
        }

        public void appendTo(int level, StringBuilder sb) {
            String prefix = this.levelValue(level);
            sb.append(prefix).append("=========================================\n");
            sb.append(prefix).append("rule ").append(this.ruleId).append("\n");
            sb.append(prefix).append("defines ").append(this.defines).append("\n");
            sb.append(prefix).append("uses ").append(this.usesLocals).append("\n");
            for (Scope child : this.children) {
                child.appendTo(level + 1, sb);
            }
        }

        private String levelValue(int level) {
            StringBuilder result = new StringBuilder();
            for (int i = 0; i < level; ++i) {
                result.append("  ");
            }
            return result.toString();
        }
    }
}

