/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.codegen.poet.auth.scheme;

import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.FieldSpec;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.ParameterSpec;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeSpec;
import java.util.Map;
import javax.lang.model.element.Modifier;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.codegen.model.intermediate.IntermediateModel;
import software.amazon.awssdk.codegen.model.rules.endpoints.ParameterModel;
import software.amazon.awssdk.codegen.poet.ClassSpec;
import software.amazon.awssdk.codegen.poet.PoetUtils;
import software.amazon.awssdk.codegen.poet.auth.scheme.AuthSchemeSpecUtils;
import software.amazon.awssdk.codegen.poet.rules.EndpointRulesSpecUtils;
import software.amazon.awssdk.http.auth.aws.signer.RegionSet;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.utils.Validate;

public class DefaultAuthSchemeParamsSpec
implements ClassSpec {
    private final IntermediateModel intermediateModel;
    private final AuthSchemeSpecUtils authSchemeSpecUtils;
    private final EndpointRulesSpecUtils endpointRulesSpecUtils;

    public DefaultAuthSchemeParamsSpec(IntermediateModel intermediateModel) {
        this.intermediateModel = intermediateModel;
        this.authSchemeSpecUtils = new AuthSchemeSpecUtils(intermediateModel);
        this.endpointRulesSpecUtils = new EndpointRulesSpecUtils(intermediateModel);
    }

    @Override
    public ClassName className() {
        return this.authSchemeSpecUtils.parametersDefaultImplName();
    }

    @Override
    public TypeSpec poetSpec() {
        TypeSpec.Builder b = PoetUtils.createClassBuilder(this.className()).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.FINAL}).addAnnotation(SdkInternalApi.class).addSuperinterface((TypeName)this.authSchemeSpecUtils.parametersInterfaceName()).addMethod(this.constructor()).addMethod(this.builderMethod()).addType(this.builderImplSpec());
        if (this.authSchemeSpecUtils.useEndpointBasedAuthProvider()) {
            b.addSuperinterface((TypeName)this.authSchemeSpecUtils.parametersEndpointAwareDefaultImplName());
        }
        this.addFieldsAndAccessors(b);
        this.addToBuilder(b);
        return b.build();
    }

    private MethodSpec constructor() {
        MethodSpec.Builder b = MethodSpec.constructorBuilder().addModifiers(new Modifier[]{Modifier.PRIVATE}).addParameter((TypeName)this.builderClassName(), "builder", new Modifier[0]).addStatement("this.operation = $T.paramNotNull(builder.operation, \"operation\")", new Object[]{Validate.class});
        if (this.authSchemeSpecUtils.usesSigV4()) {
            b.addStatement("this.region = builder.region", new Object[0]);
        }
        if (this.authSchemeSpecUtils.hasSigV4aSupport()) {
            b.addStatement("this.regionSet = builder.regionSet", new Object[0]);
        }
        if (this.authSchemeSpecUtils.generateEndpointBasedParams()) {
            this.parameters().forEach((name, model) -> {
                if (this.authSchemeSpecUtils.includeParam((String)name)) {
                    String fieldName = this.authSchemeSpecUtils.paramMethodName((String)name);
                    boolean isRequired = this.isParamRequired((ParameterModel)model);
                    if (isRequired) {
                        b.addStatement("this.$1N = $2T.paramNotNull(builder.$1N, $1S)", new Object[]{fieldName, Validate.class});
                    } else {
                        b.addStatement("this.$1N = builder.$1N", new Object[]{fieldName});
                    }
                }
            });
            b.addStatement("this.endpointProvider = builder.endpointProvider", new Object[0]);
        }
        return b.build();
    }

    private boolean isParamRequired(ParameterModel model) {
        Boolean isRequired = model.isRequired();
        return isRequired != null && isRequired != false || model.getDefault() != null;
    }

    private MethodSpec builderMethod() {
        return MethodSpec.methodBuilder((String)"builder").addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.STATIC}).returns((TypeName)this.authSchemeSpecUtils.parametersInterfaceBuilderInterfaceName()).addStatement("return new $T()", new Object[]{this.builderClassName()}).build();
    }

    private TypeSpec builderImplSpec() {
        TypeSpec.Builder b = TypeSpec.classBuilder((ClassName)this.builderClassName()).addModifiers(new Modifier[]{Modifier.PRIVATE, Modifier.STATIC, Modifier.FINAL}).addSuperinterface((TypeName)this.authSchemeSpecUtils.parametersInterfaceBuilderInterfaceName());
        if (this.authSchemeSpecUtils.useEndpointBasedAuthProvider()) {
            b.addSuperinterface((TypeName)this.authSchemeSpecUtils.parametersEndpointAwareDefaultImplName().nestedClass("Builder"));
        }
        this.addBuilderConstructors(b);
        this.addBuilderFieldsAndSetter(b);
        b.addMethod(MethodSpec.methodBuilder((String)"build").addModifiers(new Modifier[]{Modifier.PUBLIC}).addAnnotation(Override.class).returns((TypeName)this.authSchemeSpecUtils.parametersInterfaceName()).addStatement("return new $T(this)", new Object[]{this.className()}).build());
        return b.build();
    }

    private void addBuilderConstructors(TypeSpec.Builder b) {
        b.addMethod(MethodSpec.constructorBuilder().build());
        MethodSpec.Builder builderFromInstance = MethodSpec.constructorBuilder().addParameter((TypeName)this.className(), "params", new Modifier[0]);
        builderFromInstance.addStatement("this.operation = params.operation", new Object[0]);
        if (this.authSchemeSpecUtils.usesSigV4()) {
            builderFromInstance.addStatement("this.region = params.region", new Object[0]);
        }
        if (this.authSchemeSpecUtils.hasSigV4aSupport()) {
            builderFromInstance.addStatement("this.regionSet = params.regionSet", new Object[0]);
        }
        if (this.authSchemeSpecUtils.generateEndpointBasedParams()) {
            this.parameters().forEach((name, model) -> {
                if (this.authSchemeSpecUtils.includeParam((String)name)) {
                    builderFromInstance.addStatement("this.$1N = params.$1N", new Object[]{this.endpointRulesSpecUtils.variableName((String)name)});
                }
            });
            builderFromInstance.addStatement("this.endpointProvider = params.endpointProvider", new Object[0]);
        }
        b.addMethod(builderFromInstance.build());
    }

    private void addFieldsAndAccessors(TypeSpec.Builder b) {
        b.addField(FieldSpec.builder(String.class, (String)"operation", (Modifier[])new Modifier[0]).addModifiers(new Modifier[]{Modifier.PRIVATE, Modifier.FINAL}).build());
        b.addMethod(MethodSpec.methodBuilder((String)"operation").addModifiers(new Modifier[]{Modifier.PUBLIC}).addAnnotation(Override.class).returns(String.class).addStatement("return operation", new Object[0]).build());
        if (this.authSchemeSpecUtils.usesSigV4()) {
            b.addField(FieldSpec.builder(Region.class, (String)"region", (Modifier[])new Modifier[0]).addModifiers(new Modifier[]{Modifier.PRIVATE, Modifier.FINAL}).build());
            b.addMethod(MethodSpec.methodBuilder((String)"region").addModifiers(new Modifier[]{Modifier.PUBLIC}).addAnnotation(Override.class).returns(Region.class).addStatement("return region", new Object[0]).build());
        }
        if (this.authSchemeSpecUtils.hasSigV4aSupport()) {
            b.addField(FieldSpec.builder(RegionSet.class, (String)"regionSet", (Modifier[])new Modifier[0]).addModifiers(new Modifier[]{Modifier.PRIVATE, Modifier.FINAL}).build());
            b.addMethod(MethodSpec.methodBuilder((String)"regionSet").addModifiers(new Modifier[]{Modifier.PUBLIC}).addAnnotation(Override.class).returns(RegionSet.class).addStatement("return regionSet", new Object[0]).build());
        }
        if (this.authSchemeSpecUtils.generateEndpointBasedParams()) {
            this.parameters().forEach((name, model) -> {
                if (this.authSchemeSpecUtils.includeParam((String)name)) {
                    b.addField(this.endpointRulesSpecUtils.parameterClassField((String)name, (ParameterModel)model));
                    b.addMethod(this.endpointRulesSpecUtils.parameterClassAccessorMethod((String)name, (ParameterModel)model).toBuilder().addAnnotation(Override.class).build());
                }
            });
            ClassName endpointProvider = this.endpointRulesSpecUtils.providerInterfaceName();
            b.addField(FieldSpec.builder((TypeName)endpointProvider, (String)"endpointProvider", (Modifier[])new Modifier[0]).addModifiers(new Modifier[]{Modifier.PRIVATE, Modifier.FINAL}).build());
            b.addMethod(MethodSpec.methodBuilder((String)"endpointProvider").addModifiers(new Modifier[]{Modifier.PUBLIC}).addAnnotation(Override.class).returns((TypeName)endpointProvider).addStatement("return endpointProvider", new Object[0]).build());
        }
    }

    private void addToBuilder(TypeSpec.Builder b) {
        b.addMethod(MethodSpec.methodBuilder((String)"toBuilder").addModifiers(new Modifier[]{Modifier.PUBLIC}).addAnnotation(Override.class).returns((TypeName)this.authSchemeSpecUtils.parametersInterfaceBuilderInterfaceName()).addStatement("return new $T(this)", new Object[]{this.builderClassName()}).build());
    }

    private void addBuilderFieldsAndSetter(TypeSpec.Builder b) {
        b.addField(FieldSpec.builder(String.class, (String)"operation", (Modifier[])new Modifier[0]).addModifiers(new Modifier[]{Modifier.PRIVATE}).build());
        b.addMethod(this.builderSetterMethod("operation", TypeName.get(String.class)));
        if (this.authSchemeSpecUtils.usesSigV4()) {
            b.addField(FieldSpec.builder(Region.class, (String)"region", (Modifier[])new Modifier[0]).addModifiers(new Modifier[]{Modifier.PRIVATE}).build());
            b.addMethod(this.builderSetterMethod("region", TypeName.get(Region.class)));
        }
        if (this.authSchemeSpecUtils.hasSigV4aSupport()) {
            b.addField(FieldSpec.builder(RegionSet.class, (String)"regionSet", (Modifier[])new Modifier[0]).addModifiers(new Modifier[]{Modifier.PRIVATE}).build());
            b.addMethod(this.builderSetterMethod("regionSet", TypeName.get(RegionSet.class)));
        }
        if (this.authSchemeSpecUtils.generateEndpointBasedParams()) {
            this.parameters().forEach((name, model) -> {
                if (this.authSchemeSpecUtils.includeParam((String)name)) {
                    b.addField(this.endpointRulesSpecUtils.parameterBuilderFieldSpec((String)name, (ParameterModel)model));
                    b.addMethod(this.endpointRulesSpecUtils.parameterBuilderSetterMethod(this.className(), (String)name, (ParameterModel)model));
                }
            });
            b.addField(FieldSpec.builder((TypeName)this.endpointRulesSpecUtils.providerInterfaceName(), (String)"endpointProvider", (Modifier[])new Modifier[0]).addModifiers(new Modifier[]{Modifier.PRIVATE}).build());
            b.addMethod(this.builderSetterMethod("endpointProvider", (TypeName)this.endpointRulesSpecUtils.providerInterfaceName()));
        }
    }

    private MethodSpec builderSetterMethod(String field, TypeName type) {
        return MethodSpec.methodBuilder((String)field).addModifiers(new Modifier[]{Modifier.PUBLIC}).addAnnotation(Override.class).addParameter(ParameterSpec.builder((TypeName)type, (String)field, (Modifier[])new Modifier[0]).build()).returns((TypeName)this.builderClassName()).addStatement("this.$L = $L", new Object[]{field, field}).addStatement("return this", new Object[0]).build();
    }

    private ClassName builderClassName() {
        return this.className().nestedClass("Builder");
    }

    private Map<String, ParameterModel> parameters() {
        return this.intermediateModel.getEndpointRuleSetModel().getParameters();
    }
}

