/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.codegen.poet.rules2;

import java.util.Objects;
import software.amazon.awssdk.codegen.poet.rules2.HeadersExpression;
import software.amazon.awssdk.codegen.poet.rules2.PropertiesExpression;
import software.amazon.awssdk.codegen.poet.rules2.RuleExpression;
import software.amazon.awssdk.codegen.poet.rules2.RuleExpressionVisitor;
import software.amazon.awssdk.codegen.poet.rules2.RuleRuntimeTypeMirror;
import software.amazon.awssdk.codegen.poet.rules2.RuleType;
import software.amazon.awssdk.utils.Validate;

public final class EndpointExpression
implements RuleExpression {
    private final RuleType type = RuleRuntimeTypeMirror.VOID;
    private final RuleExpression url;
    private final PropertiesExpression properties;
    private final HeadersExpression headers;

    EndpointExpression(Builder builder) {
        this.url = (RuleExpression)Validate.paramNotNull((Object)builder.url, (String)"url");
        this.properties = (PropertiesExpression)Validate.paramNotNull((Object)builder.properties, (String)"properties");
        this.headers = (HeadersExpression)Validate.paramNotNull((Object)builder.headers, (String)"headers");
    }

    public static Builder builder() {
        return new Builder();
    }

    @Override
    public RuleExpression.RuleExpressionKind kind() {
        return RuleExpression.RuleExpressionKind.ENDPOINT;
    }

    public RuleExpression url() {
        return this.url;
    }

    public PropertiesExpression properties() {
        return this.properties;
    }

    public HeadersExpression headers() {
        return this.headers;
    }

    @Override
    public StringBuilder appendTo(StringBuilder buf) {
        buf.append("{:type :endpoint");
        buf.append(", :url ");
        this.url.appendTo(buf);
        buf.append(", :properties ");
        this.properties.appendTo(buf);
        buf.append(", :headers ");
        this.headers.appendTo(buf);
        buf.append("}");
        return buf;
    }

    @Override
    public <T> T accept(RuleExpressionVisitor<T> visitor) {
        return visitor.visitEndpointExpression(this);
    }

    @Override
    public RuleType type() {
        return this.type;
    }

    public String toString() {
        return this.appendTo(new StringBuilder()).toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        EndpointExpression that = (EndpointExpression)o;
        if (!Objects.equals(this.type, that.type)) {
            return false;
        }
        if (!this.url.equals(that.url)) {
            return false;
        }
        if (!this.properties.equals(that.properties)) {
            return false;
        }
        return this.headers.equals(that.headers);
    }

    public int hashCode() {
        int result = this.type != null ? this.type.hashCode() : 0;
        result = 31 * result + this.url.hashCode();
        result = 31 * result + this.properties.hashCode();
        result = 31 * result + this.headers.hashCode();
        return result;
    }

    public static class Builder {
        private RuleExpression url;
        private PropertiesExpression properties = PropertiesExpression.empty();
        private HeadersExpression headers = HeadersExpression.empty();

        public Builder url(RuleExpression url) {
            this.url = url;
            return this;
        }

        public Builder properties(PropertiesExpression properties) {
            this.properties = properties;
            return this;
        }

        public Builder headers(HeadersExpression headers) {
            this.headers = headers;
            return this;
        }

        public EndpointExpression build() {
            return new EndpointExpression(this);
        }
    }
}

