/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.codegen.poet.transform.protocols;

import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.CodeBlock;
import com.squareup.javapoet.FieldSpec;
import com.squareup.javapoet.TypeName;
import javax.lang.model.element.Modifier;
import software.amazon.awssdk.codegen.model.intermediate.IntermediateModel;
import software.amazon.awssdk.codegen.model.intermediate.MemberModel;
import software.amazon.awssdk.codegen.model.intermediate.ShapeModel;
import software.amazon.awssdk.codegen.poet.eventstream.EventStreamUtils;
import software.amazon.awssdk.codegen.poet.transform.protocols.JsonMarshallerSpec;
import software.amazon.awssdk.http.SdkHttpFullRequest;
import software.amazon.awssdk.http.SdkHttpMethod;
import software.amazon.awssdk.protocols.core.OperationInfo;
import software.amazon.awssdk.protocols.core.ProtocolMarshaller;

public final class EventStreamJsonMarshallerSpec
extends JsonMarshallerSpec {
    private static final String JSON_CONTENT_TYPE = "application/json";
    private final IntermediateModel intermediateModel;

    public EventStreamJsonMarshallerSpec(IntermediateModel model, ShapeModel shapeModel) {
        super(shapeModel);
        this.intermediateModel = model;
    }

    @Override
    public CodeBlock marshalCodeBlock(ClassName requestClassName) {
        String variableName = this.shapeModel.getVariable().getVariableName();
        CodeBlock.Builder builder = CodeBlock.builder().addStatement("$T<$T> protocolMarshaller = protocolFactory.createProtocolMarshaller(SDK_OPERATION_BINDING)", new Object[]{ProtocolMarshaller.class, SdkHttpFullRequest.class}).add("return protocolMarshaller.marshall($L).toBuilder()", new Object[]{variableName}).add(".putHeader(\":message-type\", \"event\")", new Object[0]).add(".putHeader(\":event-type\", \"$L\")", new Object[]{this.getMemberNameFromEventStream()});
        if (!this.shapeModel.hasNoEventPayload()) {
            builder.add(".putHeader(\":content-type\", \"$L\")", new Object[]{this.determinePayloadContentType()});
        }
        builder.add(".build();", new Object[0]);
        return builder.build();
    }

    @Override
    protected FieldSpec operationInfoField() {
        CodeBlock.Builder builder = CodeBlock.builder().add("$T.builder()", new Object[]{OperationInfo.class}).add(".hasExplicitPayloadMember($L)", new Object[]{this.shapeModel.isHasPayloadMember() || this.shapeModel.getExplicitEventPayloadMember() != null}).add(".hasPayloadMembers($L)", new Object[]{this.shapeModel.hasPayloadMembers()}).add(".httpMethod($T.GET)", new Object[]{SdkHttpMethod.class}).add(".build()", new Object[0]);
        return FieldSpec.builder((TypeName)ClassName.get(OperationInfo.class), (String)"SDK_OPERATION_BINDING", (Modifier[])new Modifier[0]).addModifiers(new Modifier[]{Modifier.PRIVATE, Modifier.FINAL, Modifier.STATIC}).initializer(builder.build()).build();
    }

    private String getMemberNameFromEventStream() {
        ShapeModel eventStream = EventStreamUtils.getBaseEventStreamShape(this.intermediateModel, this.shapeModel);
        return eventStream.getMembers().stream().filter(memberModel -> memberModel.getShape().equals(this.shapeModel)).findAny().map(MemberModel::getC2jName).orElseThrow(() -> new IllegalStateException(String.format("Unable to find %s from its parent event stream", this.shapeModel.getC2jName())));
    }

    private String determinePayloadContentType() {
        MemberModel explicitEventPayload = this.shapeModel.getExplicitEventPayloadMember();
        if (explicitEventPayload != null) {
            return this.getPayloadContentType(explicitEventPayload);
        }
        return JSON_CONTENT_TYPE;
    }

    private String getPayloadContentType(MemberModel memberModel) {
        String blobContentType = "application/octet-stream";
        String stringContentType = "text/plain";
        String variableType = memberModel.getVariable().getVariableType();
        if ("software.amazon.awssdk.core.SdkBytes".equals(variableType)) {
            return blobContentType;
        }
        if ("String".equals(variableType)) {
            return stringContentType;
        }
        return JSON_CONTENT_TYPE;
    }
}

