/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.codegen.poet.rules2;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import software.amazon.awssdk.codegen.poet.rules2.RuleExpression;
import software.amazon.awssdk.codegen.poet.rules2.RuleExpressionVisitor;
import software.amazon.awssdk.codegen.poet.rules2.RuleRuntimeTypeMirror;
import software.amazon.awssdk.codegen.poet.rules2.RuleType;

public final class BooleanAndExpression
implements RuleExpression {
    private final RuleType type = RuleRuntimeTypeMirror.BOOLEAN;
    private final List<RuleExpression> expressions;

    BooleanAndExpression(Builder builder) {
        this.expressions = Collections.unmodifiableList(new ArrayList(builder.expressions));
    }

    public static Builder builder() {
        return new Builder();
    }

    @Override
    public RuleExpression.RuleExpressionKind kind() {
        return RuleExpression.RuleExpressionKind.BOOLEAN_AND;
    }

    @Override
    public StringBuilder appendTo(StringBuilder buf) {
        buf.append("(and");
        for (RuleExpression expr : this.expressions) {
            buf.append(" ");
            expr.appendTo(buf);
        }
        return buf.append(')');
    }

    @Override
    public <T> T accept(RuleExpressionVisitor<T> visitor) {
        return visitor.visitBooleanAndExpression(this);
    }

    @Override
    public RuleExpression simplify() {
        if (this.expressions.size() == 1) {
            return this.expressions.get(0);
        }
        return this;
    }

    public List<RuleExpression> expressions() {
        return this.expressions;
    }

    @Override
    public RuleType type() {
        return this.type;
    }

    public String toString() {
        return this.appendTo(new StringBuilder()).toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BooleanAndExpression that = (BooleanAndExpression)o;
        if (!Objects.equals(this.type, that.type)) {
            return false;
        }
        return this.expressions.equals(that.expressions);
    }

    public int hashCode() {
        int result = this.type != null ? this.type.hashCode() : 0;
        result = 31 * result + this.expressions.hashCode();
        return result;
    }

    public static class Builder {
        private final List<RuleExpression> expressions = new ArrayList<RuleExpression>();

        public Builder expressions(List<RuleExpression> expressions) {
            this.expressions.addAll(expressions);
            return this;
        }

        public Builder addExpression(RuleExpression expr) {
            this.expressions.add(expr);
            return this;
        }

        public BooleanAndExpression build() {
            return new BooleanAndExpression(this);
        }
    }
}

