/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.codegen.poet.model;

import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.CodeBlock;
import com.squareup.javapoet.FieldSpec;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.ParameterizedTypeName;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeSpec;
import com.squareup.javapoet.WildcardTypeName;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import javax.lang.model.element.Modifier;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.codegen.model.intermediate.IntermediateModel;
import software.amazon.awssdk.codegen.model.intermediate.MemberModel;
import software.amazon.awssdk.codegen.model.intermediate.ShapeModel;
import software.amazon.awssdk.codegen.model.intermediate.ShapeType;
import software.amazon.awssdk.codegen.poet.PoetExtension;
import software.amazon.awssdk.codegen.poet.model.AccessorsFactory;
import software.amazon.awssdk.codegen.poet.model.AwsServiceBaseRequestSpec;
import software.amazon.awssdk.codegen.poet.model.AwsServiceBaseResponseSpec;
import software.amazon.awssdk.codegen.poet.model.DeprecationUtils;
import software.amazon.awssdk.codegen.poet.model.ExceptionProperties;
import software.amazon.awssdk.codegen.poet.model.ShapeModelSpec;
import software.amazon.awssdk.codegen.poet.model.TypeProvider;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.Validate;
import software.amazon.awssdk.utils.builder.CopyableBuilder;

class ModelBuilderSpecs {
    private final IntermediateModel intermediateModel;
    private final ShapeModel shapeModel;
    private final TypeProvider typeProvider;
    private final PoetExtension poetExtensions;
    private final AccessorsFactory accessorsFactory;
    private final ShapeModelSpec shapeModelSpec;

    ModelBuilderSpecs(IntermediateModel intermediateModel, ShapeModel shapeModel, TypeProvider typeProvider) {
        this.intermediateModel = intermediateModel;
        this.shapeModel = shapeModel;
        this.typeProvider = typeProvider;
        this.poetExtensions = new PoetExtension(this.intermediateModel);
        this.accessorsFactory = new AccessorsFactory(this.shapeModel, this.intermediateModel, this.typeProvider, this.poetExtensions);
        this.shapeModelSpec = new ShapeModelSpec(shapeModel, typeProvider, this.poetExtensions, intermediateModel);
    }

    public ClassName builderInterfaceName() {
        return this.classToBuild().nestedClass("Builder");
    }

    public ClassName builderImplName() {
        return this.classToBuild().nestedClass("BuilderImpl");
    }

    public TypeSpec builderInterface() {
        TypeSpec.Builder builder = TypeSpec.interfaceBuilder((ClassName)this.builderInterfaceName()).addSuperinterfaces(this.builderSuperInterfaces()).addModifiers(new Modifier[]{Modifier.PUBLIC});
        this.shapeModel.getNonStreamingMembers().forEach(m -> {
            builder.addMethods(DeprecationUtils.checkDeprecated(m, this.accessorsFactory.fluentSetterDeclarations((MemberModel)m, (TypeName)this.builderInterfaceName())));
            builder.addMethods(DeprecationUtils.checkDeprecated(m, this.accessorsFactory.convenienceSetterDeclarations((MemberModel)m, (TypeName)this.builderInterfaceName())));
        });
        if (this.isException()) {
            builder.addSuperinterface((TypeName)this.parentExceptionBuilder().nestedClass("Builder"));
            builder.addMethods(ExceptionProperties.builderInterfaceMethods(this.builderInterfaceName()));
        }
        if (this.isRequest()) {
            builder.addMethod(MethodSpec.methodBuilder((String)"overrideConfiguration").returns((TypeName)this.builderInterfaceName()).addAnnotation(Override.class).addParameter(AwsRequestOverrideConfiguration.class, "overrideConfiguration", new Modifier[0]).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.ABSTRACT}).build());
            builder.addMethod(MethodSpec.methodBuilder((String)"overrideConfiguration").addAnnotation(Override.class).returns((TypeName)this.builderInterfaceName()).addParameter((TypeName)ParameterizedTypeName.get(Consumer.class, (Type[])new Type[]{AwsRequestOverrideConfiguration.Builder.class}), "builderConsumer", new Modifier[0]).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.ABSTRACT}).build());
        }
        return builder.build();
    }

    public TypeSpec beanStyleBuilder() {
        TypeSpec.Builder builderClassBuilder = TypeSpec.classBuilder((ClassName)this.builderImplName()).addSuperinterface((TypeName)this.builderInterfaceName()).superclass(this.builderImplSuperClass()).addModifiers(new Modifier[]{Modifier.STATIC});
        if (!this.isEvent()) {
            builderClassBuilder.addModifiers(new Modifier[]{Modifier.FINAL});
        } else {
            builderClassBuilder.addModifiers(new Modifier[]{Modifier.PROTECTED});
        }
        if (this.isException()) {
            builderClassBuilder.superclass((TypeName)this.parentExceptionBuilder().nestedClass("BuilderImpl"));
        }
        builderClassBuilder.addFields(this.fields());
        builderClassBuilder.addMethod(this.noargConstructor());
        builderClassBuilder.addMethod(this.modelCopyConstructor());
        builderClassBuilder.addMethods(this.accessors());
        builderClassBuilder.addMethod(this.buildMethod());
        builderClassBuilder.addMethod(this.sdkFieldsMethod());
        builderClassBuilder.addMethod(this.sdkFieldNameToFieldMethod());
        if (this.shapeModel.isUnion()) {
            builderClassBuilder.addMethod(this.handleUnionValueChangeMethod());
        }
        return builderClassBuilder.build();
    }

    private ClassName parentExceptionBuilder() {
        String customExceptionBase = this.intermediateModel.getCustomizationConfig().getSdkModeledExceptionBaseClassName();
        if (customExceptionBase != null) {
            return this.poetExtensions.getModelClass(customExceptionBase);
        }
        return this.poetExtensions.getModelClass(this.intermediateModel.getSdkModeledExceptionBaseClassName());
    }

    private MethodSpec sdkFieldsMethod() {
        ParameterizedTypeName sdkFieldType = ParameterizedTypeName.get((ClassName)ClassName.get(SdkField.class), (TypeName[])new TypeName[]{WildcardTypeName.subtypeOf((TypeName)ClassName.get(Object.class))});
        return MethodSpec.methodBuilder((String)"sdkFields").addModifiers(new Modifier[]{Modifier.PUBLIC}).addAnnotation(Override.class).returns((TypeName)ParameterizedTypeName.get((ClassName)ClassName.get(List.class), (TypeName[])new TypeName[]{sdkFieldType})).addCode("return SDK_FIELDS;", new Object[0]).build();
    }

    private MethodSpec sdkFieldNameToFieldMethod() {
        ParameterizedTypeName sdkFieldType = ParameterizedTypeName.get((ClassName)ClassName.get(SdkField.class), (TypeName[])new TypeName[]{WildcardTypeName.subtypeOf((TypeName)ClassName.get(Object.class))});
        return MethodSpec.methodBuilder((String)"sdkFieldNameToField").addModifiers(new Modifier[]{Modifier.PUBLIC}).addAnnotation(Override.class).returns((TypeName)ParameterizedTypeName.get((ClassName)ClassName.get(Map.class), (TypeName[])new TypeName[]{ClassName.get(String.class), sdkFieldType})).addCode("return SDK_NAME_TO_FIELD;", new Object[0]).build();
    }

    private TypeName builderImplSuperClass() {
        if (this.isRequest()) {
            return new AwsServiceBaseRequestSpec(this.intermediateModel).className().nestedClass("BuilderImpl");
        }
        if (this.isResponse()) {
            return new AwsServiceBaseResponseSpec(this.intermediateModel).className().nestedClass("BuilderImpl");
        }
        return ClassName.OBJECT;
    }

    private List<FieldSpec> fields() {
        ArrayList<FieldSpec> fields = new ArrayList<FieldSpec>();
        for (MemberModel member : this.shapeModel.getNonStreamingMembers()) {
            FieldSpec fieldSpec = this.typeProvider.asField(member, Modifier.PRIVATE);
            if (member.isList()) {
                fieldSpec = fieldSpec.toBuilder().initializer("$T.getInstance()", new Object[]{DefaultSdkAutoConstructList.class}).build();
            } else if (member.isMap()) {
                fieldSpec = fieldSpec.toBuilder().initializer("$T.getInstance()", new Object[]{DefaultSdkAutoConstructMap.class}).build();
            }
            fields.add(fieldSpec);
        }
        if (this.shapeModel.isUnion()) {
            ClassName unionType = this.shapeModelSpec.className().nestedClass("Type");
            fields.add(FieldSpec.builder((TypeName)unionType, (String)"type", (Modifier[])new Modifier[]{Modifier.PRIVATE}).initializer("$T.UNKNOWN_TO_SDK_VERSION", new Object[]{unionType}).build());
            fields.add(FieldSpec.builder((TypeName)ParameterizedTypeName.get((ClassName)ClassName.get(Set.class), (TypeName[])new TypeName[]{unionType}), (String)"setTypes", (Modifier[])new Modifier[]{Modifier.PRIVATE}).initializer("$T.noneOf($T.class)", new Object[]{EnumSet.class, unionType}).build());
        }
        return fields;
    }

    private MethodSpec noargConstructor() {
        Modifier modifier = this.isEvent() ? Modifier.PROTECTED : Modifier.PRIVATE;
        MethodSpec.Builder ctorBuilder = MethodSpec.constructorBuilder().addModifiers(new Modifier[]{modifier});
        return ctorBuilder.build();
    }

    private MethodSpec modelCopyConstructor() {
        Modifier modifier = this.isEvent() ? Modifier.PROTECTED : Modifier.PRIVATE;
        MethodSpec.Builder copyBuilderCtor = MethodSpec.constructorBuilder().addModifiers(new Modifier[]{modifier}).addParameter((TypeName)this.classToBuild(), "model", new Modifier[0]);
        if (this.isRequest() || this.isResponse() || this.isException()) {
            copyBuilderCtor.addCode("super(model);", new Object[0]);
        }
        this.shapeModel.getNonStreamingMembers().forEach(m -> {
            String name = m.getVariable().getVariableName();
            copyBuilderCtor.addStatement("$N(model.$N)", new Object[]{m.getFluentSetterMethodName(), name});
        });
        return copyBuilderCtor.build();
    }

    private List<MethodSpec> accessors() {
        ArrayList<MethodSpec> accessors = new ArrayList<MethodSpec>();
        this.shapeModel.getNonStreamingMembers().forEach(m -> {
            accessors.add(DeprecationUtils.checkDeprecated(m, this.accessorsFactory.beanStyleGetter((MemberModel)m)));
            accessors.addAll(DeprecationUtils.checkDeprecated(m, this.accessorsFactory.beanStyleSetters((MemberModel)m)));
            accessors.addAll(DeprecationUtils.checkDeprecated(m, this.accessorsFactory.fluentSetters((MemberModel)m, (TypeName)this.builderInterfaceName())));
            accessors.addAll(DeprecationUtils.checkDeprecated(m, this.accessorsFactory.convenienceSetters((MemberModel)m, (TypeName)this.builderInterfaceName())));
        });
        if (this.isException()) {
            accessors.addAll(ExceptionProperties.builderImplMethods(this.builderImplName()));
        }
        if (this.isRequest()) {
            accessors.add(MethodSpec.methodBuilder((String)"overrideConfiguration").addAnnotation(Override.class).returns((TypeName)this.builderInterfaceName()).addParameter(AwsRequestOverrideConfiguration.class, "overrideConfiguration", new Modifier[0]).addModifiers(new Modifier[]{Modifier.PUBLIC}).addStatement("super.overrideConfiguration(overrideConfiguration)", new Object[0]).addStatement("return this", new Object[0]).build());
            accessors.add(MethodSpec.methodBuilder((String)"overrideConfiguration").addAnnotation(Override.class).returns((TypeName)this.builderInterfaceName()).addParameter((TypeName)ParameterizedTypeName.get(Consumer.class, (Type[])new Type[]{AwsRequestOverrideConfiguration.Builder.class}), "builderConsumer", new Modifier[0]).addModifiers(new Modifier[]{Modifier.PUBLIC}).addStatement("super.overrideConfiguration(builderConsumer)", new Object[0]).addStatement("return this", new Object[0]).build());
        }
        return accessors;
    }

    private MethodSpec buildMethod() {
        return MethodSpec.methodBuilder((String)"build").addAnnotation(Override.class).addModifiers(new Modifier[]{Modifier.PUBLIC}).returns((TypeName)this.classToBuild()).addStatement("return new $T(this)", new Object[]{this.classToBuild()}).build();
    }

    private ClassName classToBuild() {
        return this.shapeModelSpec.className();
    }

    private boolean isException() {
        return this.shapeModel.getShapeType() == ShapeType.Exception;
    }

    private boolean isRequest() {
        return this.shapeModel.getShapeType() == ShapeType.Request;
    }

    private boolean isResponse() {
        return this.shapeModel.getShapeType() == ShapeType.Response;
    }

    private boolean isEvent() {
        return this.shapeModel.isEvent();
    }

    private List<TypeName> builderSuperInterfaces() {
        ArrayList<TypeName> superInterfaces = new ArrayList<TypeName>();
        if (this.isRequest()) {
            superInterfaces.add((TypeName)new AwsServiceBaseRequestSpec(this.intermediateModel).className().nestedClass("Builder"));
        }
        if (this.isResponse()) {
            superInterfaces.add((TypeName)new AwsServiceBaseResponseSpec(this.intermediateModel).className().nestedClass("Builder"));
        }
        superInterfaces.add((TypeName)ClassName.get(SdkPojo.class));
        superInterfaces.add((TypeName)ParameterizedTypeName.get((ClassName)ClassName.get(CopyableBuilder.class), (TypeName[])new TypeName[]{this.classToBuild().nestedClass("Builder"), this.classToBuild()}));
        return superInterfaces;
    }

    public TypeSpec unionTypeClass() {
        Validate.isTrue((boolean)this.shapeModel.isUnion(), (String)"%s was not a union.", (Object[])new Object[]{this.shapeModel.getShapeName()});
        TypeSpec.Builder type = TypeSpec.enumBuilder((String)"Type").addJavadoc("@see $L#type()", new Object[]{this.shapeModel.getShapeName()}).addModifiers(new Modifier[]{Modifier.PUBLIC});
        for (MemberModel member : this.shapeModel.getMembers()) {
            type.addEnumConstant(member.getUnionEnumTypeName());
        }
        type.addEnumConstant("UNKNOWN_TO_SDK_VERSION");
        return type.build();
    }

    private MethodSpec handleUnionValueChangeMethod() {
        CodeBlock body = CodeBlock.builder().beginControlFlow("if (this.type == type || oldValue == newValue)", new Object[0]).addStatement("return", new Object[0]).endControlFlow().beginControlFlow("if (newValue == null || newValue instanceof $T || newValue instanceof $T)", new Object[]{SdkAutoConstructList.class, SdkAutoConstructMap.class}).addStatement("setTypes.remove(type)", new Object[0]).nextControlFlow("else if (oldValue == null || oldValue instanceof $T || oldValue instanceof $T)", new Object[]{SdkAutoConstructList.class, SdkAutoConstructMap.class}).addStatement("setTypes.add(type)", new Object[0]).endControlFlow().beginControlFlow("if (setTypes.size() == 1)", new Object[0]).addStatement("this.type = setTypes.iterator().next()", new Object[0]).nextControlFlow("else if (setTypes.isEmpty())", new Object[0]).addStatement("this.type = Type.UNKNOWN_TO_SDK_VERSION", new Object[0]).nextControlFlow("else", new Object[0]).addStatement("this.type = null", new Object[0]).endControlFlow().build();
        return MethodSpec.methodBuilder((String)"handleUnionValueChange").addModifiers(new Modifier[]{Modifier.PRIVATE, Modifier.FINAL}).returns(Void.TYPE).addParameter((TypeName)this.shapeModelSpec.className().nestedClass("Type"), "type", new Modifier[0]).addParameter(Object.class, "oldValue", new Modifier[0]).addParameter(Object.class, "newValue", new Modifier[0]).addCode(body).build();
    }
}

